/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.gmssl.AbstractTlsServer;
import com.bes.enterprise.cipher.gmssl.DefaultTlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedDecryptor;
import com.bes.enterprise.cipher.gmssl.TlsCredentials;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchange;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.TlsPSKIdentityManager;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.TlsDHConfig;
import com.bes.enterprise.cipher.gmssl.crypto.TlsECConfig;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    public static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;
    protected int[] supportedCipherSuites;

    public PSKTlsServer(TlsCrypto crypto, TlsPSKIdentityManager pskIdentityManager) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), pskIdentityManager);
    }

    public PSKTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsPSKIdentityManager pskIdentityManager) {
        super(crypto, keyExchangeFactory);
        this.pskIdentityManager = pskIdentityManager;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 14: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, this.selectDHConfig(), null);
            }
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, this.selectECConfig());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfig dhConfig, TlsECConfig ecConfig) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentityManager, dhConfig, ecConfig, this.serverECPointFormats);
    }
}

