/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.DigestInputBuffer;
import com.bes.enterprise.cipher.gmssl.DigitallySigned;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.TlsCredentials;
import com.bes.enterprise.cipher.gmssl.TlsECCUtils;
import com.bes.enterprise.cipher.gmssl.TlsECConfigVerifier;
import com.bes.enterprise.cipher.gmssl.TlsECDHKeyExchange;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsECConfig;
import com.bes.enterprise.cipher.gmssl.crypto.TlsVerifier;
import com.bes.enterprise.cipher.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsVerifier verifier = null;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 17: 
            case 19: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(TlsECDHEKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms, ecConfigVerifier, clientECPointFormats, serverECPointFormats);
    }

    public TlsECDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfig ecConfig, short[] serverECPointFormats) {
        super(TlsECDHEKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms, ecConfig, serverECPointFormats);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedSigner)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.verifier = serverCertificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer buf = new DigestInputBuffer();
        TlsECCUtils.writeECConfig(this.ecConfig, buf);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(buf);
        DigitallySigned signedParams = TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, buf);
        signedParams.encode(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer buf = new DigestInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, buf);
        this.ecConfig = TlsECCUtils.receiveECConfig(this.ecConfigVerifier, this.serverECPointFormats, teeIn);
        byte[] point = TlsUtils.readOpaque8(teeIn);
        DigitallySigned signedParams = this.parseSignature(input);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, this.verifier, buf, signedParams);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(this.clientECPointFormats, point);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }
}

