/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.asn1.ASN1Encodable;
import com.bes.enterprise.cipher.asn1.ASN1InputStream;
import com.bes.enterprise.cipher.asn1.ASN1Integer;
import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.ASN1Primitive;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.DEROctetString;
import com.bes.enterprise.cipher.asn1.DERSequence;
import com.bes.enterprise.cipher.asn1.bsi.BSIObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.eac.EACObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.nist.NISTObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.x509.X509ObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.x9.X9ObjectIdentifiers;
import com.bes.enterprise.cipher.crypto.params.ECPublicKeyParameters;
import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.CertificateRequest;
import com.bes.enterprise.cipher.gmssl.CertificateStatus;
import com.bes.enterprise.cipher.gmssl.CombinedHash;
import com.bes.enterprise.cipher.gmssl.DigestInputBuffer;
import com.bes.enterprise.cipher.gmssl.DigitallySigned;
import com.bes.enterprise.cipher.gmssl.HashAlgorithm;
import com.bes.enterprise.cipher.gmssl.MACAlgorithm;
import com.bes.enterprise.cipher.gmssl.PRFAlgorithm;
import com.bes.enterprise.cipher.gmssl.ProtocolVersion;
import com.bes.enterprise.cipher.gmssl.SecurityParameters;
import com.bes.enterprise.cipher.gmssl.SessionParameters;
import com.bes.enterprise.cipher.gmssl.SignatureAlgorithm;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsAuthentication;
import com.bes.enterprise.cipher.gmssl.TlsContext;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsHandshakeHash;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchange;
import com.bes.enterprise.cipher.gmssl.TlsObjectIdentifiers;
import com.bes.enterprise.cipher.gmssl.TlsProtocol;
import com.bes.enterprise.cipher.gmssl.TlsServerCertificateImpl;
import com.bes.enterprise.cipher.gmssl.TlsSession;
import com.bes.enterprise.cipher.gmssl.TlsSessionImpl;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.TlsHash;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.TlsStreamSigner;
import com.bes.enterprise.cipher.gmssl.crypto.TlsStreamVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.TlsVerifier;
import com.bes.enterprise.cipher.util.Arrays;
import com.bes.enterprise.cipher.util.Integers;
import com.bes.enterprise.cipher.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TlsUtils {
    private static final Hashtable sigHashAlgs = TlsUtils.createSigHashAlgs();
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    protected static short MINIMUM_HASH_STRICT = (short)2;
    protected static short MINIMUM_HASH_PREFERRED = (short)4;
    static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    public static final int SM3_DIGEST_LENGTH = 32;

    private static void addSigHashAlg(Hashtable h, ASN1ObjectIdentifier oid, short hashAlg) {
        h.put(oid.getId(), hashAlg);
    }

    private static Hashtable createSigHashAlgs() {
        Hashtable h = new Hashtable();
        TlsUtils.addSigHashAlg(h, NISTObjectIdentifiers.dsa_with_sha224, (short)3);
        TlsUtils.addSigHashAlg(h, NISTObjectIdentifiers.dsa_with_sha256, (short)4);
        TlsUtils.addSigHashAlg(h, NISTObjectIdentifiers.dsa_with_sha384, (short)5);
        TlsUtils.addSigHashAlg(h, NISTObjectIdentifiers.dsa_with_sha512, (short)6);
        TlsUtils.addSigHashAlg(h, OIWObjectIdentifiers.dsaWithSHA1, (short)2);
        TlsUtils.addSigHashAlg(h, OIWObjectIdentifiers.md5WithRSA, (short)1);
        TlsUtils.addSigHashAlg(h, OIWObjectIdentifiers.sha1WithRSA, (short)2);
        TlsUtils.addSigHashAlg(h, PKCSObjectIdentifiers.md5WithRSAEncryption, (short)1);
        TlsUtils.addSigHashAlg(h, PKCSObjectIdentifiers.sha1WithRSAEncryption, (short)2);
        TlsUtils.addSigHashAlg(h, PKCSObjectIdentifiers.sha224WithRSAEncryption, (short)3);
        TlsUtils.addSigHashAlg(h, PKCSObjectIdentifiers.sha256WithRSAEncryption, (short)4);
        TlsUtils.addSigHashAlg(h, PKCSObjectIdentifiers.sha384WithRSAEncryption, (short)5);
        TlsUtils.addSigHashAlg(h, PKCSObjectIdentifiers.sha512WithRSAEncryption, (short)6);
        TlsUtils.addSigHashAlg(h, X9ObjectIdentifiers.ecdsa_with_SHA1, (short)2);
        TlsUtils.addSigHashAlg(h, X9ObjectIdentifiers.ecdsa_with_SHA224, (short)3);
        TlsUtils.addSigHashAlg(h, X9ObjectIdentifiers.ecdsa_with_SHA256, (short)4);
        TlsUtils.addSigHashAlg(h, X9ObjectIdentifiers.ecdsa_with_SHA384, (short)5);
        TlsUtils.addSigHashAlg(h, X9ObjectIdentifiers.ecdsa_with_SHA512, (short)6);
        TlsUtils.addSigHashAlg(h, X9ObjectIdentifiers.id_dsa_with_sha1, (short)2);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_1, (short)2);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_224, (short)3);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_256, (short)4);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_384, (short)5);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_512, (short)6);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, (short)2);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, (short)4);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1, (short)2);
        TlsUtils.addSigHashAlg(h, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256, (short)4);
        TlsUtils.addSigHashAlg(h, BSIObjectIdentifiers.ecdsa_plain_SHA1, (short)2);
        TlsUtils.addSigHashAlg(h, BSIObjectIdentifiers.ecdsa_plain_SHA224, (short)3);
        TlsUtils.addSigHashAlg(h, BSIObjectIdentifiers.ecdsa_plain_SHA256, (short)4);
        TlsUtils.addSigHashAlg(h, BSIObjectIdentifiers.ecdsa_plain_SHA384, (short)5);
        TlsUtils.addSigHashAlg(h, BSIObjectIdentifiers.ecdsa_plain_SHA512, (short)6);
        return h;
    }

    public static void checkUint8(short i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int i) throws IOException {
        if (!TlsUtils.isValidUint16(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long i) throws IOException {
        if (!TlsUtils.isValidUint16(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int i) throws IOException {
        if (!TlsUtils.isValidUint24(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long i) throws IOException {
        if (!TlsUtils.isValidUint24(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long i) throws IOException {
        if (!TlsUtils.isValidUint32(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long i) throws IOException {
        if (!TlsUtils.isValidUint48(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long i) throws IOException {
        if (!TlsUtils.isValidUint64(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint8(int i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint8(long i) {
        return (i & 0xFFL) == i;
    }

    public static boolean isValidUint16(int i) {
        return (i & 0xFFFF) == i;
    }

    public static boolean isValidUint16(long i) {
        return (i & 0xFFFFL) == i;
    }

    public static boolean isValidUint24(int i) {
        return (i & 0xFFFFFF) == i;
    }

    public static boolean isValidUint24(long i) {
        return (i & 0xFFFFFFL) == i;
    }

    public static boolean isValidUint32(long i) {
        return (i & 0xFFFFFFFFL) == i;
    }

    public static boolean isValidUint48(long i) {
        return (i & 0xFFFFFFFFFFFFL) == i;
    }

    public static boolean isValidUint64(long i) {
        return true;
    }

    public static boolean isGMSSL(ProtocolVersion version) {
        return ProtocolVersion.GMSSLv11.equals(version);
    }

    public static void writeUint8(short i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(int i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(short i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint8(int i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint16(int i, OutputStream output) throws IOException {
        output.write(i >>> 8);
        output.write(i);
    }

    public static void writeUint16(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 8);
        buf[offset + 1] = (byte)i;
    }

    public static void writeUint24(int i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint24(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 16);
        buf[offset + 1] = (byte)(i >>> 8);
        buf[offset + 2] = (byte)i;
    }

    public static void writeUint32(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint32(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 24);
        buf[offset + 1] = (byte)(i >>> 16);
        buf[offset + 2] = (byte)(i >>> 8);
        buf[offset + 3] = (byte)i;
    }

    public static void writeUint48(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 40));
        output.write((byte)(i >>> 32));
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint48(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 40);
        buf[offset + 1] = (byte)(i >>> 32);
        buf[offset + 2] = (byte)(i >>> 24);
        buf[offset + 3] = (byte)(i >>> 16);
        buf[offset + 4] = (byte)(i >>> 8);
        buf[offset + 5] = (byte)i;
    }

    public static void writeUint64(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 56));
        output.write((byte)(i >>> 48));
        output.write((byte)(i >>> 40));
        output.write((byte)(i >>> 32));
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint64(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 56);
        buf[offset + 1] = (byte)(i >>> 48);
        buf[offset + 2] = (byte)(i >>> 40);
        buf[offset + 3] = (byte)(i >>> 32);
        buf[offset + 4] = (byte)(i >>> 24);
        buf[offset + 5] = (byte)(i >>> 16);
        buf[offset + 6] = (byte)(i >>> 8);
        buf[offset + 7] = (byte)i;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint8(buf.length);
        TlsUtils.writeUint8(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint16(buf.length);
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint24(buf.length);
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint8(uints[i], output);
        }
    }

    public static void writeUint8Array(short[] uints, byte[] buf, int offset) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint8(uints[i], buf, offset);
            ++offset;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, OutputStream output) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, output);
        TlsUtils.writeUint8Array(uints, output);
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, byte[] buf, int offset) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, buf, offset);
        TlsUtils.writeUint8Array(uints, buf, offset + 1);
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint16(uints[i], output);
        }
    }

    public static void writeUint16Array(int[] uints, byte[] buf, int offset) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint16(uints[i], buf, offset);
            offset += 2;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, OutputStream output) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        TlsUtils.writeUint16Array(uints, output);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, byte[] buf, int offset) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 2);
    }

    public static short decodeUint8(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 1) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8(buf, 0);
    }

    public static short[] decodeUint8ArrayWithUint8Length(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        int count = TlsUtils.readUint8(buf, 0);
        if (buf.length != count + 1) {
            throw new TlsFatalAlert(50);
        }
        short[] uints = new short[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint8(buf, i + 1);
        }
        return uints;
    }

    public static byte[] encodeOpaque8(byte[] buf) throws IOException {
        TlsUtils.checkUint8(buf.length);
        return Arrays.prepend(buf, (byte)buf.length);
    }

    public static byte[] encodeUint8(short uint) throws IOException {
        TlsUtils.checkUint8(uint);
        byte[] extensionData = new byte[1];
        TlsUtils.writeUint8(uint, extensionData, 0);
        return extensionData;
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] uints) throws IOException {
        byte[] result = new byte[1 + uints.length];
        TlsUtils.writeUint8ArrayWithUint8Length(uints, result, 0);
        return result;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] uints) throws IOException {
        int length = 2 * uints.length;
        byte[] result = new byte[2 + length];
        TlsUtils.writeUint16ArrayWithUint16Length(uints, result, 0);
        return result;
    }

    public static short readUint8(InputStream input) throws IOException {
        int i = input.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (short)i;
    }

    public static short readUint8(byte[] buf, int offset) {
        return (short)(buf[offset] & 0xFF);
    }

    public static int readUint16(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        if (i3 < 0) {
            throw new EOFException();
        }
        return i1 << 16 | i2 << 8 | i3;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        int i4 = input.read();
        if (i4 < 0) {
            throw new EOFException();
        }
        return (long)(i1 << 24 | i2 << 16 | i3 << 8 | i4) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 24;
        n |= (buf[++offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return (long)(n |= buf[++offset] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream input) throws IOException {
        int hi = TlsUtils.readUint24(input);
        int lo = TlsUtils.readUint24(input);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] buf, int offset) {
        int hi = TlsUtils.readUint24(buf, offset);
        int lo = TlsUtils.readUint24(buf, offset + 3);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        int read = Streams.readFully(input, buf);
        if (read == 0) {
            return null;
        }
        if (read != length) {
            throw new EOFException();
        }
        return buf;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        if (length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
        return buf;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int length = buf.length;
        if (length > 0 && length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short length = TlsUtils.readUint8(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int length = TlsUtils.readUint24(input);
        return TlsUtils.readFully(length, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] uints = new short[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint8(input);
        }
        return uints;
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] uints = new int[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint16(input);
        }
        return uints;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) throws IOException {
        return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(i1, i2);
    }

    public static int readVersionRaw(byte[] buf, int offset) throws IOException {
        return buf[offset] << 8 | buf[offset + 1];
    }

    public static int readVersionRaw(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static ASN1Primitive readASN1Object(byte[] encoding) throws IOException {
        ASN1InputStream asn1 = new ASN1InputStream(encoding);
        ASN1Primitive result = asn1.readObject();
        if (null == result) {
            throw new TlsFatalAlert(50);
        }
        if (null != asn1.readObject()) {
            throw new TlsFatalAlert(50);
        }
        return result;
    }

    public static ASN1Primitive readDERObject(byte[] encoding) throws IOException {
        ASN1Primitive result = TlsUtils.readASN1Object(encoding);
        byte[] check = result.getEncoded("DER");
        if (!Arrays.areEqual(check, encoding)) {
            throw new TlsFatalAlert(50);
        }
        return result;
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int t = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(t >>> 24);
        buf[offset + 1] = (byte)(t >>> 16);
        buf[offset + 2] = (byte)(t >>> 8);
        buf[offset + 3] = (byte)t;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static Vector getAllSignatureAlgorithms() {
        Vector<Short> v = new Vector<Short>(4);
        v.addElement((short)0);
        v.addElement((short)1);
        v.addElement((short)2);
        v.addElement((short)3);
        v.addElement((short)4);
        return v;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 2));
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 3));
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 1));
    }

    public static Vector getDefaultSM2SignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(7, 4));
    }

    public static Vector getDefaultSignatureAlgorithms(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 2: {
                return TlsUtils.getDefaultDSSSignatureAlgorithms();
            }
            case 3: {
                return TlsUtils.getDefaultECDSASignatureAlgorithms();
            }
            case 1: {
                return TlsUtils.getDefaultRSASignatureAlgorithms();
            }
            case 4: {
                return TlsUtils.getDefaultSM2SignatureAlgorithms();
            }
        }
        throw new IllegalArgumentException("unknown SignatureAlgorithm: " + SignatureAlgorithm.getText(signatureAlgorithm));
    }

    public static Vector getDefaultSupportedSignatureAlgorithms(TlsContext context) {
        TlsCrypto crypto = context.getCrypto();
        short[] hashAlgorithms = new short[]{2, 7};
        short[] signatureAlgorithms = new short[]{1, 2, 3, 4};
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>();
        for (int i = 0; i < signatureAlgorithms.length; ++i) {
            for (int j = 0; j < hashAlgorithms.length; ++j) {
                SignatureAndHashAlgorithm alg = new SignatureAndHashAlgorithm(hashAlgorithms[j], signatureAlgorithms[i]);
                if (!crypto.hasSignatureAndHashAlgorithm(alg)) continue;
                result.addElement(alg);
            }
        }
        return result;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext context, TlsCredentialedSigner signerCredentials) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isGMSSL(context.getServerVersion()) && (signatureAndHashAlgorithm = signerCredentials.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable extensions, Integer extensionType) {
        return extensions == null ? null : (byte[])extensions.get(extensionType);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable extensions, Integer extensionType, short alertDescription) throws IOException {
        byte[] extension_data = TlsUtils.getExtensionData(extensions, extensionType);
        if (extension_data == null) {
            return false;
        }
        if (extension_data.length != 0) {
            throw new TlsFatalAlert(alertDescription);
        }
        return true;
    }

    public static TlsSession importSession(byte[] sessionID, SessionParameters sessionParameters) {
        return new TlsSessionImpl(sessionID, sessionParameters);
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion clientVersion) {
        return TlsUtils.isGMSSL(clientVersion) || ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(clientVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable extensions, Vector supportedSignatureAlgorithms) throws IOException {
        extensions.put(EXT_signature_algorithms, TlsUtils.createSignatureAlgorithmsExtension(supportedSignatureAlgorithms));
    }

    public static short getSignatureAlgorithm(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 25: {
                return 4;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 22: {
                return 2;
            }
            case 16: 
            case 17: {
                return 3;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    public static short getSignatureAlgorithmClient(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_signature_algorithms);
        return extensionData == null ? null : TlsUtils.readSignatureAlgorithmsExtension(extensionData);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector supportedSignatureAlgorithms) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.encodeSupportedSignatureAlgorithms(supportedSignatureAlgorithms, false, buf);
        return buf.toByteArray();
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        Vector supported_signature_algorithms = TlsUtils.parseSupportedSignatureAlgorithms(false, buf);
        TlsProtocol.assertEmpty(buf);
        return supported_signature_algorithms;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, boolean allowAnonymous, OutputStream output) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int length = 2 * supportedSignatureAlgorithms.size();
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (!allowAnonymous && entry.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            entry.encode(output);
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(boolean allowAnonymous, InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int count = length / 2;
        Vector<SignatureAndHashAlgorithm> supportedSignatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(count);
        for (int i = 0; i < count; ++i) {
            SignatureAndHashAlgorithm entry = SignatureAndHashAlgorithm.parse(input);
            if (!allowAnonymous && entry.getSignature() == 0) {
                throw new TlsFatalAlert(47);
            }
            supportedSignatureAlgorithms.addElement(entry);
        }
        return supportedSignatureAlgorithms;
    }

    public static void verifySupportedSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAlgorithm.getSignature() != 0) {
            for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
                SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
                if (entry.getHash() != signatureAlgorithm.getHash() || entry.getSignature() != signatureAlgorithm.getSignature()) continue;
                return;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsSecret PRF(TlsContext context, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        int prfAlgorithm = context.getSecurityParameters().getPrfAlgorithm();
        return secret.deriveUsingPRF(prfAlgorithm, asciiLabel, seed, length);
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    static byte[] calculateEndPointHash(TlsContext context, String sigAlgOID, byte[] enc) {
        return TlsUtils.calculateEndPointHash(context, sigAlgOID, enc, 0, enc.length);
    }

    static byte[] calculateEndPointHash(TlsContext context, String sigAlgOID, byte[] enc, int encOff, int encLen) {
        Short hashAlgObj;
        if (sigAlgOID != null && (hashAlgObj = (Short)sigHashAlgs.get(sigAlgOID)) != null) {
            short hashAlg = hashAlgObj;
            switch (hashAlg) {
                case 1: 
                case 2: {
                    hashAlg = 4;
                }
            }
            TlsHash hash = context.getCrypto().createHash(hashAlg);
            if (hash != null) {
                hash.update(enc, encOff, encLen);
                return hash.calculateHash();
            }
        }
        return EMPTY_BYTES;
    }

    static TlsSecret calculateMasterSecret(TlsContext context, TlsSecret preMasterSecret) {
        byte[] seed;
        String asciiLabel;
        if (context.getSecurityParameters().isExtendedMasterSecret()) {
            asciiLabel = "extended master secret";
            seed = context.getSecurityParameters().getSessionHash();
        } else {
            asciiLabel = "master secret";
            seed = TlsUtils.concat(context.getSecurityParameters().getClientRandom(), context.getSecurityParameters().getServerRandom());
        }
        return TlsUtils.PRF(context, preMasterSecret, asciiLabel, seed, 48);
    }

    static byte[] calculateTLSVerifyData(TlsContext context, TlsHandshakeHash handshakeHash, boolean isServer) {
        String asciiLabel = isServer ? "server finished" : "client finished";
        byte[] prfHash = TlsUtils.getCurrentPRFHash(handshakeHash);
        return TlsUtils.calculateTLSVerifyData(context, asciiLabel, prfHash);
    }

    static byte[] calculateTLSVerifyData(TlsContext context, String asciiLabel, byte[] prfHash) {
        SecurityParameters securityParameters = context.getSecurityParameters();
        TlsSecret master_secret = securityParameters.getMasterSecret();
        int verify_data_length = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(context, master_secret, asciiLabel, prfHash, verify_data_length).extract();
    }

    public static short getHashAlgorithmForHMACAlgorithm(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified MACAlgorithm not an HMAC: " + MACAlgorithm.getText(macAlgorithm));
    }

    public static short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(prfAlgorithm));
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    static byte[] calculateSignatureHash(TlsContext context, SignatureAndHashAlgorithm algorithm, DigestInputBuffer buf) {
        TlsCrypto crypto = context.getCrypto();
        TlsHash h = algorithm == null ? new CombinedHash(crypto) : crypto.createHash(algorithm.getHash());
        SecurityParameters securityParameters = context.getSecurityParameters();
        h.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        h.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        buf.updateDigest(h);
        return h.calculateHash();
    }

    static byte[] calculateGMSignatureHash(TlsContext context, Certificate certificate, DigestInputBuffer buf) {
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] result = TlsUtils.concat(securityParameters.clientRandom, securityParameters.serverRandom);
        try {
            TlsCertificate rootCert = certificate.getCertificateAt(1);
            byte[] hash_in = rootCert.getEncoded();
            byte[] hash_len = new byte[3];
            TlsUtils.writeUint24(hash_in.length, hash_len, 0);
            result = TlsUtils.concat(result, hash_len);
            result = TlsUtils.concat(result, hash_in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static byte[] calculateGMSignatureHashBP(TlsContext context, Certificate certificate, DigestInputBuffer buf) {
        TlsCrypto crypto = context.getCrypto();
        TlsHash h = crypto.createHash((short)7);
        SecurityParameters securityParameters = context.getSecurityParameters();
        h.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        h.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        try {
            TlsCertificate cert = certificate.getCertificateAt(0);
            byte[] hash_in = cert.getEncoded();
            byte[] hash_len = new byte[3];
            TlsUtils.writeUint24(hash_in.length, hash_len, 0);
            h.update(hash_len, 0, 3);
            h.update(hash_in, 0, hash_in.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return h.calculateHash();
    }

    static void sendSignatureInput(TlsContext context, DigestInputBuffer buf, OutputStream output) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParameters();
        output.write(Arrays.concatenate(securityParameters.clientRandom, securityParameters.serverRandom));
        buf.copyTo(output);
        output.close();
    }

    static DigitallySigned generateCertificateVerify(TlsContext context, TlsCredentialedSigner credentialedSigner, TlsStreamSigner streamSigner, TlsHandshakeHash handshakeHash) throws IOException {
        byte[] signature;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(context, credentialedSigner);
        if (streamSigner != null) {
            handshakeHash.copyBufferTo(streamSigner.getOutputStream());
            signature = streamSigner.getSignature();
        } else {
            byte[] hash = signatureAndHashAlgorithm == null ? context.getSecurityParameters().getSessionHash() : handshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            signature = credentialedSigner.generateRawSignature(hash);
        }
        return new DigitallySigned(signatureAndHashAlgorithm, signature);
    }

    static void verifyCertificateVerify(TlsContext context, CertificateRequest certificateRequest, Certificate certificate, DigitallySigned certificateVerify, TlsHandshakeHash handshakeHash) throws IOException {
        boolean verified;
        short certificateType = certificate.getCertificateAt(0).getClientCertificateType();
        try {
            TlsVerifier verifier = certificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithmClient(certificateType));
            TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(certificateVerify);
            if (streamVerifier != null) {
                handshakeHash.copyBufferTo(streamVerifier.getOutputStream());
                verified = streamVerifier.isVerified();
            } else {
                byte[] hash = handshakeHash.getFinalHash(certificateVerify.getAlgorithm().getHash());
                verified = verifier.verifyRawSignature(certificateVerify, hash);
            }
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static DigitallySigned generateServerKeyExchangeSignature(TlsContext context, TlsCredentialedSigner credentials, DigestInputBuffer buf) throws IOException {
        byte[] signature;
        SignatureAndHashAlgorithm algorithm = TlsUtils.getSignatureAndHashAlgorithm(context, credentials);
        TlsStreamSigner streamSigner = credentials.getStreamSigner();
        if (streamSigner != null) {
            TlsUtils.sendSignatureInput(context, buf, streamSigner.getOutputStream());
            signature = streamSigner.getSignature();
        } else {
            byte[] hash = TlsUtils.calculateSignatureHash(context, algorithm, buf);
            signature = credentials.generateRawSignature(hash);
        }
        return new DigitallySigned(algorithm, signature);
    }

    static DigitallySigned generateGMServerKeyExchangeSignature(TlsContext context, TlsCredentialedSigner credentials, DigestInputBuffer buf) throws IOException {
        byte[] signature;
        SignatureAndHashAlgorithm algorithm = TlsUtils.getSignatureAndHashAlgorithm(context, credentials);
        TlsStreamSigner streamSigner = credentials.getStreamSigner();
        if (streamSigner != null) {
            TlsUtils.sendSignatureInput(context, buf, streamSigner.getOutputStream());
            signature = streamSigner.getSignature();
        } else {
            byte[] hash = TlsUtils.calculateGMSignatureHash(context, credentials.getCertificate(), buf);
            signature = credentials.generateRawSignature(hash);
        }
        return new DigitallySigned(algorithm, signature);
    }

    static void verifyServerKeyExchangeSignature(TlsContext context, TlsVerifier verifier, DigestInputBuffer buf, DigitallySigned signedParams) throws IOException {
        boolean verified;
        TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(signedParams);
        if (streamVerifier != null) {
            TlsUtils.sendSignatureInput(context, buf, streamVerifier.getOutputStream());
            verified = streamVerifier.isVerified();
        } else {
            byte[] hash = TlsUtils.calculateSignatureHash(context, signedParams.getAlgorithm(), buf);
            verified = verifier.verifyRawSignature(signedParams, hash);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static void verifyGMServerKeyExchangeSignature(TlsContext context, Certificate serverCertificate, TlsVerifier verifier, DigestInputBuffer buf, DigitallySigned signedParams) throws IOException {
        boolean verified;
        TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(signedParams);
        if (streamVerifier != null) {
            TlsUtils.sendSignatureInput(context, buf, streamVerifier.getOutputStream());
            verified = streamVerifier.isVerified();
        } else {
            byte[] hash = TlsUtils.calculateGMSignatureHash(context, serverCertificate, buf);
            verified = verifier.verifyRawSignature(signedParams, hash);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static void trackHashAlgorithms(TlsHandshakeHash handshakeHash, Vector supportedSignatureAlgorithms) {
        if (supportedSignatureAlgorithms != null) {
            for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
                short hashAlgorithm = signatureAndHashAlgorithm.getHash();
                if (HashAlgorithm.isPrivate(hashAlgorithm)) continue;
                handshakeHash.trackHashAlgorithm(hashAlgorithm);
            }
        }
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    private static Vector vectorOfOne(Object obj) {
        Vector<Object> v = new Vector<Object>(1);
        v.addElement(obj);
        return v;
    }

    public static int getCipherType(int cipherSuite) {
        switch (TlsUtils.getEncryptionAlgorithm(cipherSuite)) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 103: 
            case 104: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    public static int getEncryptionAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 57363: {
                return 105;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 139: 
            case 143: 
            case 147: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: 
            case 49175: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49204: {
                return 7;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 108: 
            case 140: 
            case 144: 
            case 148: 
            case 174: 
            case 178: 
            case 182: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: 
            case 49176: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49205: 
            case 49207: {
                return 8;
            }
            case 49308: 
            case 49310: 
            case 49316: 
            case 49318: 
            case 49324: 
            case 53253: {
                return 15;
            }
            case 49312: 
            case 49314: 
            case 49320: 
            case 49322: 
            case 49326: 
            case 53251: {
                return 16;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 53249: {
                return 10;
            }
            case 65280: 
            case 65282: 
            case 65284: 
            case 65296: 
            case 65298: 
            case 65300: {
                return 103;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 141: 
            case 145: 
            case 149: 
            case 175: 
            case 179: 
            case 183: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: 
            case 49177: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49206: 
            case 49208: {
                return 9;
            }
            case 49309: 
            case 49311: 
            case 49317: 
            case 49319: 
            case 49325: {
                return 17;
            }
            case 49313: 
            case 49315: 
            case 49321: 
            case 49323: 
            case 49327: {
                return 18;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 53250: {
                return 11;
            }
            case 65281: 
            case 65283: 
            case 65285: 
            case 65297: 
            case 65299: 
            case 65301: {
                return 104;
            }
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: {
                return 22;
            }
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49258: 
            case 49260: 
            case 49262: {
                return 24;
            }
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: {
                return 23;
            }
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49259: 
            case 49261: 
            case 49263: {
                return 25;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 12;
            }
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: {
                return 19;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 13;
            }
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                return 20;
            }
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: {
                return 21;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 44: 
            case 45: 
            case 46: 
            case 49153: 
            case 49158: 
            case 49163: 
            case 49168: 
            case 49173: 
            case 49209: {
                return 0;
            }
            case 59: 
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return 0;
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return 0;
            }
            case 4: 
            case 24: {
                return 2;
            }
            case 5: 
            case 138: 
            case 142: 
            case 146: 
            case 49154: 
            case 49159: 
            case 49164: 
            case 49169: 
            case 49174: 
            case 49203: {
                return 2;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                return 14;
            }
        }
        return -1;
    }

    public static int getKeyExchangeAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 57363: {
                return 25;
            }
            case 24: 
            case 27: 
            case 52: 
            case 58: 
            case 70: 
            case 108: 
            case 109: 
            case 137: 
            case 155: 
            case 166: 
            case 167: 
            case 191: 
            case 197: 
            case 49222: 
            case 49223: 
            case 49242: 
            case 49243: 
            case 49284: 
            case 49285: {
                return 11;
            }
            case 13: 
            case 48: 
            case 54: 
            case 62: 
            case 66: 
            case 104: 
            case 133: 
            case 151: 
            case 164: 
            case 165: 
            case 187: 
            case 193: 
            case 49214: 
            case 49215: 
            case 49240: 
            case 49241: 
            case 49282: 
            case 49283: {
                return 7;
            }
            case 16: 
            case 49: 
            case 55: 
            case 63: 
            case 67: 
            case 105: 
            case 134: 
            case 152: 
            case 160: 
            case 161: 
            case 188: 
            case 194: 
            case 49216: 
            case 49217: 
            case 49236: 
            case 49237: 
            case 49278: 
            case 49279: {
                return 9;
            }
            case 19: 
            case 50: 
            case 56: 
            case 64: 
            case 68: 
            case 106: 
            case 135: 
            case 153: 
            case 162: 
            case 163: 
            case 189: 
            case 195: 
            case 49218: 
            case 49219: 
            case 49238: 
            case 49239: 
            case 49280: 
            case 49281: {
                return 3;
            }
            case 45: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49254: 
            case 49255: 
            case 49260: 
            case 49261: 
            case 49296: 
            case 49297: 
            case 49302: 
            case 49303: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 52397: 
            case 65298: 
            case 65299: {
                return 14;
            }
            case 22: 
            case 51: 
            case 57: 
            case 69: 
            case 103: 
            case 107: 
            case 136: 
            case 154: 
            case 158: 
            case 159: 
            case 190: 
            case 196: 
            case 49220: 
            case 49221: 
            case 49234: 
            case 49235: 
            case 49276: 
            case 49277: 
            case 49310: 
            case 49311: 
            case 49314: 
            case 49315: 
            case 52394: 
            case 65280: 
            case 65281: {
                return 5;
            }
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: {
                return 20;
            }
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49189: 
            case 49190: 
            case 49197: 
            case 49198: 
            case 49226: 
            case 49227: 
            case 49246: 
            case 49247: 
            case 49268: 
            case 49269: 
            case 49288: 
            case 49289: {
                return 16;
            }
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49193: 
            case 49194: 
            case 49201: 
            case 49202: 
            case 49230: 
            case 49231: 
            case 49250: 
            case 49251: 
            case 49272: 
            case 49273: 
            case 49292: 
            case 49293: {
                return 18;
            }
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49187: 
            case 49188: 
            case 49195: 
            case 49196: 
            case 49224: 
            case 49225: 
            case 49244: 
            case 49245: 
            case 49266: 
            case 49267: 
            case 49286: 
            case 49287: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52393: 
            case 65284: 
            case 65285: {
                return 17;
            }
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49264: 
            case 49265: 
            case 49306: 
            case 49307: 
            case 52396: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65300: 
            case 65301: {
                return 24;
            }
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49191: 
            case 49192: 
            case 49199: 
            case 49200: 
            case 49228: 
            case 49229: 
            case 49248: 
            case 49249: 
            case 49270: 
            case 49271: 
            case 49290: 
            case 49291: 
            case 52392: 
            case 65282: 
            case 65283: {
                return 19;
            }
            case 44: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49252: 
            case 49253: 
            case 49258: 
            case 49259: 
            case 49294: 
            case 49295: 
            case 49300: 
            case 49301: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 52395: 
            case 65296: 
            case 65297: {
                return 13;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 47: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 132: 
            case 150: 
            case 156: 
            case 157: 
            case 186: 
            case 192: 
            case 49212: 
            case 49213: 
            case 49232: 
            case 49233: 
            case 49274: 
            case 49275: 
            case 49308: 
            case 49309: 
            case 49312: 
            case 49313: {
                return 1;
            }
            case 46: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 49256: 
            case 49257: 
            case 49262: 
            case 49263: 
            case 49298: 
            case 49299: 
            case 49304: 
            case 49305: 
            case 52398: {
                return 15;
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return 21;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return 22;
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return 23;
            }
        }
        return -1;
    }

    public static int getMACAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 57363: {
                return 6;
            }
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return 0;
            }
            case 1: 
            case 4: 
            case 24: {
                return 1;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49209: {
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 174: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49207: 
            case 49210: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 3;
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49208: 
            case 49211: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 4;
            }
        }
        return -1;
    }

    public static ProtocolVersion getMinimumVersion(int cipherSuite) {
        switch (cipherSuite) {
            case 57363: {
                return ProtocolVersion.GMSSLv11;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49212: 
            case 49213: 
            case 49214: 
            case 49215: 
            case 49216: 
            case 49217: 
            case 49218: 
            case 49219: 
            case 49220: 
            case 49221: 
            case 49222: 
            case 49223: 
            case 49224: 
            case 49225: 
            case 49226: 
            case 49227: 
            case 49228: 
            case 49229: 
            case 49230: 
            case 49231: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49252: 
            case 49253: 
            case 49254: 
            case 49255: 
            case 49256: 
            case 49257: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49264: 
            case 49265: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return ProtocolVersion.TLSv12;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static boolean isAEADCipherSuite(int cipherSuite) throws IOException {
        return 2 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isBlockCipherSuite(int cipherSuite) throws IOException {
        return 1 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isStreamCipherSuite(int cipherSuite) throws IOException {
        return 0 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int cipherSuite, Vector sigAlgs) {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        switch (keyExchangeAlgorithm) {
            case 25: {
                return sigAlgs.contains((short)4);
            }
            case 11: 
            case 12: 
            case 20: {
                return sigAlgs.contains((short)0);
            }
            case 5: 
            case 6: 
            case 19: 
            case 23: {
                return sigAlgs.contains((short)1);
            }
            case 3: 
            case 4: 
            case 22: {
                return sigAlgs.contains((short)2);
            }
            case 17: {
                return sigAlgs.contains((short)3);
            }
        }
        return true;
    }

    public static boolean isValidCipherSuiteForVersion(int cipherSuite, ProtocolVersion serverVersion) {
        return TlsUtils.getMinimumVersion(cipherSuite).isEqualOrEarlierVersionOf(serverVersion.getEquivalentTLSVersion());
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(TlsContext context, Vector sigHashAlgs, short signatureAlgorithm) throws IOException {
        if (!TlsUtils.isGMSSL(context.getServerVersion())) {
            return null;
        }
        if (sigHashAlgs == null) {
            sigHashAlgs = TlsUtils.getDefaultSignatureAlgorithms(signatureAlgorithm);
        }
        SignatureAndHashAlgorithm result = null;
        for (int i = 0; i < sigHashAlgs.size(); ++i) {
            short hash;
            SignatureAndHashAlgorithm sigHashAlg = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i);
            if (sigHashAlg.getSignature() != signatureAlgorithm || (hash = sigHashAlg.getHash()) < MINIMUM_HASH_STRICT) continue;
            if (result == null) {
                result = sigHashAlg;
                continue;
            }
            short current = result.getHash();
            if (current < MINIMUM_HASH_PREFERRED) {
                if (hash <= current) continue;
                result = sigHashAlg;
                continue;
            }
            if (hash < MINIMUM_HASH_PREFERRED || hash >= current) continue;
            result = sigHashAlg;
        }
        if (result == null) {
            throw new TlsFatalAlert(80);
        }
        return result;
    }

    public static Vector getUsableSignatureAlgorithms(Vector sigHashAlgs) {
        if (sigHashAlgs == null) {
            return TlsUtils.getAllSignatureAlgorithms();
        }
        Vector<Short> v = new Vector<Short>(4);
        v.addElement((short)0);
        for (int i = 0; i < sigHashAlgs.size(); ++i) {
            short sigAlg;
            SignatureAndHashAlgorithm sigHashAlg = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i);
            if (sigHashAlg.getHash() < MINIMUM_HASH_STRICT || v.contains(sigAlg = sigHashAlg.getSignature())) continue;
            v.addElement(sigAlg);
        }
        return v;
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] baseCipherSuiteList) {
        ArrayList<Integer> supported = new ArrayList<Integer>();
        for (int i = 0; i != baseCipherSuiteList.length; ++i) {
            if (!TlsUtils.isSupportedCipherSuite(crypto, baseCipherSuiteList[i])) continue;
            supported.add(baseCipherSuiteList[i]);
        }
        int[] rv = new int[supported.size()];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = (Integer)supported.get(i);
        }
        return rv;
    }

    public static boolean isSupportedCipherSuite(TlsCrypto crypto, int cipherSuite) {
        return TlsUtils.isSupportedKeyExchange(crypto, TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) && crypto.hasEncryptionAlgorithm(TlsUtils.getEncryptionAlgorithm(cipherSuite)) && crypto.hasMacAlgorithm(TlsUtils.getMACAlgorithm(cipherSuite));
    }

    public static boolean isStaticKeyAgreement(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSupportedKeyExchange(TlsCrypto crypto, int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 25: {
                return true;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                return crypto.hasDHAgreement();
            }
            case 3: 
            case 4: {
                return crypto.hasDHAgreement() && crypto.hasSignatureAlgorithm(2);
            }
            case 5: 
            case 6: {
                return crypto.hasDHAgreement() && crypto.hasSignatureAlgorithm(1);
            }
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                return crypto.hasECDHAgreement();
            }
            case 17: {
                return crypto.hasECDHAgreement() && crypto.hasSignatureAlgorithm(3);
            }
            case 19: {
                return crypto.hasECDHAgreement() && crypto.hasSignatureAlgorithm(1);
            }
            case 0: 
            case 13: {
                return true;
            }
            case 1: 
            case 2: 
            case 15: {
                return crypto.hasRSAEncryption();
            }
            case 21: {
                return crypto.hasSRPAuthentication();
            }
            case 22: {
                return crypto.hasSRPAuthentication() && crypto.hasSignatureAlgorithm(2);
            }
            case 23: {
                return crypto.hasSRPAuthentication() && crypto.hasSignatureAlgorithm(1);
            }
        }
        return false;
    }

    static byte[] getCurrentPRFHash(TlsHandshakeHash handshakeHash) {
        return handshakeHash.forkPRFHash().calculateHash();
    }

    static void sealHandshakeHash(TlsContext context, TlsHandshakeHash handshakeHash, boolean forceBuffering) {
        if (forceBuffering || !context.getCrypto().hasAllRawSignatureAlgorithms()) {
            handshakeHash.forceBuffering();
        }
        handshakeHash.sealHashAlgorithms();
    }

    static void checkTlsFeatures(Certificate serverCertificate, Hashtable clientExtensions, Hashtable serverExtensions) throws IOException {
        byte[] tlsFeatures = serverCertificate.getCertificateAt(0).getExtension(TlsObjectIdentifiers.id_pe_tlsfeature);
        if (tlsFeatures != null) {
            Enumeration tlsExtensions = ((ASN1Sequence)TlsUtils.readDERObject(tlsFeatures)).getObjects();
            while (tlsExtensions.hasMoreElements()) {
                Integer extensionType;
                BigInteger tlsExtension = ((ASN1Integer)tlsExtensions.nextElement()).getPositiveValue();
                if (tlsExtension.bitLength() > 16 || !clientExtensions.containsKey(extensionType = Integers.valueOf(tlsExtension.intValue())) || serverExtensions.containsKey(extensionType)) continue;
                throw new TlsFatalAlert(46);
            }
        }
    }

    static void processServerCertificate(Certificate serverCertificate, CertificateStatus serverCertificateStatus, TlsKeyExchange keyExchange, TlsAuthentication clientAuthentication, Hashtable clientExtensions, Hashtable serverExtensions) throws IOException {
        TlsUtils.checkTlsFeatures(serverCertificate, clientExtensions, serverExtensions);
        keyExchange.processServerCertificate(serverCertificate);
        clientAuthentication.notifyServerCertificate(new TlsServerCertificateImpl(serverCertificate, serverCertificateStatus));
    }

    static CertificateRequest validateCertificateRequest(CertificateRequest certificateRequest, TlsKeyExchange keyExchange) throws IOException {
        short[] validClientCertificateTypes = keyExchange.getClientCertificateTypes();
        if (validClientCertificateTypes == null || validClientCertificateTypes.length < 1) {
            throw new TlsFatalAlert(10);
        }
        if ((certificateRequest = TlsUtils.normalizeCertificateRequest(certificateRequest, validClientCertificateTypes)) == null) {
            throw new TlsFatalAlert(47);
        }
        return certificateRequest;
    }

    static CertificateRequest normalizeCertificateRequest(CertificateRequest certificateRequest, short[] validClientCertificateTypes) {
        if (TlsUtils.containsAll(validClientCertificateTypes, certificateRequest.getCertificateTypes())) {
            return certificateRequest;
        }
        short[] retained = TlsUtils.retainAll(certificateRequest.getCertificateTypes(), validClientCertificateTypes);
        if (retained.length < 1) {
            return null;
        }
        return new CertificateRequest(retained, certificateRequest.getSupportedSignatureAlgorithms(), certificateRequest.getCertificateAuthorities());
    }

    static boolean containsAll(short[] container, short[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (Arrays.contains(container, elements[i])) continue;
            return false;
        }
        return true;
    }

    static short[] retainAll(short[] retainer, short[] elements) {
        short[] retained = new short[Math.min(retainer.length, elements.length)];
        int count = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (!Arrays.contains(retainer, elements[i])) continue;
            retained[count++] = elements[i];
        }
        return TlsUtils.truncate(retained, count);
    }

    static short[] truncate(short[] a, int n) {
        if (n < a.length) {
            return a;
        }
        short[] t = new short[n];
        System.arraycopy(a, 0, t, 0, n);
        return t;
    }

    public static byte[] derEncodeSm2CipherText(byte[] cipherText, ECPublicKeyParameters pubKeyParams) throws IOException {
        int curveLength = (pubKeyParams.getParameters().getCurve().getFieldSize() + 7) / 8;
        return TlsUtils.derEncodeSm2CipherText(curveLength, 32, cipherText);
    }

    public static byte[] derEncodeSm2CipherText(int curveLength, int digestLength, byte[] cipherText) throws IOException {
        int startPos = 1;
        byte[] c1x = new byte[curveLength];
        System.arraycopy(cipherText, startPos, c1x, 0, c1x.length);
        byte[] c1y = new byte[curveLength];
        System.arraycopy(cipherText, startPos += c1x.length, c1y, 0, c1y.length);
        byte[] c2 = new byte[cipherText.length - c1x.length - c1y.length - 1 - digestLength];
        System.arraycopy(cipherText, startPos += c1y.length, c2, 0, c2.length);
        byte[] c3 = new byte[digestLength];
        System.arraycopy(cipherText, startPos += c2.length, c3, 0, c3.length);
        ASN1Encodable[] arr = new ASN1Encodable[]{new ASN1Integer(TlsUtils.formatASN1(c1x)), new ASN1Integer(TlsUtils.formatASN1(c1y)), new DEROctetString(c3), new DEROctetString(c2)};
        DERSequence ds = new DERSequence(arr);
        return ds.getEncoded("DER");
    }

    private static byte[] formatASN1(byte[] bytes) {
        if (bytes.length > 1) {
            byte[] tmp;
            if (bytes[0] == 0 && (bytes[1] & 0x80) == 0) {
                tmp = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, tmp, 0, tmp.length);
                bytes = TlsUtils.formatASN1(tmp);
            }
            if (bytes[0] == -1 && (bytes[1] & 0x80) != 0) {
                tmp = new byte[bytes.length + 1];
                System.arraycopy(bytes, 0, tmp, 1, bytes.length);
                bytes = TlsUtils.formatASN1(tmp);
            }
        }
        return bytes;
    }

    public static byte[] parseSm2CipherTextDer(byte[] derCipherText) throws IOException {
        ASN1Sequence as = DERSequence.getInstance(derCipherText);
        byte[] c1x = ((ASN1Integer)as.getObjectAt(0)).getValue().toByteArray();
        c1x = TlsUtils.formatCipherText(c1x);
        byte[] c1y = ((ASN1Integer)as.getObjectAt(1)).getValue().toByteArray();
        c1y = TlsUtils.formatCipherText(c1y);
        byte[] c3 = ((DEROctetString)as.getObjectAt(2)).getOctets();
        byte[] c2 = ((DEROctetString)as.getObjectAt(3)).getOctets();
        int pos = 0;
        byte[] cipherText = new byte[1 + c1x.length + c1y.length + c2.length + c3.length];
        int uncompressedFlag = 4;
        cipherText[0] = 4;
        System.arraycopy(c1x, 0, cipherText, ++pos, c1x.length);
        System.arraycopy(c1y, 0, cipherText, pos += c1x.length, c1y.length);
        System.arraycopy(c2, 0, cipherText, pos += c1y.length, c2.length);
        System.arraycopy(c3, 0, cipherText, pos += c2.length, c3.length);
        return cipherText;
    }

    private static byte[] formatCipherText(byte[] bytes) {
        if (bytes.length > 32) {
            byte[] tmp = new byte[32];
            System.arraycopy(bytes, bytes.length - 32, tmp, 0, 32);
            bytes = tmp;
        } else if (bytes.length < 32) {
            byte[] tmp = new byte[32];
            System.arraycopy(bytes, 0, tmp, 32 - bytes.length, bytes.length);
            bytes = tmp;
        }
        return bytes;
    }
}

