/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.bc;

import com.bes.enterprise.cipher.crypto.AsymmetricCipherKeyPair;
import com.bes.enterprise.cipher.crypto.params.ECPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPublicKeyParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsAgreement;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsECDomain;
import java.io.IOException;

public class BcTlsECDH
implements TlsAgreement {
    protected final BcTlsECDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected ECPublicKeyParameters peerPublicKey;

    public BcTlsECDH(BcTlsECDomain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((ECPublicKeyParameters)this.localKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateECDHAgreement((ECPrivateKeyParameters)this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

