/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.DigitallySigned;
import com.bes.enterprise.cipher.gmssl.crypto.TlsStreamVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.TlsVerifier;
import com.bes.enterprise.cipher.jcajce.spec.SM2ParameterSpec;
import com.bes.enterprise.cipher.jcajce.util.JcaJceHelper;
import com.bes.enterprise.cipher.util.Strings;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;

public class JcaGMSSLVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    private final ECPublicKey pubKey;

    protected JcaGMSSLVerifier(ECPublicKey pubKey, JcaJceHelper helper) {
        if (pubKey == null) {
            throw new IllegalArgumentException("'pubKey' cannot be null");
        }
        this.pubKey = pubKey;
        this.helper = helper;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        try {
            Signature signer = this.helper.createSignature("SM3WITHSM2");
            signer.setParameter(new SM2ParameterSpec(Strings.toByteArray("1234567812345678")));
            signer.initVerify(this.pubKey);
            signer.update(hash, 0, hash.length);
            return signer.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

