/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.HashAlgorithm;
import com.bes.enterprise.cipher.gmssl.SignatureAlgorithm;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import java.security.Provider;
import java.security.Security;

class JcaUtils {
    JcaUtils() {
    }

    static String getJcaAlgorithmName(SignatureAndHashAlgorithm algorithm) {
        return (HashAlgorithm.getName(algorithm.getHash()) + "WITH" + SignatureAlgorithm.getName(algorithm.getSignature())).toUpperCase();
    }

    static boolean isSunMSCAPIProviderActive() {
        return null != Security.getProvider("SunMSCAPI");
    }

    static boolean isSunMSCAPIProvider(Provider provider) {
        return null != provider && JcaUtils.isSunMSCAPIProviderName(provider.getName());
    }

    static boolean isSunMSCAPIProviderName(String providerName) {
        return "SunMSCAPI".equals(providerName);
    }
}

