/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.symmetric;

import com.bes.enterprise.cipher.crypto.CipherKeyGenerator;
import com.bes.enterprise.cipher.crypto.engines.XSalsa20Engine;
import com.bes.enterprise.cipher.jcajce.provider.config.ConfigurableProvider;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.bes.enterprise.cipher.jcajce.provider.util.AlgorithmProvider;

public final class XSalsa20 {
    private XSalsa20() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XSalsa20.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.XSALSA20", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.XSALSA20", PREFIX + "$KeyGen");
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XSalsa20", 256, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new XSalsa20Engine(), 24);
        }
    }
}

