/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jsse.provider;

import com.bes.enterprise.cipher.asn1.x500.X500Name;
import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.CertificateRequest;
import com.bes.enterprise.cipher.gmssl.CertificateStatusRequest;
import com.bes.enterprise.cipher.gmssl.DefaultTlsClient;
import com.bes.enterprise.cipher.gmssl.DefaultTlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.ProtocolVersion;
import com.bes.enterprise.cipher.gmssl.ServerName;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsAuthentication;
import com.bes.enterprise.cipher.gmssl.TlsCredentials;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsServerCertificate;
import com.bes.enterprise.cipher.gmssl.TlsSession;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import com.bes.enterprise.cipher.jsse.BCSNIServerName;
import com.bes.enterprise.cipher.jsse.provider.JsseUtils;
import com.bes.enterprise.cipher.jsse.provider.PropertyUtils;
import com.bes.enterprise.cipher.jsse.provider.ProvDHConfigVerifier;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLConnection;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLParameters;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLSessionContext;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLSessionImpl;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsManager;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsPeer;
import com.bes.enterprise.cipher.jsse.provider.SupportedGroups;
import com.bes.enterprise.cipher.util.Arrays;
import com.bes.enterprise.cipher.util.IPAddress;
import com.bes.enterprise.cipher.util.encoders.Hex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;

class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSessionImpl sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager manager, ProvSSLParameters sslParameters) {
        super(manager.getContextData().getCrypto(), new DefaultTlsKeyExchangeFactory(), new ProvDHConfigVerifier());
        this.manager = manager;
        this.sslParameters = sslParameters;
    }

    @Override
    protected CertificateStatusRequest getCertificateStatusRequest() {
        return null;
    }

    @Override
    protected Vector getSupportedGroups(boolean offeringDH, boolean offeringEC) {
        return SupportedGroups.getClientSupportedGroups(this.manager.getContext().isFips(), offeringDH, offeringEC);
    }

    @Override
    protected Vector getSNIServerNames() {
        if (provEnableSNIExtension) {
            List<BCSNIServerName> sniServerNames = this.sslParameters.getServerNames();
            if (sniServerNames == null) {
                String peerHost = this.manager.getPeerHost();
                if (peerHost != null && peerHost.indexOf(46) > 0 && !IPAddress.isValid(peerHost)) {
                    Vector<ServerName> serverNames = new Vector<ServerName>(1);
                    serverNames.addElement(new ServerName(0, peerHost));
                    return serverNames;
                }
            } else {
                Vector<ServerName> serverNames = new Vector<ServerName>(sniServerNames.size());
                for (BCSNIServerName sniServerName : sniServerNames) {
                    if (sniServerName.getType() != 0) continue;
                    try {
                        serverNames.addElement(new ServerName((short)sniServerName.getType(), new String(sniServerName.getEncoded(), "ASCII")));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.log(Level.WARNING, "Unable to include SNI server name", e);
                    }
                }
                if (!serverNames.isEmpty()) {
                    return serverNames;
                }
            }
        }
        return null;
    }

    @Override
    protected Vector getSupportedSignatureAlgorithms() {
        return JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                Socket socket;
                String alias;
                int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite);
                switch (keyExchangeAlgorithm) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return null;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: 
                    case 25: {
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(80);
                    }
                }
                X509KeyManager km = ProvTlsClient.this.manager.getContextData().getKeyManager();
                if (km == null) {
                    return null;
                }
                short[] certTypes = certificateRequest.getCertificateTypes();
                if (certTypes == null || certTypes.length == 0) {
                    return null;
                }
                String[] keyTypes = new String[certTypes.length];
                for (int i = 0; i < certTypes.length; ++i) {
                    keyTypes[i] = JsseUtils.getAuthTypeClient(certTypes[i]);
                }
                Principal[] issuers = null;
                Vector cas = certificateRequest.getCertificateAuthorities();
                if (cas != null && cas.size() > 0) {
                    X500Name[] names = cas.toArray(new X500Name[cas.size()]);
                    Set<X500Principal> principals = JsseUtils.toX500Principals(names);
                    issuers = principals.toArray(new Principal[principals.size()]);
                }
                if ((alias = km.chooseClientAlias(keyTypes, issuers, socket = null)) == null) {
                    return null;
                }
                TlsCrypto crypto = ProvTlsClient.this.getCrypto();
                if (!(crypto instanceof JcaTlsCrypto)) {
                    throw new UnsupportedOperationException();
                }
                PrivateKey privateKey = km.getPrivateKey(alias);
                Certificate certificate = JsseUtils.getCertificateMessage(crypto, km.getCertificateChain(alias));
                if (privateKey == null || certificate.isEmpty()) {
                    return null;
                }
                switch (keyExchangeAlgorithm) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)crypto, certificate, privateKey);
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: 
                    case 25: {
                        short certificateType = certificate.getCertificateAt(0).getClientCertificateType();
                        short signatureAlgorithm = TlsUtils.getSignatureAlgorithmClient(certificateType);
                        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(ProvTlsClient.this.context, ProvTlsClient.this.supportedSignatureAlgorithms, signatureAlgorithm);
                        return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(ProvTlsClient.this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
                    }
                }
                throw new TlsFatalAlert(80);
            }

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                String authType;
                boolean noServerCert;
                boolean bl = noServerCert = serverCertificate == null || serverCertificate.getCertificate() == null || serverCertificate.getCertificate().isEmpty();
                if (noServerCert) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] chain = JsseUtils.getX509CertificateChain(ProvTlsClient.this.manager.getContextData().getCrypto(), serverCertificate.getCertificate());
                if (!ProvTlsClient.this.manager.isServerTrusted(chain, authType = JsseUtils.getAuthTypeServer(TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite)))) {
                    throw new TlsFatalAlert(42);
                }
            }
        };
    }

    @Override
    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    @Override
    public short[] getCompressionMethods() {
        short[] sArray;
        if (this.manager.getContext().isFips()) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = super.getCompressionMethods();
        }
        return sArray;
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        return this.manager.getContext().getMinimumVersion(this.sslParameters.getProtocols());
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.manager.getContext().getMaximumVersion(this.sslParameters.getProtocols());
    }

    @Override
    public TlsSession getSessionToResume() {
        TlsSession sessionToResume;
        ProvSSLSessionContext sessionContext = this.manager.getContextData().getClientSessionContext();
        this.sslSession = sessionContext.getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
        if (this.sslSession != null && (sessionToResume = this.sslSession.getTlsSession()) != null) {
            return sessionToResume;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        Level level;
        super.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        Level level2 = alertLevel == 1 ? Level.FINE : (level = alertDescription == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client raised", alertLevel, alertDescription);
            if (message != null) {
                msg = msg + ": " + message;
            }
            LOG.log(level, msg, cause);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level level;
        super.notifyAlertReceived(alertLevel, alertDescription);
        Level level2 = level = alertLevel == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client received", alertLevel, alertDescription);
            LOG.log(level, msg);
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        TlsSession handshakeSession = this.context.getSession();
        if (this.sslSession == null || this.sslSession.getTlsSession() != handshakeSession) {
            this.sslSession = this.manager.getContextData().getClientSessionContext().reportSession(handshakeSession, this.manager.getPeerHost(), this.manager.getPeerPort());
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        boolean allowLegacyHelloMessages;
        if (!secureRenegotiation && !(allowLegacyHelloMessages = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.manager.getContext().validateNegotiatedCipherSuite(selectedCipherSuite);
        super.notifySelectedCipherSuite(selectedCipherSuite);
        LOG.fine("Client notified of selected cipher suite: " + this.manager.getContext().getCipherSuiteString(selectedCipherSuite));
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        String selected = this.manager.getContext().getProtocolString(serverVersion);
        if (selected == null) {
            LOG.fine("Server selected an unsupported protocol version: " + serverVersion);
        } else {
            for (String protocol : this.sslParameters.getProtocols()) {
                if (!selected.equals(protocol)) continue;
                LOG.fine("Client notified of selected protocol version: " + selected);
                return;
            }
            LOG.fine("Server selected a protocol version not enabled in the client: " + selected);
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        super.notifySessionID(sessionID);
        if (sessionID == null || sessionID.length == 0) {
            LOG.fine("Server did not specify a session ID");
        } else if (this.sslSession != null && Arrays.areEqual(sessionID, this.sslSession.getId())) {
            LOG.fine("Server resumed session: " + Hex.toHexString(sessionID));
        } else {
            if (!this.manager.getEnableSessionCreation()) {
                throw new IllegalStateException("Server did not resume session and session creation is disabled");
            }
            LOG.fine("Server specified new session: " + Hex.toHexString(sessionID));
        }
    }

    static {
        if (Boolean.parseBoolean(System.getProperty("com.bes.enterprise.gmssl.client.log.level.warning", "true"))) {
            LOG.setLevel(Level.WARNING);
        }
    }
}

