/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jsse.provider;

import com.bes.enterprise.cipher.asn1.x500.X500Name;
import com.bes.enterprise.cipher.asn1.x509.Extensions;
import com.bes.enterprise.cipher.asn1.x509.KeyUsage;
import com.bes.enterprise.cipher.asn1.x509.TBSCertificate;
import com.bes.enterprise.cipher.jsse.provider.JsseUtils;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

class ProvX509KeyManagerSimple
extends X509ExtendedKeyManager {
    private final Map<String, Credential> credentials = new HashMap<String, Credential>();

    ProvX509KeyManagerSimple(KeyStore ks, char[] password) throws GeneralSecurityException {
        if (ks != null) {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
                PrivateKey privateKey = (PrivateKey)ks.getKey(alias, password);
                X509Certificate[] certificateChain = JsseUtils.getX509CertificateChain(ks.getCertificateChain(alias));
                if (certificateChain == null || certificateChain.length <= 0) continue;
                this.credentials.put(alias, new Credential(privateKey, certificateChain));
            }
        }
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(false, keyTypes, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(false, keyTypes, issuers);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(true, new String[]{keyType}, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(true, new String[]{keyType}, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        Credential credential = this.getCredential(alias);
        return credential == null ? null : (X509Certificate[])credential.getCertificateChain().clone();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(false, keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Credential credential = this.getCredential(alias);
        return credential == null ? null : credential.getPrivateKey();
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(true, keyType, issuers);
    }

    private String chooseAlias(boolean forServer, String[] keyTypes, Principal[] issuers) {
        Set<X500Name> issuerNames = JsseUtils.toX500Names(issuers);
        for (String keyType : keyTypes) {
            for (Map.Entry<String, Credential> entry : this.credentials.entrySet()) {
                if (!this.isSuitableCredential(forServer, keyType, issuerNames, entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private String[] getAliases(boolean forServer, String keyType, Principal[] issuers) {
        Set<X500Name> issuerNames = JsseUtils.toX500Names(issuers);
        ArrayList<String> aliases = new ArrayList<String>();
        for (Map.Entry<String, Credential> entry : this.credentials.entrySet()) {
            if (!this.isSuitableCredential(forServer, keyType, issuerNames, entry.getValue())) continue;
            aliases.add(entry.getKey());
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    private Credential getCredential(String alias) {
        return alias == null ? null : this.credentials.get(alias);
    }

    private boolean hasSuitableIssuer(Set<X500Name> issuerNames, X509Certificate c) {
        return issuerNames.contains(JsseUtils.toX500Name(c.getIssuerX500Principal()));
    }

    private boolean isSuitableCredential(boolean forServer, String keyType, Set<X500Name> issuerNames, Credential credential) {
        X509Certificate[] certificateChain = credential.getCertificateChain();
        if (!this.isSuitableCertificate(forServer, keyType, certificateChain[0])) {
            return false;
        }
        if (issuerNames == null || issuerNames.isEmpty()) {
            return true;
        }
        int pos = certificateChain.length;
        while (--pos >= 0) {
            if (!this.hasSuitableIssuer(issuerNames, certificateChain[pos])) continue;
            return true;
        }
        return false;
    }

    private boolean isSuitableCertificate(boolean forServer, String keyType, X509Certificate c) {
        if (keyType == null || c == null) {
            return false;
        }
        PublicKey pub = c.getPublicKey();
        if (keyType.equalsIgnoreCase("DHE_RSA") || keyType.equalsIgnoreCase("ECDHE_RSA") || keyType.equalsIgnoreCase("SRP_RSA")) {
            return pub instanceof RSAPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("DHE_DSS") || keyType.equalsIgnoreCase("SRP_DSS")) {
            return pub instanceof DSAPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("ECDHE_ECDSA")) {
            return pub instanceof ECPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("RSA")) {
            int keyUsage = forServer ? 32 : 128;
            return pub instanceof RSAPublicKey && this.isSuitableKeyUsage(keyUsage, c);
        }
        if (keyType.equalsIgnoreCase("DSA")) {
            return !forServer && pub instanceof DSAPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("EC")) {
            return pub instanceof ECPublicKey && this.isSuitableKeyUsage(128, c);
        }
        return false;
    }

    private boolean isSuitableKeyUsage(int keyUsageBits, X509Certificate c) {
        try {
            int bits;
            KeyUsage ku;
            Extensions exts = TBSCertificate.getInstance(c.getTBSCertificate()).getExtensions();
            if (exts != null && (ku = KeyUsage.fromExtensions(exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static class Credential {
        private final PrivateKey privateKey;
        private final X509Certificate[] certificateChain;

        Credential(PrivateKey privateKey, X509Certificate[] certificateChain) {
            this.privateKey = privateKey;
            this.certificateChain = certificateChain;
        }

        X509Certificate[] getCertificateChain() {
            return this.certificateChain;
        }

        PrivateKey getPrivateKey() {
            return this.privateKey;
        }
    }
}

