/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jsse.provider;

import com.bes.enterprise.cipher.jsse.BCSNIMatcher;
import com.bes.enterprise.cipher.jsse.BCSNIServerName;
import com.bes.enterprise.cipher.jsse.BCSSLParameters;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLParameters;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;

abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getSNIMatchers;
    private static final Method setSNIMatchers;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    private static Method findMethod(Method[] methods, String name) {
        if (methods != null) {
            for (Method m : methods) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
        }
        return null;
    }

    private static Class<?> getClassPrivileged(final String className) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader loader = SSLParametersUtil.class.getClassLoader();
                    if (loader != null) {
                        return loader.loadClass(className);
                    }
                    return Class.forName(className);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private static Method[] getMethodsPrivileged(final Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    return clazz.getMethods();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private static Object invokeGetterPrivileged(final Object obj, final Method method) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private static void invokeSetterPrivileged(final Object obj, final Method method, final Object arg) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    method.invoke(obj, arg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static BCSSLParameters getParameters(ProvSSLParameters prov) {
        BCSSLParameters ssl = new BCSSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else if (prov.getWantClientAuth()) {
            ssl.setWantClientAuth(true);
        } else {
            ssl.setWantClientAuth(false);
        }
        ssl.setServerNames(prov.getServerNames());
        ssl.setSNIMatchers(prov.getSNIMatchers());
        return ssl;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters prov) {
        SSLParameters ssl = new SSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else if (prov.getWantClientAuth()) {
            ssl.setWantClientAuth(true);
        } else {
            ssl.setWantClientAuth(false);
        }
        if (setAlgorithmConstraints != null) {
            SSLParametersUtil.invokeSetterPrivileged(ssl, setAlgorithmConstraints, prov.getAlgorithmConstraints());
        }
        if (setEndpointIdentificationAlgorithm != null) {
            SSLParametersUtil.invokeSetterPrivileged(ssl, setEndpointIdentificationAlgorithm, prov.getEndpointIdentificationAlgorithm());
        }
        return ssl;
    }

    static void setParameters(ProvSSLParameters prov, BCSSLParameters ssl) {
        Collection<BCSNIMatcher> sniMatchers;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (cipherSuites != null) {
            prov.setCipherSuites(cipherSuites);
        }
        if ((protocols = ssl.getProtocols()) != null) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else if (ssl.getWantClientAuth()) {
            prov.setWantClientAuth(true);
        } else {
            prov.setWantClientAuth(false);
        }
        List<BCSNIServerName> serverNames = ssl.getServerNames();
        if (serverNames != null) {
            prov.setServerNames(serverNames);
        }
        if ((sniMatchers = ssl.getSNIMatchers()) != null) {
            prov.setSNIMatchers(sniMatchers);
        }
    }

    static void setSSLParameters(ProvSSLParameters prov, SSLParameters ssl) {
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (cipherSuites != null) {
            prov.setCipherSuites(cipherSuites);
        }
        if ((protocols = ssl.getProtocols()) != null) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else if (ssl.getWantClientAuth()) {
            prov.setWantClientAuth(true);
        } else {
            prov.setWantClientAuth(false);
        }
        if (getAlgorithmConstraints != null) {
            prov.setAlgorithmConstraints(SSLParametersUtil.invokeGetterPrivileged(ssl, getAlgorithmConstraints));
        }
        if (getEndpointIdentificationAlgorithm != null) {
            prov.setEndpointIdentificationAlgorithm((String)SSLParametersUtil.invokeGetterPrivileged(ssl, getEndpointIdentificationAlgorithm));
        }
    }

    static {
        Class<?> sslParametersClazz = SSLParametersUtil.getClassPrivileged("javax.net.ssl.SSLParameters");
        Method[] methods = SSLParametersUtil.getMethodsPrivileged(sslParametersClazz);
        getAlgorithmConstraints = SSLParametersUtil.findMethod(methods, "getAlgorithmConstraints");
        setAlgorithmConstraints = SSLParametersUtil.findMethod(methods, "setAlgorithmConstraints");
        getEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methods, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methods, "setEndpointIdentificationAlgorithm");
        getServerNames = SSLParametersUtil.findMethod(methods, "getServerNames");
        setServerNames = SSLParametersUtil.findMethod(methods, "setServerNames");
        getSNIMatchers = SSLParametersUtil.findMethod(methods, "getSNIMatchers");
        setSNIMatchers = SSLParametersUtil.findMethod(methods, "setSNIMatchers");
        getUseCipherSuitesOrder = SSLParametersUtil.findMethod(methods, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = SSLParametersUtil.findMethod(methods, "setUseCipherSuitesOrder");
    }
}

