/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.math.ec.custom.sec;

import com.bes.enterprise.cipher.math.ec.ECCurve;
import com.bes.enterprise.cipher.math.ec.ECFieldElement;
import com.bes.enterprise.cipher.math.ec.ECLookupTable;
import com.bes.enterprise.cipher.math.ec.ECPoint;
import com.bes.enterprise.cipher.math.ec.custom.sec.SecP160R2FieldElement;
import com.bes.enterprise.cipher.math.ec.custom.sec.SecP160R2Point;
import com.bes.enterprise.cipher.math.raw.Nat160;
import com.bes.enterprise.cipher.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160R2Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73"));
    private static final int SecP160R2_DEFAULT_COORDS = 2;
    protected SecP160R2Point infinity = new SecP160R2Point(this, null, null);

    public SecP160R2Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC70")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("B4E134D3FB59EB8BAB57274904664D5AF50388BA")));
        this.order = new BigInteger(1, Hex.decode("0100000000000000000000351EE786A818F3A1A16B"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP160R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecP160R2FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecP160R2Point((ECCurve)this, x, y, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecP160R2Point(this, x, y, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_INTS = 5;
        final int[] table = new int[len * 5 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat160.copy(((SecP160R2FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat160.copy(((SecP160R2FieldElement)p.getRawYCoord()).x, 0, table, pos += 5);
            pos += 5;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] x = Nat160.create();
                int[] y = Nat160.create();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    int MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 5; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 5 + j] & MASK;
                    }
                    pos += 10;
                }
                return SecP160R2Curve.this.createRawPoint(new SecP160R2FieldElement(x), new SecP160R2FieldElement(y), false);
            }
        };
    }
}

