/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pqc.jcajce.provider.xmss;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA256Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA512Digest;
import com.bes.enterprise.cipher.crypto.digests.SHAKEDigest;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.bes.enterprise.cipher.pqc.crypto.xmss.XMSSMTSigner;
import com.bes.enterprise.cipher.pqc.jcajce.interfaces.StateAwareSignature;
import com.bes.enterprise.cipher.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import com.bes.enterprise.cipher.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import com.bes.enterprise.cipher.pqc.jcajce.provider.xmss.DigestUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSMTSignatureSpi
extends Signature
implements StateAwareSignature {
    private Digest digest;
    private XMSSMTSigner signer;
    private ASN1ObjectIdentifier treeDigest;
    private SecureRandom random;

    protected XMSSMTSignatureSpi(String algorithm) {
        super(algorithm);
    }

    protected XMSSMTSignatureSpi(String sigName, Digest digest, XMSSMTSigner signer) {
        super(sigName);
        this.digest = digest;
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCXMSSMTPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to XMSSMT");
        }
        CipherParameters param = ((BCXMSSMTPublicKey)publicKey).getKeyParams();
        this.treeDigest = null;
        this.digest.reset();
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters param;
        if (privateKey instanceof BCXMSSMTPrivateKey) {
            param = ((BCXMSSMTPrivateKey)privateKey).getKeyParams();
            this.treeDigest = ((BCXMSSMTPrivateKey)privateKey).getTreeDigestOID();
            if (this.random != null) {
                param = new ParametersWithRandom(param, this.random);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to XMSSMT");
        }
        this.digest.reset();
        this.signer.init(true, param);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = DigestUtil.getDigestResult(this.digest);
        try {
            byte[] sig = this.signer.generateSignature(hash);
            return sig;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw new SignatureException(e.getMessage());
            }
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = DigestUtil.getDigestResult(this.digest);
        return this.signer.verifySignature(hash, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public boolean isSigningCapable() {
        return this.treeDigest != null;
    }

    @Override
    public PrivateKey getUpdatedPrivateKey() {
        if (this.treeDigest == null) {
            throw new IllegalStateException("signature object not in a signing state");
        }
        BCXMSSMTPrivateKey rKey = new BCXMSSMTPrivateKey(this.treeDigest, (XMSSMTPrivateKeyParameters)this.signer.getUpdatedPrivateKey());
        this.treeDigest = null;
        return rKey;
    }

    public static class withShake256
    extends XMSSMTSignatureSpi {
        public withShake256() {
            super("SHAKE256withXMSSMT", new SHAKEDigest(256), new XMSSMTSigner());
        }
    }

    public static class withSha512
    extends XMSSMTSignatureSpi {
        public withSha512() {
            super("SHA512withXMSSMT", new SHA512Digest(), new XMSSMTSigner());
        }
    }

    public static class withShake128
    extends XMSSMTSignatureSpi {
        public withShake128() {
            super("SHAKE128withXMSSMT", new SHAKEDigest(128), new XMSSMTSigner());
        }
    }

    public static class withSha256
    extends XMSSMTSignatureSpi {
        public withSha256() {
            super("SHA256withXMSSMT", new SHA256Digest(), new XMSSMTSigner());
        }
    }
}

