/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.x509;

import com.bes.enterprise.cipher.x509.NoSuchParserException;
import com.bes.enterprise.cipher.x509.X509StreamParserSpi;
import com.bes.enterprise.cipher.x509.X509Util;
import com.bes.enterprise.cipher.x509.util.StreamParser;
import com.bes.enterprise.cipher.x509.util.StreamParsingException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Collection;

public class X509StreamParser
implements StreamParser {
    private Provider _provider;
    private X509StreamParserSpi _spi;

    public static X509StreamParser getInstance(String type) throws NoSuchParserException {
        try {
            X509Util.Implementation impl = X509Util.getImplementation("X509StreamParser", type);
            return X509StreamParser.createParser(impl);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchParserException(e.getMessage());
        }
    }

    public static X509StreamParser getInstance(String type, String provider) throws NoSuchParserException, NoSuchProviderException {
        return X509StreamParser.getInstance(type, X509Util.getProvider(provider));
    }

    public static X509StreamParser getInstance(String type, Provider provider) throws NoSuchParserException {
        try {
            X509Util.Implementation impl = X509Util.getImplementation("X509StreamParser", type, provider);
            return X509StreamParser.createParser(impl);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchParserException(e.getMessage());
        }
    }

    private static X509StreamParser createParser(X509Util.Implementation impl) {
        X509StreamParserSpi spi = (X509StreamParserSpi)impl.getEngine();
        return new X509StreamParser(impl.getProvider(), spi);
    }

    private X509StreamParser(Provider provider, X509StreamParserSpi spi) {
        this._provider = provider;
        this._spi = spi;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public void init(InputStream stream) {
        this._spi.engineInit(stream);
    }

    public void init(byte[] data) {
        this._spi.engineInit(new ByteArrayInputStream(data));
    }

    @Override
    public Object read() throws StreamParsingException {
        return this._spi.engineRead();
    }

    @Override
    public Collection readAll() throws StreamParsingException {
        return this._spi.engineReadAll();
    }
}

