/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.pool;

import java.util.concurrent.TimeUnit;

public interface ClockSource {
    public static final ClockSource INSTANCE = Factory.access$000();
    public static final TimeUnit[] TIMEUNITS_DESCENDING = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};
    public static final String[] TIMEUNIT_DISPLAY_VALUES = new String[]{"ns", "\u00b5s", "ms", "s", "m", "h", "d"};

    public long currentTime();

    public long toMillis(long var1);

    public long toNanos(long var1);

    public long elapsedMillis(long var1);

    public long elapsedMillis(long var1, long var3);

    public long elapsedNanos(long var1);

    public long elapsedNanos(long var1, long var3);

    public long plusMillis(long var1, long var3);

    public TimeUnit getSourceTimeUnit();

    public String elapsedDisplayString(long var1, long var3);

    public static class NanosecondClockSource
    implements ClockSource {
        @Override
        public long currentTime() {
            return System.nanoTime();
        }

        @Override
        public long toMillis(long time) {
            return TimeUnit.NANOSECONDS.toMillis(time);
        }

        @Override
        public long toNanos(long time) {
            return time;
        }

        @Override
        public long elapsedMillis(long startTime) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        }

        @Override
        public long elapsedMillis(long startTime, long endTime) {
            return TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
        }

        @Override
        public long elapsedNanos(long startTime) {
            return System.nanoTime() - startTime;
        }

        @Override
        public long elapsedNanos(long startTime, long endTime) {
            return endTime - startTime;
        }

        @Override
        public long plusMillis(long time, long millis) {
            return time + TimeUnit.MILLISECONDS.toNanos(millis);
        }

        @Override
        public TimeUnit getSourceTimeUnit() {
            return TimeUnit.NANOSECONDS;
        }

        @Override
        public String elapsedDisplayString(long startTime, long endTime) {
            long elapsedNanos = this.elapsedNanos(startTime, endTime);
            StringBuilder sb = new StringBuilder(elapsedNanos < 0L ? "-" : "");
            elapsedNanos = Math.abs(elapsedNanos);
            for (TimeUnit unit : TIMEUNITS_DESCENDING) {
                long converted = unit.convert(elapsedNanos, TimeUnit.NANOSECONDS);
                if (converted <= 0L) continue;
                sb.append(converted).append(TIMEUNIT_DISPLAY_VALUES[unit.ordinal()]);
                elapsedNanos -= TimeUnit.NANOSECONDS.convert(converted, unit);
            }
            return sb.toString();
        }
    }

    public static final class MillisecondClockSource
    extends NanosecondClockSource {
        @Override
        public long currentTime() {
            return System.currentTimeMillis();
        }

        @Override
        public long elapsedMillis(long startTime) {
            return System.currentTimeMillis() - startTime;
        }

        @Override
        public long elapsedMillis(long startTime, long endTime) {
            return endTime - startTime;
        }

        @Override
        public long elapsedNanos(long startTime) {
            return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis() - startTime);
        }

        @Override
        public long elapsedNanos(long startTime, long endTime) {
            return TimeUnit.MILLISECONDS.toNanos(endTime - startTime);
        }

        @Override
        public long toMillis(long time) {
            return time;
        }

        @Override
        public long toNanos(long time) {
            return TimeUnit.MILLISECONDS.toNanos(time);
        }

        @Override
        public long plusMillis(long time, long millis) {
            return time + millis;
        }

        @Override
        public TimeUnit getSourceTimeUnit() {
            return TimeUnit.MILLISECONDS;
        }
    }

    public static class Factory {
        private static ClockSource create() {
            String os = System.getProperty("os.name");
            if ("Mac OS X".equals(os)) {
                return new MillisecondClockSource();
            }
            return new NanosecondClockSource();
        }

        static /* synthetic */ ClockSource access$000() {
            return Factory.create();
        }
    }
}

