/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.pool.impl;

import com.bes.enterprise.gjc.pool.ClockSource;
import com.bes.enterprise.gjc.pool.ObjectPool;
import com.bes.enterprise.gjc.pool.PoolUtils;
import com.bes.enterprise.gjc.pool.PooledObject;
import com.bes.enterprise.gjc.pool.PooledObjectFactory;
import com.bes.enterprise.gjc.pool.PooledObjectState;
import com.bes.enterprise.gjc.pool.UsageTracking;
import com.bes.enterprise.gjc.pool.impl.AbandonedConfig;
import com.bes.enterprise.gjc.pool.impl.BESQueueFIFO;
import com.bes.enterprise.gjc.pool.impl.BESQueueLIFO;
import com.bes.enterprise.gjc.pool.impl.BaseGenericObjectPool;
import com.bes.enterprise.gjc.pool.impl.DefaultPooledObjectInfo;
import com.bes.enterprise.gjc.pool.impl.EvictionConfig;
import com.bes.enterprise.gjc.pool.impl.EvictionPolicy;
import com.bes.enterprise.gjc.pool.impl.GenericObjectPoolConfig;
import com.bes.enterprise.gjc.pool.impl.GenericObjectPoolMXBean;
import com.bes.enterprise.gjc.pool.impl.PoolImplUtils;
import com.bes.enterprise.gjc.pool.impl.QueueAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericObjectPool<T>
extends BaseGenericObjectPool<T>
implements ObjectPool<T>,
GenericObjectPoolMXBean,
UsageTracking<T> {
    private static final ClockSource clockSource = ClockSource.INSTANCE;
    private static final Logger logger = Logger.getLogger(GenericObjectPool.class.getName());
    private volatile long maxLifetimeMillis = -1L;
    private final ThreadLocal<Integer> connHoldedCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private volatile String factoryType = null;
    private volatile int maxIdle = -1;
    private int standbyLevel = 2;
    private volatile int minIdle = 0;
    private final PooledObjectFactory<T> factory;
    private String name;
    private final Map<T, PooledObject<T>> allObjects = new ConcurrentHashMap<T, PooledObject<T>>();
    private final AtomicLong connCounter = new AtomicLong(0L);
    private final QueueAdapter<PooledObject<T>> idleObjects;
    private final QueueAdapter<PooledObject<T>> standbyObjects;
    private static final String ONAME_BASE = "com.bes.enterprise.gjc.pool:type=GenericObjectPool,name=";
    private volatile AbandonedConfig abandonedConfig = null;
    private volatile boolean matchConnections = false;
    private AtomicBoolean failAllConnectionProcessing = new AtomicBoolean(false);
    private ReentrantLock lock = new ReentrantLock();
    private Condition notFull = this.lock.newCondition();

    public GenericObjectPool(PooledObjectFactory<T> factory) {
        this(factory, new GenericObjectPoolConfig(), true);
    }

    public GenericObjectPool(PooledObjectFactory<T> factory, GenericObjectPoolConfig config) {
        this(factory, config, true);
    }

    public GenericObjectPool(PooledObjectFactory<T> factory, GenericObjectPoolConfig config, boolean lifo) {
        super(config, ONAME_BASE, config.getJmxNamePrefix());
        if (factory == null) {
            this.jmxUnregister();
            throw new IllegalArgumentException("factory may not be null");
        }
        this.factory = factory;
        this.idleObjects = lifo ? new BESQueueLIFO(config.getFairness()) : new BESQueueFIFO();
        this.standbyObjects = config.getStandbySize() > 0 ? new BESQueueLIFO(config.getStandbySize(), config.getFairness()) : null;
        this.setConfig(config);
        this.startEvictor(this.getTimeBetweenEvictionRunsMillis());
        this.startCreateConnectionThread();
    }

    public GenericObjectPool(PooledObjectFactory<T> factory, GenericObjectPoolConfig config, AbandonedConfig abandonedConfig, boolean lifo) {
        this(factory, config, lifo);
        this.setAbandonedConfig(abandonedConfig);
    }

    public GenericObjectPool(PooledObjectFactory<T> factory, GenericObjectPoolConfig config, AbandonedConfig abandonedConfig) {
        this(factory, config, abandonedConfig, true);
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    @Override
    public int getMinIdle() {
        int maxIdleSave = this.getMaxIdle();
        if (maxIdleSave > -1 && this.minIdle > maxIdleSave) {
            return maxIdleSave;
        }
        return this.minIdle;
    }

    public boolean isMatchConnections() {
        return this.matchConnections;
    }

    public void setMatchConnections(boolean matchConnections) {
        this.matchConnections = matchConnections;
    }

    public int getStandbyLevel() {
        return this.standbyLevel;
    }

    public void setStandbyLevel(int standbyLevel) {
        this.standbyLevel = standbyLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isAbandonedConfig() {
        return this.abandonedConfig != null;
    }

    @Override
    public boolean getLogAbandoned() {
        AbandonedConfig ac = this.abandonedConfig;
        return ac != null && ac.getLogAbandoned();
    }

    @Override
    public boolean getRemoveAbandonedOnBorrow() {
        AbandonedConfig ac = this.abandonedConfig;
        return ac != null && ac.getRemoveAbandonedOnBorrow();
    }

    @Override
    public boolean getRemoveAbandonedOnMaintenance() {
        AbandonedConfig ac = this.abandonedConfig;
        return ac != null && ac.getRemoveAbandonedOnMaintenance();
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        AbandonedConfig ac = this.abandonedConfig;
        return ac != null ? ac.getRemoveAbandonedTimeout() : Integer.MAX_VALUE;
    }

    public long getMaxLifetimeMillis() {
        return this.maxLifetimeMillis;
    }

    public void setMaxLifetimeMillis(long maxLifetimeMillis) {
        this.maxLifetimeMillis = maxLifetimeMillis;
    }

    public void setConfig(GenericObjectPoolConfig conf) {
        this.setStandbyLevel(conf.getStandbyLevel());
        this.setLifo(conf.getLifo());
        this.setMaxIdle(conf.getMaxIdle());
        this.setMinIdle(conf.getMinIdle());
        this.setMaxTotal(conf.getMaxTotal());
        this.setMaxWaitMillis(conf.getMaxWaitMillis());
        this.setBlockWhenExhausted(conf.getBlockWhenExhausted());
        this.setTestOnCreate(conf.getTestOnCreate());
        this.setTestOnBorrow(conf.getTestOnBorrow());
        this.setTestOnReturn(conf.getTestOnReturn());
        this.setTestWhileIdle(conf.getTestWhileIdle());
        this.setNumTestsPerEvictionRun(conf.getNumTestsPerEvictionRun());
        this.setMinEvictableIdleTimeMillis(conf.getMinEvictableIdleTimeMillis());
        this.setTimeBetweenEvictionRunsMillis(conf.getTimeBetweenEvictionRunsMillis());
        this.setMaxEvictableIdleTimeMillis(conf.getMaxEvictableIdleTimeMillis());
        this.setEvictionPolicyClassName(conf.getEvictionPolicyClassName());
    }

    public void setAbandonedConfig(AbandonedConfig abandonedConfig) throws IllegalArgumentException {
        if (abandonedConfig == null) {
            this.abandonedConfig = null;
        } else {
            this.abandonedConfig = new AbandonedConfig();
            this.abandonedConfig.setLogAbandoned(abandonedConfig.getLogAbandoned());
            this.abandonedConfig.setLogWriter(abandonedConfig.getLogWriter());
            this.abandonedConfig.setRemoveAbandonedOnBorrow(abandonedConfig.getRemoveAbandonedOnBorrow());
            this.abandonedConfig.setRemoveAbandonedOnMaintenance(abandonedConfig.getRemoveAbandonedOnMaintenance());
            this.abandonedConfig.setRemoveAbandonedTimeout(abandonedConfig.getRemoveAbandonedTimeout());
            this.abandonedConfig.setUseUsageTracking(abandonedConfig.getUseUsageTracking());
        }
    }

    public PooledObjectFactory<T> getFactory() {
        return this.factory;
    }

    public PooledObject<T> getObject(T phyObject) {
        return this.allObjects.get(phyObject);
    }

    @Override
    public T borrowObject() throws Exception {
        return this.borrowObject(this.getMaxWaitMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrowObject(long borrowMaxWaitMillis) throws Exception {
        this.assertOpen();
        PooledObject<T> p = null;
        int destoriedConnection = 0;
        boolean blockWhenExhausted = this.getBlockWhenExhausted();
        long currentTime = clockSource.currentTime();
        int heldCount = this.connHoldedCount.get();
        while (p == null) {
            boolean create;
            block28: {
                create = false;
                if (blockWhenExhausted) {
                    p = this.idleObjects.poll();
                    if (p == null && this.standbyObjects != null && heldCount + 1 >= this.standbyLevel) {
                        p = this.standbyObjects.poll();
                    }
                    if (p == null && (p = this.create()) != null) {
                        create = true;
                    }
                    if (p == null) {
                        p = borrowMaxWaitMillis < 0L ? (this.standbyObjects != null && heldCount + 1 >= this.standbyLevel ? this.standbyObjects.take() : this.idleObjects.take()) : (this.standbyObjects != null && heldCount + 1 >= this.standbyLevel ? this.standbyObjects.poll(borrowMaxWaitMillis, TimeUnit.MILLISECONDS) : this.idleObjects.poll(borrowMaxWaitMillis, TimeUnit.MILLISECONDS));
                    }
                    if (p == null) {
                        throw new NoSuchElementException("Timeout waiting for idle object");
                    }
                    if (!p.allocate()) {
                        if (p.getState() == PooledObjectState.STALE && logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, "Internal inconsistent, invalid state: " + (Object)((Object)p.getState()));
                        }
                        p = null;
                    }
                } else {
                    p = this.idleObjects.poll();
                    if (p == null && (p = this.create()) != null) {
                        create = true;
                    }
                    if (p == null) {
                        throw new NoSuchElementException("Pool exhausted");
                    }
                    if (!p.allocate()) {
                        p = null;
                    }
                }
                if (p == null) continue;
                try {
                    this.factory.activateObject(p);
                }
                catch (Exception e) {
                    try {
                        this.destroy(p);
                        ++destoriedConnection;
                        this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.borrow, p.getObject().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    p = null;
                    if (!create) break block28;
                    NoSuchElementException nsee = new NoSuchElementException("Unable to activate object");
                    nsee.initCause(e);
                    throw nsee;
                }
            }
            if (this.matchConnections && p != null && !create) {
                boolean match = true;
                match = this.factory.matchObject(p);
                if (!match) {
                    try {
                        this.destroy(p);
                        ++destoriedConnection;
                        this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.borrow, p.getObject().toString());
                    }
                    catch (Exception nsee) {
                        // empty catch block
                    }
                    p = null;
                }
            }
            if (p == null || !this.getTestOnBorrow() && (!create || !this.getTestOnCreate())) continue;
            boolean validate = false;
            Throwable validationThrowable = null;
            try {
                validate = this.factory.validateObject(p);
            }
            catch (Throwable t) {
                PoolUtils.checkRethrow(t);
                validationThrowable = t;
            }
            if (validate) continue;
            try {
                this.destroy(p);
                ++destoriedConnection;
                this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.borrow, p.getObject().toString());
            }
            catch (Exception t) {
                // empty catch block
            }
            p = null;
            if (!create) continue;
            NoSuchElementException nsee = new NoSuchElementException("Unable to validate object");
            nsee.initCause(validationThrowable);
            throw nsee;
        }
        this.updateStatsBorrow(p, clockSource.elapsedMillis(currentTime));
        this.connHoldedCount.set(this.connHoldedCount.get() + 1);
        if (destoriedConnection > 0 && this.lock.tryLock()) {
            try {
                this.notFull.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        return p.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T obj) {
        this.connHoldedCount.set(this.connHoldedCount.get() - 1);
        PooledObject<T> p = this.allObjects.get(obj);
        this.updateStatsReturn(p);
        if (p == null) {
            if (!this.isAbandonedConfig()) {
                throw new IllegalStateException("Internal inconsistent: returned object not currently part of this pool.");
            }
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Returned object may have been abandoned and removed from pool.");
            }
            return;
        }
        PooledObject<T> pooledObject = p;
        synchronized (pooledObject) {
            PooledObjectState state = p.getState();
            if (state == PooledObjectState.STALE) {
                this.destroyAndEnsureIdle(p);
                return;
            }
            if (state != PooledObjectState.ALLOCATED) {
                throw new IllegalStateException("Object has already been returned to this pool or is invalid, state: " + (Object)((Object)p.getState()));
            }
            p.markReturning();
        }
        if (this.getTestOnReturn() && !this.factory.validateObject(p)) {
            this.destroyAndEnsureIdle(p);
            return;
        }
        try {
            this.factory.passivateObject(p);
        }
        catch (Exception e1) {
            this.swallowException(e1);
            this.destroyAndEnsureIdle(p);
            return;
        }
        if (!p.deallocate()) {
            if (p.getState() == PooledObjectState.STALE) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "Internal inconsistent, invalid state: " + (Object)((Object)p.getState()));
                }
            } else {
                throw new IllegalStateException("Object has already been returned to this pool or is invalid, failed to deallocate, state: " + (Object)((Object)p.getState()));
            }
        }
        int maxIdleSave = this.getMaxIdle();
        if (this.isClosed() || maxIdleSave > -1 && maxIdleSave <= this.idleObjects.size()) {
            try {
                this.destroy(p);
            }
            catch (Exception e) {
                this.swallowException(e);
            }
        } else {
            if (!this.offerStandby(p)) {
                this.idleObjects.add(p);
            }
            if (this.isClosed()) {
                this.clear();
            }
        }
    }

    private void destroyAndEnsureIdle(PooledObject<T> toDestory) {
        try {
            this.destroy(toDestory);
        }
        catch (Exception e) {
            this.swallowException(e);
        }
        try {
            this.ensureIdle(1, true);
        }
        catch (Exception e) {
            this.swallowException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(T obj) throws Exception {
        PooledObject<T> p = this.allObjects.get(obj);
        if (p == null) {
            if (this.isAbandonedConfig()) {
                return;
            }
            throw new IllegalStateException("Invalidated object not currently part of this pool");
        }
        PooledObject<T> pooledObject = p;
        synchronized (pooledObject) {
            if (p.getState() != PooledObjectState.INVALID) {
                this.destroy(p);
            }
        }
        this.ensureIdle(1, true);
    }

    @Override
    public void clear() {
        PooledObject<T> p = this.idleObjects.poll();
        while (p != null) {
            try {
                this.destroy(p);
            }
            catch (Exception e) {
                this.swallowException(e);
            }
            p = this.idleObjects.poll();
        }
        if (this.standbyObjects != null) {
            p = this.standbyObjects.poll();
            while (p != null) {
                try {
                    this.destroy(p);
                }
                catch (Exception e) {
                    this.swallowException(e);
                }
                p = this.standbyObjects.poll();
            }
        }
        try {
            this.ensureMinIdle();
        }
        catch (Exception e) {
            this.swallowException(e);
        }
    }

    @Override
    public int getNumActive() {
        return this.allObjects.size() - this.idleObjects.size();
    }

    @Override
    public int getNumIdle() {
        return this.idleObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block11: {
            if (this.isClosed()) {
                return;
            }
            Object object = this.closeLock;
            synchronized (object) {
                if (this.isClosed()) {
                    return;
                }
                this.startEvictor(-1L);
                this.closed = true;
                this.clear();
                this.jmxUnregister();
                this.idleObjects.interuptTakeWaiters();
                if (this.standbyObjects != null) {
                    this.standbyObjects.interuptTakeWaiters();
                }
            }
            try {
                if (!this.lock.tryLock(5L, TimeUnit.SECONDS)) break block11;
                try {
                    this.notFull.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                if (!logger.isLoggable(Level.WARNING)) break block11;
                logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    @Override
    public void evict() throws Exception {
        AbandonedConfig ac;
        this.assertOpen();
        this.evict(this.idleObjects);
        if (this.standbyObjects != null) {
            this.evict(this.standbyObjects);
        }
        if ((ac = this.abandonedConfig) != null && ac.getRemoveAbandonedTimeout() > 0) {
            this.removeAbandoned(ac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict(QueueAdapter<PooledObject<T>> idleObjects) throws Exception {
        if (idleObjects.size() > 0) {
            PooledObject underTest = null;
            EvictionPolicy evictionPolicy = this.getEvictionPolicy();
            Object object = this.evictionLock;
            synchronized (object) {
                EvictionConfig evictionConfig = new EvictionConfig(this.getMaxEvictableIdleTimeMillis(), this.getMinEvictableIdleTimeMillis(), this.getMaxLifetimeMillis(), this.getMinIdle());
                boolean testWhileIdle = this.getTestWhileIdle();
                int m = this.getNumTests();
                for (int i = 0; i < m; ++i) {
                    boolean evict;
                    if (this.evictionIterator == null || !this.evictionIterator.hasNext()) {
                        this.evictionIterator = idleObjects.iterator();
                    }
                    if (!this.evictionIterator.hasNext()) {
                        return;
                    }
                    try {
                        underTest = (PooledObject)this.evictionIterator.next();
                    }
                    catch (NoSuchElementException nsee) {
                        --i;
                        this.evictionIterator = null;
                        continue;
                    }
                    if (!underTest.startEvictionTest()) {
                        if (underTest.getState() == PooledObjectState.STALE && logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, "Internal inconsistent, invalid state: " + (Object)((Object)underTest.getState()));
                        }
                        --i;
                        continue;
                    }
                    try {
                        evict = evictionPolicy.evict(evictionConfig, underTest, idleObjects.size());
                    }
                    catch (Throwable t) {
                        PoolUtils.checkRethrow(t);
                        this.swallowException(new Exception(t));
                        evict = false;
                    }
                    if (evict) {
                        this.destroy(underTest);
                        this.destroyedByEvictorCount.incrementAndGet();
                        continue;
                    }
                    if (testWhileIdle) {
                        boolean active = false;
                        try {
                            this.factory.activateObject(underTest);
                            active = true;
                        }
                        catch (Exception e) {
                            this.destroy(underTest);
                            this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.active, e.getMessage());
                        }
                        if (active) {
                            if (!this.factory.validateObject(underTest)) {
                                this.destroy(underTest);
                                this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.validate, underTest.getObject().toString());
                            } else {
                                try {
                                    this.factory.passivateObject(underTest);
                                }
                                catch (Exception e) {
                                    this.destroy(underTest);
                                    this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.passivate, e.getMessage());
                                }
                            }
                        }
                    }
                    if (underTest.endEvictionTest(idleObjects) || underTest.getState() != PooledObjectState.STALE) continue;
                    this.destroy(underTest);
                    this.destroyedByEvictorCount.incrementAndGet();
                }
            }
        }
    }

    private PooledObject<T> create() throws Exception {
        PooledObject<T> p;
        int localMaxTotal = this.getMaxTotal();
        long newCreateCount = this.connCounter.incrementAndGet();
        if (localMaxTotal > -1 && newCreateCount > (long)localMaxTotal || newCreateCount > Integer.MAX_VALUE) {
            this.connCounter.decrementAndGet();
            return null;
        }
        try {
            p = this.factory.makeObject();
        }
        catch (Exception e) {
            this.connCounter.decrementAndGet();
            throw e;
        }
        p.setPoolName(this.getName());
        AbandonedConfig ac = this.abandonedConfig;
        if (ac != null && ac.getLogAbandoned()) {
            p.setLogAbandoned(true);
        }
        this.createdCount.incrementAndGet();
        this.allObjects.put(p.getObject(), p);
        return p;
    }

    private void destroy(PooledObject<T> toDestory) throws Exception {
        toDestory.invalidate();
        this.idleObjects.remove(toDestory);
        if (this.standbyObjects != null) {
            this.standbyObjects.remove(toDestory);
        }
        this.allObjects.remove(toDestory.getObject());
        try {
            this.factory.destroyObject(toDestory);
        }
        finally {
            this.destroyedCount.incrementAndGet();
            this.connCounter.decrementAndGet();
        }
    }

    @Override
    void ensureMinIdle() throws Exception {
        this.ensureIdle(this.getMinIdle(), true);
    }

    private void ensureIdle(int idleCount, boolean always) throws Exception {
        PooledObject<T> p;
        if (idleCount < 1 || this.isClosed() || !always && !this.idleObjects.hasTakeWaiters()) {
            return;
        }
        while (this.idleObjects.size() < idleCount && (p = this.create()) != null) {
            if (this.offerStandby(p)) continue;
            this.idleObjects.add(p);
        }
        if (this.isClosed()) {
            this.clear();
        }
    }

    @Override
    public void addObject() throws Exception {
        this.assertOpen();
        if (this.factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        PooledObject<T> p = this.create();
        this.addIdleObject(p);
    }

    private void addIdleObject(PooledObject<T> p) throws Exception {
        if (p != null) {
            this.factory.passivateObject(p);
            if (!this.offerStandby(p)) {
                this.idleObjects.add(p);
            }
        }
    }

    private boolean offerStandby(PooledObject<T> p) {
        if (this.standbyObjects != null) {
            return this.standbyObjects.offer(p);
        }
        return false;
    }

    private int getNumTests() {
        int numTestsPerEvictionRun = this.getNumTestsPerEvictionRun();
        if (numTestsPerEvictionRun >= 0) {
            return Math.min(numTestsPerEvictionRun, this.idleObjects.size());
        }
        return (int)Math.ceil((double)this.idleObjects.size() / Math.abs((double)numTestsPerEvictionRun));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned(AbandonedConfig ac) {
        ArrayList<PooledObject<T>> remove = new ArrayList<PooledObject<T>>();
        Iterator<PooledObject<T>> it = this.allObjects.values().iterator();
        while (it.hasNext()) {
            PooledObject<T> pooledObject;
            PooledObject<T> pooledObject2 = pooledObject = it.next();
            synchronized (pooledObject2) {
                if (pooledObject.getState() == PooledObjectState.ALLOCATED && clockSource.elapsedMillis(pooledObject.getLastUsedTime()) >= (long)ac.getRemoveAbandonedTimeout() * 1000L) {
                    if (ac.getRemoveAbandonedOnMaintenance() || ac.getRemoveAbandonedOnBorrow()) {
                        pooledObject.markAbandoned();
                    }
                    remove.add(pooledObject);
                }
            }
        }
        for (PooledObject pooledObject : remove) {
            if (ac.getLogAbandoned()) {
                pooledObject.printStackTrace(ac.getLogWriter());
            }
            if (!ac.getRemoveAbandonedOnMaintenance() && !ac.getRemoveAbandonedOnBorrow()) continue;
            try {
                this.connectionLeakCount.incrementAndGet();
                this.invalidateObject(pooledObject.getObject());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isStale(T pObject) {
        PooledObject<T> p = this.allObjects.get(pObject);
        return p.getState() == PooledObjectState.STALE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failAllConnections() {
        this.assertOpen();
        if (!this.failAllConnectionProcessing.compareAndSet(false, true)) {
            return;
        }
        try {
            PooledObject pooledObject;
            this.stopEvictor();
            ArrayList<QueueAdapter<PooledObject<T>>> queueAdapters = new ArrayList<QueueAdapter<PooledObject<T>>>(2);
            queueAdapters.add(this.idleObjects);
            if (this.standbyObjects != null) {
                queueAdapters.add(this.standbyObjects);
            }
            for (QueueAdapter queueAdapter : queueAdapters) {
                PooledObject idleObject = (PooledObject)queueAdapter.poll();
                while (idleObject != null) {
                    pooledObject = idleObject;
                    synchronized (pooledObject) {
                        if (idleObject.getState() == PooledObjectState.IDLE) {
                            try {
                                this.destroy(idleObject);
                                this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.borrow, idleObject.getObject().toString());
                            }
                            catch (Exception exception) {}
                        } else {
                            idleObject.markStale();
                        }
                    }
                    idleObject = (PooledObject)queueAdapter.poll();
                }
            }
            try {
                Iterator<PooledObject<T>> iterator = this.allObjects.values().iterator();
                for (int num = this.allObjects.size(); iterator.hasNext() && num > 0; --num) {
                    PooledObject nonIdleObject;
                    pooledObject = nonIdleObject = iterator.next();
                    synchronized (pooledObject) {
                        if (nonIdleObject.getState() == PooledObjectState.IDLE || nonIdleObject.getState() == PooledObjectState.RETURNING) {
                            try {
                                this.destroy(nonIdleObject);
                                this.destroyedCountIncrease(BaseGenericObjectPool.OptionType.borrow, nonIdleObject.getObject().toString());
                            }
                            catch (Exception exception) {}
                        } else {
                            nonIdleObject.markStale();
                        }
                        continue;
                    }
                }
            }
            catch (NoSuchElementException num) {
                // empty catch block
            }
            try {
                this.ensureMinIdle();
            }
            catch (Exception e) {
                this.swallowException(e);
            }
            this.startEvictor(this.getTimeBetweenEvictionRunsMillis());
        }
        finally {
            this.failAllConnectionProcessing.set(false);
        }
    }

    @Override
    public void use(T pooledObject) {
        AbandonedConfig ac = this.abandonedConfig;
        if (ac != null && ac.getUseUsageTracking()) {
            PooledObject<T> wrapper = this.allObjects.get(pooledObject);
            wrapper.use();
        }
    }

    @Override
    public int getNumWaiters() {
        if (this.getBlockWhenExhausted()) {
            return this.idleObjects.getTakeQueueLength();
        }
        return 0;
    }

    @Override
    public String getFactoryType() {
        if (this.factoryType == null) {
            StringBuilder result = new StringBuilder();
            result.append(this.factory.getClass().getName());
            result.append('<');
            Class<?> pooledObjectType = PoolImplUtils.getFactoryType(this.factory.getClass());
            result.append(pooledObjectType.getName());
            result.append('>');
            this.factoryType = result.toString();
        }
        return this.factoryType;
    }

    @Override
    public Set<DefaultPooledObjectInfo> listAllObjects() {
        HashSet<DefaultPooledObjectInfo> result = new HashSet<DefaultPooledObjectInfo>(this.allObjects.size());
        for (PooledObject<T> p : this.allObjects.values()) {
            result.add(new DefaultPooledObjectInfo(p));
        }
        return result;
    }

    private void startCreateConnectionThread() {
        CreateConnectionThread t = new CreateConnectionThread();
        t.setName("Connection-Pool-Create-" + System.identityHashCode(this));
        t.setDaemon(true);
        t.start();
        t.setContextClassLoader(this.getClass().getClassLoader());
    }

    public class CreateConnectionThread
    extends Thread {
        @Override
        public void run() {
            while (!GenericObjectPool.this.isClosed()) {
                GenericObjectPool.this.lock.lock();
                try {
                    GenericObjectPool.this.notFull.await();
                    if (GenericObjectPool.this.isClosed()) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Stopped thread " + this.getName());
                        }
                        return;
                    }
                    GenericObjectPool.this.ensureMinIdle();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    GenericObjectPool.this.swallowException(e);
                }
                finally {
                    GenericObjectPool.this.lock.unlock();
                }
            }
        }
    }
}

