/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.pool.ClockSource;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractQueryReport {
    private static final ClockSource clockSource = ClockSource.INSTANCE;
    private static final Log log = LogFactory.getLog(AbstractQueryReport.class);
    protected static final String CREATE_STATEMENT = "createStatement";
    protected static final int CREATE_STATEMENT_IDX = 0;
    protected static final String PREPARE_STATEMENT = "prepareStatement";
    protected static final int PREPARE_STATEMENT_IDX = 1;
    protected static final String PREPARE_CALL = "prepareCall";
    protected static final int PREPARE_CALL_IDX = 2;
    protected static final String[] STATEMENT_TYPES = new String[]{"createStatement", "prepareStatement", "prepareCall"};
    protected static final int STATEMENT_TYPE_COUNT = STATEMENT_TYPES.length;
    protected static final String EXECUTE = "execute";
    protected static final String EXECUTE_QUERY = "executeQuery";
    protected static final String EXECUTE_UPDATE = "executeUpdate";
    protected static final String EXECUTE_BATCH = "executeBatch";
    protected static final String[] EXECUTE_TYPES = new String[]{"execute", "executeQuery", "executeUpdate", "executeBatch"};
    protected static final Constructor<?>[] constructors = new Constructor[STATEMENT_TYPE_COUNT];
    public static final String CLOSE_VAL = "close";
    public static final String ISCLOSED_VAL = "isClosed";
    protected long threshold = 1000L;

    protected String reportFailedQuery(String query, Object[] args, String name, long start, Throwable t) {
        String sql;
        String string = sql = query == null && args != null && args.length > 0 ? (String)args[0] : query;
        if (sql == null && this.compare(EXECUTE_BATCH, name)) {
            sql = "batch";
        }
        return sql;
    }

    protected String reportQuery(String query, Object[] args, String name, long start, long delta) {
        String sql;
        String string = sql = query == null && args != null && args.length > 0 ? (String)args[0] : query;
        if (sql == null && this.compare(EXECUTE_BATCH, name)) {
            sql = "batch";
        }
        return sql;
    }

    protected String reportSlowQuery(String query, Object[] args, String name, long start, long delta) {
        String sql;
        String string = sql = query == null && args != null && args.length > 0 ? (String)args[0] : query;
        if (sql == null && this.compare(EXECUTE_BATCH, name)) {
            sql = "batch";
        }
        return sql;
    }

    public boolean compare(String name1, String name2) {
        return name1.equals(name2);
    }

    protected boolean isExecute(Method method, boolean process) {
        return this.process(EXECUTE_TYPES, method, process);
    }

    protected boolean process(String[] names, Method method, boolean process) {
        String name = method.getName();
        for (int i = 0; !process && i < names.length; ++i) {
            process = this.compare(names[i], name);
        }
        return process;
    }

    protected Constructor<?> getConstructor(int idx, Class<?> clazz) throws NoSuchMethodException {
        if (constructors[idx] == null) {
            Class<?> proxyClass = Proxy.getProxyClass(AbstractQueryReport.class.getClassLoader(), clazz);
            AbstractQueryReport.constructors[idx] = proxyClass.getConstructor(InvocationHandler.class);
        }
        return constructors[idx];
    }

    public Object createStatement(Object[] args, Object statement) {
        try {
            Object result = null;
            String sql = null;
            Constructor<?> constructor = null;
            constructor = this.getConstructor(0, Statement.class);
            result = constructor.newInstance(new StatementProxy(statement, sql));
            return result;
        }
        catch (Exception x) {
            log.warn((Object)"Unable to create statement proxy for slow query report ", (Throwable)x);
            return statement;
        }
    }

    public Object prepareStatement(Object[] args, Object statement) {
        try {
            Object result = null;
            String sql = null;
            Constructor<?> constructor = null;
            sql = (String)args[0];
            constructor = this.getConstructor(1, PreparedStatement.class);
            result = constructor.newInstance(new StatementProxy(statement, sql));
            if (sql != null) {
                this.prepareStatement(sql);
            }
            return result;
        }
        catch (Exception x) {
            log.warn((Object)"Unable to create statement proxy for slow query report. ", (Throwable)x);
            return statement;
        }
    }

    public Object prepareCall(Object[] args, Object statement) {
        try {
            Object result = null;
            String sql = null;
            Constructor<?> constructor = null;
            sql = (String)args[0];
            constructor = this.getConstructor(2, CallableStatement.class);
            result = constructor.newInstance(new StatementProxy(statement, sql));
            if (sql != null) {
                this.prepareCall(sql);
            }
            return result;
        }
        catch (Exception x) {
            log.warn((Object)"Unable to create statement proxy for slow query report. ", (Throwable)x);
            return statement;
        }
    }

    protected abstract void prepareStatement(String var1);

    protected abstract void prepareCall(String var1);

    protected class StatementProxy
    implements InvocationHandler {
        protected boolean closed = false;
        protected Object delegate;
        protected final String query;

        public StatementProxy(Object parent, String query) {
            this.delegate = parent;
            this.query = query;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long delta;
            String name = method.getName();
            boolean close = AbstractQueryReport.this.compare(AbstractQueryReport.CLOSE_VAL, name);
            if (close && this.closed) {
                return null;
            }
            if (AbstractQueryReport.this.compare(AbstractQueryReport.ISCLOSED_VAL, name)) {
                return this.closed;
            }
            if (this.closed) {
                throw new SQLException("Statement closed.");
            }
            boolean process = false;
            long start = (process = AbstractQueryReport.this.isExecute(method, process)) ? clockSource.currentTime() : 0L;
            Object result = null;
            try {
                result = method.invoke(this.delegate, args);
            }
            catch (Throwable t) {
                AbstractQueryReport.this.reportFailedQuery(this.query, args, name, start, t);
                if (t instanceof InvocationTargetException && t.getCause() != null) {
                    throw t.getCause();
                }
                throw t;
            }
            long l = delta = process ? clockSource.elapsedMillis(start) : Long.MIN_VALUE;
            if (delta > AbstractQueryReport.this.threshold) {
                try {
                    AbstractQueryReport.this.reportSlowQuery(this.query, args, name, start, delta);
                }
                catch (Exception t) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Unable to process slow query ", (Throwable)t);
                    }
                }
            } else if (process) {
                AbstractQueryReport.this.reportQuery(this.query, args, name, start, delta);
            }
            if (close) {
                this.closed = true;
                this.delegate = null;
            }
            return result;
        }
    }
}

