/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.BasicDataSource;
import com.bes.enterprise.gjc.spi.DbcpConnectionPoolDataSource;
import com.bes.enterprise.gjc.spi.DbcpDataSource;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final String PROP_NAME = "name";
    private static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    private static final String PROP_ISOLATION_LEVEL = "isolationLevel";
    private static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    private static final String PROP_CACHESTATE = "cacheState";
    private static final String PROP_DRIVERCLASSNAME = "driverClassName";
    private static final String PROP_LIFO = "lifo";
    private static final String PROP_MAXPOOLSIZE = "maxPoolSize";
    private static final String PROP_MAXIDLE = "maxIdle";
    private static final String PROP_MINIDLE = "minIdle";
    private static final String PROP_INITIALPOOLSIZE = "initialPoolSize";
    private static final String PROP_MAXWAITTIMEINMILLIS = "maxWaitTimeInMillis";
    private static final String PROP_TESTONCREATE = "testOnCreate";
    private static final String PROP_TESTONBORROW = "testOnBorrow";
    private static final String PROP_TESTONRETURN = "testOnReturn";
    private static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    private static final String PROP_MAXEVICTABLEIDLETIMEOUT = "maxEvictableIdleTimeout";
    private static final String PROP_IDLETIMEOUT = "idleTimeout";
    private static final String PROP_EVICTIONPOLICYCLASSNAME = "evictionPolicyClassName";
    private static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_VALIDATIONQUERY = "validationQuery";
    private static final String PROP_VALIDATIONQUERY_TIMEOUT = "validationQueryTimeout";
    private static final String PROP_JMX_NAME = "jmxName";
    private static final String PROP_VALIDATE_ATMOST_ONCE_PERIOD_IN_SECONDS = "validateAtmostOncePeriodInSeconds";
    private static final String PROP_MATCH_CONNECTIONS = "matchConnections";
    private static final String PROP_CREATE_ON_INITIALIZE = "createOnInitialize";
    private static final String PROP_CONNECTIONINITSQLS = "connectionInitSqls";
    private static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_ENABLE_LEAKAGE_RECOVERY = "enableLeakageRecovery";
    private static final String PROP_CONNECTIONLEAKTIMEOUTINSECONDS = "connectionLeakTimeoutInSeconds";
    private static final String PROP_LOGABANDONED = "logAbandoned";
    private static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    private static final String PROP_POOLSTATEMENTS = "poolStatements";
    private static final String PROP_STATEMENT_CACHE_SIZE = "statementCacheSize";
    private static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    private static final String PROP_MAX_CONNECTION_AGE = "maxConnectionAge";
    private static final String PROP_LOGEXPIREDCONNECTIONS = "logExpiredConnections";
    private static final String PROP_ROLLBACK_ON_RETURN = "rollbackOnReturn";
    private static final String PROP_ENABLE_AUTOCOMMIT_ON_RETURN = "enableAutoCommitOnReturn";
    private static final String PROP_STATEMENT_TIMEOUT_IN_SECONDS = "statementTimeoutInSeconds";
    private static final String PROP_FETCHSIZE = "fetchSize";
    private static final String PROP_FASTFAIL_VALIDATION = "fastFailValidation";
    private static final String PROP_USING_TRACE = "usingTrace";
    private static final String PROP_FAIL_ALL_CONNECTION = "failAllConnection";
    private static final String PROP_ENABLE_SHARING_RESOURCES = "enableSharingResources";
    private static final String PROP_SLOW_SQL_THRESHOLD = "slowSqlThreshold";
    private static final String PROP_SQL_TRACE = "sqlTrace";
    private static final String PROP_MAX_QUERIES = "maxQueries";
    private static final String PROP_LOG_FAILED = "logFailed";
    private static final String PROP_LOG_SLOW = "logSlow";
    private static final String PROP_DISCONNECTION_SQL_CODES = "disconnectionSqlCodes";
    private static final String NUPROP_MAXACTIVE = "maxActive";
    private static final String NUPROP_REMOVEABANDONED = "removeAbandoned";
    private static final String NUPROP_MAXWAIT = "maxWait";
    private static final String SILENTPROP_FACTORY = "factory";
    private static final String SILENTPROP_SCOPE = "scope";
    private static final String SILENTPROP_SINGLETON = "singleton";
    private static final String SILENTPROP_AUTH = "auth";
    private static final String[] ALL_PROPERTIES = new String[]{"name", "defaultAutoCommit", "defaultReadOnly", "isolationLevel", "defaultCatalog", "cacheState", "driverClassName", "lifo", "maxPoolSize", "maxIdle", "minIdle", "initialPoolSize", "maxWaitTimeInMillis", "testOnCreate", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "maxEvictableIdleTimeout", "idleTimeout", "evictionPolicyClassName", "testWhileIdle", "password", "url", "username", "validationQuery", "validationQueryTimeout", "jmxName", "validateAtmostOncePeriodInSeconds", "connectionInitSqls", "accessToUnderlyingConnectionAllowed", "enableLeakageRecovery", "connectionLeakTimeoutInSeconds", "logAbandoned", "poolPreparedStatements", "poolStatements", "statementCacheSize", "connectionProperties", "maxConnectionAge", "logExpiredConnections", "rollbackOnReturn", "enableAutoCommitOnReturn", "statementTimeoutInSeconds", "fetchSize", "fastFailValidation", "disconnectionSqlCodes", "sqlTrace", "usingTrace", "logSlow", "logFailed", "failAllConnection", "matchConnections", "createOnInitialize"};
    private static final Map<String, String> NUPROP_WARNTEXT = new LinkedHashMap<String, String>();
    private static final List<String> SILENT_PROPERTIES;

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        Properties properties = new Properties();
        Enumeration<RefAddr> it = ref.getAll();
        while (it.hasMoreElements()) {
            RefAddr ra = it.nextElement();
            if (ra == null) continue;
            String propertyName = ra.getType();
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return BasicDataSourceFactory.createDataSource(ref.getClassName(), properties);
    }

    private void validatePropertyNames(Reference ref, Name name, List<String> warnings, List<String> infoMessages) {
        StringBuilder stringBuilder;
        String propertyName;
        String nameString;
        List<String> allPropsAsList = Arrays.asList(ALL_PROPERTIES);
        String string = nameString = name != null ? "Name = " + name.toString() + " " : "";
        if (NUPROP_WARNTEXT != null && !NUPROP_WARNTEXT.entrySet().isEmpty()) {
            for (Map.Entry<String, String> entry : NUPROP_WARNTEXT.entrySet()) {
                propertyName = entry.getKey();
                RefAddr ra = ref.get(propertyName);
                if (ra == null || allPropsAsList.contains(ra.getType())) continue;
                stringBuilder = new StringBuilder(nameString);
                String propertyValue = ra.getContent().toString();
                stringBuilder.append(entry.getValue()).append(" You have set value of \"").append(propertyValue).append("\" for \"").append(propertyName).append("\" property, which is being ignored.");
                warnings.add(stringBuilder.toString());
            }
        }
        Enumeration<RefAddr> allRefAddrs = ref.getAll();
        while (allRefAddrs.hasMoreElements()) {
            RefAddr ra = allRefAddrs.nextElement();
            propertyName = ra.getType();
            if (allPropsAsList.contains(propertyName) || NUPROP_WARNTEXT.keySet().contains(propertyName) || SILENT_PROPERTIES.contains(propertyName)) continue;
            String propertyValue = ra.getContent().toString();
            stringBuilder = new StringBuilder(nameString);
            stringBuilder.append("Ignoring unknown property: ").append("value of \"").append(propertyValue).append("\" for \"").append(propertyName).append("\" property");
            infoMessages.add(stringBuilder.toString());
        }
    }

    public static BasicDataSource createDataSource(String driverClassName, Properties properties) throws Exception {
        BasicDataSource dataSource;
        if ("javax.sql.DataSource".equals(driverClassName) || "javax.sql.XADataSource".equals(driverClassName)) {
            dataSource = new DbcpDataSource(null, properties);
            BasicDataSourceFactory.configDataSource(properties, dataSource);
        } else if ("javax.sql.ConnectionPoolDataSource".equals(driverClassName)) {
            dataSource = new DbcpConnectionPoolDataSource(null, properties);
            BasicDataSourceFactory.configDataSource(properties, dataSource);
        } else {
            dataSource = new BasicDataSource();
            BasicDataSourceFactory.configDataSource(properties, dataSource);
        }
        if (dataSource.getCreateOnInitialize().booleanValue()) {
            dataSource.createDataSource();
        }
        return dataSource;
    }

    private static void configDataSource(Properties properties, BasicDataSource dataSource) throws NumberFormatException, Exception, SQLException {
        String value = properties.getProperty(PROP_NAME);
        if (value != null) {
            dataSource.setName(value);
        }
        if ((value = properties.getProperty(PROP_DEFAULTAUTOCOMMIT)) != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULTREADONLY)) != null) {
            dataSource.setDefaultReadOnly(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_ISOLATION_LEVEL)) != null) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse isolationLevel: " + value);
                    System.err.println("WARNING: isolationLevel not set");
                    System.err.println("using default value of database driver");
                    level = -1;
                }
            }
            dataSource.setDefaultTransactionIsolation(level);
        }
        if ((value = properties.getProperty(PROP_DEFAULTCATALOG)) != null) {
            dataSource.setDefaultCatalog(value);
        }
        if ((value = properties.getProperty(PROP_CACHESTATE)) != null) {
            dataSource.setCacheState(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DRIVERCLASSNAME)) != null) {
            dataSource.setDriverClassName(value);
        }
        if ((value = properties.getProperty(PROP_LIFO)) != null) {
            dataSource.setLifo(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_MAXPOOLSIZE)) != null) {
            dataSource.setMaxPoolSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXIDLE)) != null) {
            dataSource.setMaxIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINIDLE)) != null) {
            dataSource.setMinIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_INITIALPOOLSIZE)) != null) {
            dataSource.setInitialPoolSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXWAITTIMEINMILLIS)) != null) {
            dataSource.setMaxWaitTimeInMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_TESTONCREATE)) != null) {
            dataSource.setTestOnCreate(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TESTONBORROW)) != null) {
            dataSource.setTestOnBorrow(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TESTONRETURN)) != null) {
            dataSource.setTestOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TIMEBETWEENEVICTIONRUNSMILLIS)) != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_NUMTESTSPEREVICTIONRUN)) != null) {
            dataSource.setNumTestsPerEvictionRun(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXEVICTABLEIDLETIMEOUT)) != null) {
            dataSource.setMaxEvictableIdleTimeout(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_IDLETIMEOUT)) != null) {
            dataSource.setIdleTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_EVICTIONPOLICYCLASSNAME)) != null) {
            dataSource.setEvictionPolicyClassName(value);
        }
        if ((value = properties.getProperty(PROP_TESTWHILEIDLE)) != null) {
            dataSource.setTestWhileIdle(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_PASSWORD)) != null) {
            dataSource.setPassword(value);
        }
        if ((value = properties.getProperty(PROP_URL)) != null) {
            dataSource.setUrl(value);
        }
        if ((value = properties.getProperty(PROP_USERNAME)) != null) {
            dataSource.setUsername(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATIONQUERY)) != null) {
            dataSource.setValidationQuery(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATIONQUERY_TIMEOUT)) != null) {
            dataSource.setValidationQueryTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED)) != null) {
            dataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_ENABLE_LEAKAGE_RECOVERY)) != null) {
            dataSource.setEnableLeakageRecovery(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_CONNECTIONLEAKTIMEOUTINSECONDS)) != null) {
            dataSource.setConnectionLeakTimeoutInSeconds(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_LOGABANDONED)) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            dataSource.setPoolPreparedStatements(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_POOLSTATEMENTS)) != null) {
            dataSource.setPoolStatements(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_STATEMENT_CACHE_SIZE)) != null) {
            dataSource.setStatementCacheSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_CONNECTIONINITSQLS)) != null) {
            dataSource.setConnectionInitSqls(BasicDataSourceFactory.parseList(value, ';'));
        }
        if ((value = properties.getProperty(PROP_CONNECTIONPROPERTIES)) != null) {
            Properties p = BasicDataSourceFactory.getProperties(value);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                dataSource.addConnectionProperty(propertyName, p.getProperty(propertyName));
            }
        }
        if ((value = properties.getProperty(PROP_MAX_CONNECTION_AGE)) != null) {
            dataSource.setMaxConnectionAge(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_LOGEXPIREDCONNECTIONS)) != null) {
            dataSource.setLogExpiredConnections(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_JMX_NAME)) != null) {
            dataSource.setJmxName(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATE_ATMOST_ONCE_PERIOD_IN_SECONDS)) != null) {
            dataSource.setValidateAtmostOncePeriodInSeconds(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MATCH_CONNECTIONS)) != null) {
            dataSource.setMatchConnections(Boolean.parseBoolean(value));
        }
        if ((value = properties.getProperty(PROP_CREATE_ON_INITIALIZE)) != null) {
            dataSource.setCreateOnInitialize(Boolean.parseBoolean(value));
        }
        if ((value = properties.getProperty(PROP_ENABLE_AUTOCOMMIT_ON_RETURN)) != null) {
            dataSource.setEnableAutoCommitOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_ROLLBACK_ON_RETURN)) != null) {
            dataSource.setRollbackOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_STATEMENT_TIMEOUT_IN_SECONDS)) != null) {
            dataSource.setStatementTimeoutInSeconds(Integer.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_FETCHSIZE)) != null) {
            dataSource.setFetchSize(Integer.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_FASTFAIL_VALIDATION)) != null) {
            dataSource.setFastFailValidation(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DISCONNECTION_SQL_CODES)) != null) {
            dataSource.setDisconnectionSqlCodes(BasicDataSourceFactory.parseList(value, ','));
        }
        if ((value = properties.getProperty(PROP_SQL_TRACE)) != null) {
            dataSource.setSqlTrace(Boolean.parseBoolean(value));
        }
        if ((value = properties.getProperty(PROP_MAX_QUERIES)) != null) {
            dataSource.setMaxQueries(Integer.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_LOG_FAILED)) != null) {
            dataSource.setLogFailed(Boolean.parseBoolean(value));
        }
        if ((value = properties.getProperty(PROP_LOG_SLOW)) != null) {
            dataSource.setLogSlow(Boolean.parseBoolean(value));
        }
        if ((value = properties.getProperty(PROP_SLOW_SQL_THRESHOLD)) != null) {
            dataSource.setSlowSqlThreshold(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_USING_TRACE)) != null) {
            dataSource.setUsingTrace(Boolean.parseBoolean(value));
        }
        if ((value = properties.getProperty(PROP_FAIL_ALL_CONNECTION)) != null) {
            dataSource.setFailAllConnection(Boolean.parseBoolean(value));
        }
        if ((value = properties.getProperty(PROP_ENABLE_SHARING_RESOURCES)) != null) {
            dataSource.setEnableSharingResources(Boolean.parseBoolean(value));
        }
        if (!properties.containsKey("URL") && properties.containsKey(PROP_URL)) {
            properties.setProperty("URL", properties.getProperty(PROP_URL));
        }
        if (!properties.containsKey("user") && properties.containsKey(PROP_USERNAME)) {
            properties.setProperty("user", properties.getProperty(PROP_USERNAME));
        }
    }

    private static Properties getProperties(String propText) throws Exception {
        Properties p = new Properties();
        if (propText != null) {
            p.load(new ByteArrayInputStream(propText.replace(';', '\n').getBytes(StandardCharsets.ISO_8859_1)));
        }
        return p;
    }

    private static Collection<String> parseList(String value, char delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(value, Character.toString(delimiter));
        ArrayList<String> tokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    static {
        NUPROP_WARNTEXT.put(NUPROP_MAXACTIVE, "Property maxActive is not used in DBCP2, use maxPoolSize instead. maxPoolSize default value is 8.");
        NUPROP_WARNTEXT.put(NUPROP_REMOVEABANDONED, "Property removeAbandoned is not used in DBCP2, use enableLeakageRecovery instead. enableLeakageRecoverydefault value is false.");
        NUPROP_WARNTEXT.put(NUPROP_MAXWAIT, "Property maxWait is not used in DBCP2 , use maxWaitTimeInMillis instead. maxWaitTimeInMillis default value is -1.");
        SILENT_PROPERTIES = new ArrayList<String>();
        SILENT_PROPERTIES.add(SILENTPROP_FACTORY);
        SILENT_PROPERTIES.add(SILENTPROP_SCOPE);
        SILENT_PROPERTIES.add(SILENTPROP_SINGLETON);
        SILENT_PROPERTIES.add(SILENTPROP_AUTH);
    }
}

