/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.appserver.common.util.CollectionUtils;
import com.bes.enterprise.gjc.spi.BasicDataSource;
import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.ConnectionPoolDataSourceConnectionFactory;
import com.bes.enterprise.web.util.BeanInspectUtils;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;

public class DbcpConnectionPoolDataSource
extends BasicDataSource {
    protected ConnectionPoolDataSource ds;
    private Properties props;

    public DbcpConnectionPoolDataSource(ConnectionPoolDataSource ds, Properties properties) {
        this.ds = ds;
        this.props = properties;
    }

    public DbcpConnectionPoolDataSource(ConnectionPoolDataSource ds) {
        this.ds = ds;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.ds == null) {
            String driverClassName = this.getDriverClassName();
            Class impl = null;
            try {
                impl = this.loadDriverClass();
            }
            catch (Exception e) {
                String message = "Cannot load JDBC ConnectionPoolDataSource class '" + driverClassName + "'";
                this.logWriter.println(message);
                e.printStackTrace(this.logWriter);
                throw new SQLException(message, e);
            }
            try {
                ConnectionPoolDataSource cpds = (ConnectionPoolDataSource)impl.newInstance();
                BeanInspectUtils.transmitProperties((Object)cpds, (Map)CollectionUtils.propertiesToStringMap((Properties)this.props));
                this.ds = cpds;
            }
            catch (Exception e) {
                String message = "Cannot create JDBC ConnectionPoolDataSource of class '" + (driverClassName != null ? driverClassName : "") + "' for connect URL '" + this.props.getProperty("url") + "'";
                this.logWriter.println(message);
                e.printStackTrace(this.logWriter);
                throw new SQLException(message, e);
            }
        }
        return new ConnectionPoolDataSourceConnectionFactory(this.ds, this.getUsername(), this.getPassword());
    }
}

