/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.BasicDataSource;
import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.DataSourceConnectionFactory;
import com.bes.enterprise.gjc.spi.datasources.DataSourceConvertUtils;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class DbcpDataSource
extends BasicDataSource {
    protected DataSource ds;
    private Properties props;

    public DbcpDataSource(DataSource dataSource) {
        this.ds = dataSource;
    }

    public DbcpDataSource(DataSource dataSource, Properties properties) {
        this.ds = dataSource;
        this.props = properties;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.ds == null) {
            String driverClassName = this.getDriverClassName();
            Class impl = null;
            try {
                impl = this.loadDriverClass();
            }
            catch (Exception e) {
                String message = "Cannot load JDBC DataSource class '" + driverClassName + "'";
                this.logWriter.println(message);
                e.printStackTrace(this.logWriter);
                throw new SQLException(message, e);
            }
            try {
                DataSource dataSource = (DataSource)impl.newInstance();
                DataSourceConvertUtils.convert(dataSource, this.props);
                this.ds = dataSource;
            }
            catch (Exception e) {
                String message = "Cannot create JDBC Datasource of class '" + (driverClassName != null ? driverClassName : "") + "' for connect URL '" + this.props.getProperty("url") + "'";
                this.logWriter.println(message);
                e.printStackTrace(this.logWriter);
                throw new SQLException(message, e);
            }
        }
        return new DataSourceConnectionFactory(this.ds, this.getUsername(), this.getPassword());
    }
}

