/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.AbstractQueryReport;
import com.bes.enterprise.gjc.spi.DelegatingConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DelegatingStatement
implements Statement {
    private Statement _stmt = null;
    private DelegatingConnection<?> _conn = null;
    private int defaultMaxFieldSize;
    private int defaultMaxRows;
    private int defaultQueryTimeout;
    private int defaultFetchDirection;
    private int defaultFetchSize;
    private int currentMaxFieldSize;
    private int currentMaxRows;
    private int currentQueryTimeout;
    private int currentFetchDirection;
    private int currentFetchSize;
    protected volatile boolean busy;
    protected volatile boolean cached;
    protected boolean valid = true;
    private boolean _closed = false;

    public DelegatingStatement(DelegatingConnection<?> c, Statement s) throws SQLException {
        this(c, s, false);
    }

    public DelegatingStatement(DelegatingConnection<?> c, Statement s, boolean cachingEnabled) throws SQLException {
        this._stmt = s;
        this._conn = c;
        this.cached = cachingEnabled;
        if (this.cached) {
            this.defaultQueryTimeout = this._stmt.getQueryTimeout();
            this.defaultMaxFieldSize = this._stmt.getMaxFieldSize();
            this.defaultFetchSize = this._stmt.getFetchSize();
            this.defaultMaxRows = this._stmt.getMaxRows();
            this.defaultFetchDirection = this._stmt.getFetchDirection();
            this.currentQueryTimeout = this.defaultQueryTimeout;
            this.currentMaxFieldSize = this.defaultMaxFieldSize;
            this.currentFetchSize = this.defaultFetchSize;
            this.currentMaxRows = this.defaultMaxRows;
            this.currentFetchDirection = this.defaultFetchDirection;
        }
    }

    public Statement getDelegate() {
        return this._stmt;
    }

    public Statement getInnermostDelegate() {
        InvocationHandler handler;
        Statement s = this._stmt;
        if (s != null && Proxy.isProxyClass(s.getClass()) && (handler = Proxy.getInvocationHandler(s)) instanceof AbstractQueryReport.StatementProxy) {
            AbstractQueryReport.StatementProxy StatementHandler = (AbstractQueryReport.StatementProxy)Proxy.getInvocationHandler(s);
            s = (Statement)StatementHandler.delegate;
        }
        while (s != null && s instanceof DelegatingStatement) {
            if (this != (s = ((DelegatingStatement)s).getDelegate())) continue;
            return null;
        }
        return s;
    }

    public void setDelegate(Statement s) {
        this._stmt = s;
    }

    protected boolean isClosedInternal() {
        return this._closed;
    }

    protected void setClosedInternal(boolean closed) {
        this._closed = closed;
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.getClass().getName() + " with address: \"" + this.toString() + "\" is closed.");
        }
    }

    private void reallyClose() throws SQLException {
        if (this.isClosedInternal()) {
            return;
        }
        try {
            try {
                if (this._stmt != null) {
                    this._stmt.close();
                }
            }
            catch (SQLException e) {
                this.handleException(e);
            }
        }
        finally {
            this._closed = true;
            this._stmt = null;
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.cached) {
            this.reallyClose();
        } else {
            if (this.defaultQueryTimeout != this.currentQueryTimeout) {
                this.getDelegate().setQueryTimeout(this.defaultQueryTimeout);
                this.currentQueryTimeout = this.defaultQueryTimeout;
            }
            if (this.defaultMaxFieldSize != this.currentMaxFieldSize) {
                this.getDelegate().setMaxFieldSize(this.defaultMaxFieldSize);
                this.currentMaxFieldSize = this.defaultMaxFieldSize;
            }
            if (this.defaultFetchSize != this.currentFetchSize) {
                this.getDelegate().setFetchSize(this.defaultFetchSize);
                this.currentFetchSize = this.defaultFetchSize;
            }
            if (this.defaultMaxRows != this.currentMaxRows) {
                this.getDelegate().setMaxRows(this.defaultMaxRows);
                this.currentMaxRows = this.defaultMaxRows;
            }
            if (this.defaultFetchDirection != this.currentFetchDirection) {
                this.getDelegate().setFetchDirection(this.defaultFetchDirection);
                this.currentFetchDirection = this.defaultFetchDirection;
            }
            this.setBusy(false);
        }
    }

    protected void handleException(SQLException e) throws SQLException {
        if (this._conn == null) {
            throw e;
        }
        this._conn.handleException(e);
    }

    protected void activate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).activate();
        }
    }

    protected void passivate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).passivate();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.getConnectionInternal();
    }

    protected DelegatingConnection<?> getConnectionInternal() {
        return this._conn;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSet();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxRows();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxRows(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getQueryTimeout();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.cancel();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setCursorName(name);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getUpdateCount();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults();
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchDirection();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchSize();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetType();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.addBatch(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    public String toString() {
        return this._stmt == null ? "NULL" : this._stmt.toString();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults(current);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed || this.cached && !this.isBusy();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (iface.isAssignableFrom(this._stmt.getClass())) {
            return true;
        }
        return this._stmt.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.isAssignableFrom(this._stmt.getClass())) {
            return iface.cast(this._stmt);
        }
        return this._stmt.unwrap(iface);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setPoolable(poolable);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.isPoolable();
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.closeOnCompletion();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.isCloseOnCompletion();
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getLargeUpdateCount();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setLargeMaxRows(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getLargeMaxRows();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeLargeBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeLargeUpdate(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeLargeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

