/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.ConnectionResult;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class DriverConnectionFactory
implements ConnectionFactory {
    private final Driver _driver;
    private final String _connectUri;
    private final Properties _props;

    public DriverConnectionFactory(Driver driver, String connectUri, Properties props) {
        this._driver = driver;
        this._connectUri = connectUri;
        this._props = props;
    }

    @Override
    public ConnectionResult getConnectionResult() throws SQLException {
        if (this._props == null) {
            return new ConnectionResult(null, this._driver.connect(this._connectUri, this._props));
        }
        Properties properties = new Properties();
        if (this._props.containsKey("user")) {
            properties.put("user", this._props.get("user"));
        }
        if (this._props.containsKey("password")) {
            properties.put("password", this._props.get("password"));
        }
        return new ConnectionResult(null, this._driver.connect(this._connectUri, properties));
    }

    @Override
    public ConnectionResult getConnectionResult(String username, String password) throws SQLException {
        Properties properties = new Properties();
        properties.put("user", username);
        properties.put("password", password);
        Connection conn = this._driver.connect(this._connectUri, properties);
        return new ConnectionResult(null, conn);
    }

    public String toString() {
        return this.getClass().getName() + " [" + String.valueOf(this._driver) + ";" + String.valueOf(this._connectUri) + ";" + String.valueOf(this._props) + "]";
    }
}

