/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.pool.ClockSource;
import com.bes.enterprise.gjc.pool.PooledObject;
import com.bes.enterprise.gjc.pool.PooledObjectFactory;
import com.bes.enterprise.gjc.pool.impl.DefaultPooledObject;
import com.bes.enterprise.gjc.pool.impl.GenericObjectPool;
import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.ConnectionResult;
import com.bes.enterprise.gjc.spi.LifetimeExceededException;
import com.bes.enterprise.gjc.spi.PoolableConnection;
import com.bes.enterprise.gjc.spi.PoolingConnection;
import com.bes.enterprise.gjc.spi.QueryReport;
import com.bes.enterprise.gjc.spi.SecurityInfo;
import com.bes.enterprise.gjc.spi.StatementCacheManager;
import com.bes.enterprise.gjc.spi.Utils;
import com.bes.enterprise.gjc.spi.base.datastructure.Cache;
import com.bes.enterprise.gjc.spi.base.datastructure.CacheFactory;
import com.bes.enterprise.gjc.spi.trace.TracedPoolableConnection;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;

public class PoolableConnectionFactory
implements PooledObjectFactory<PoolableConnection> {
    protected static final Log log = LogFactory.getLog(PoolableConnectionFactory.class);
    private static final ClockSource clockSource = ClockSource.INSTANCE;
    private Executor netTimeoutExecutor;
    private Boolean isNetworkTimeoutSupported;
    private final ConnectionFactory _connFactory;
    protected final ObjectName dataSourceJmxName;
    private volatile int validateAtmostPeriodInMilliSeconds = 0;
    private volatile String _validationQuery = null;
    private volatile int _validationQueryTimeout = -1;
    private Collection<String> _connectionInitSqls = null;
    private Collection<String> _disconnectionSqlCodes = null;
    private boolean _fastFailValidation = false;
    private boolean _failAllConnection = false;
    private boolean wrapStatement = true;
    protected volatile GenericObjectPool<PoolableConnection> _pool = null;
    private Boolean _defaultReadOnly = null;
    private Boolean _defaultAutoCommit = null;
    private boolean enableAutoCommitOnReturn = false;
    private boolean rollbackOnReturn = false;
    private int _defaultTransactionIsolation = -1;
    private String _defaultCatalog;
    private boolean _cacheState;
    private boolean poolPreparedStatements = false;
    private int maxOpenPreparedStatements = 8;
    private long maxConnLifetimeMillis = -1L;
    protected final AtomicLong connectionIndex = new AtomicLong(0L);
    private Integer defaultQueryTimeout = null;
    private Integer defaultFetchSize = null;
    private boolean poolStatements = false;
    private boolean usingTrace = false;
    protected boolean matchConnections = false;
    protected QueryReport queryReport;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectName dataSourceJmxName) {
        this._connFactory = connFactory;
        this.dataSourceJmxName = dataSourceJmxName;
    }

    public void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public void setValidationQueryTimeout(int timeout) {
        this._validationQueryTimeout = timeout;
    }

    public void setConnectionInitSql(Collection<String> connectionInitSqls) {
        this._connectionInitSqls = connectionInitSqls;
    }

    public synchronized void setPool(GenericObjectPool<PoolableConnection> pool) {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public synchronized GenericObjectPool<PoolableConnection> getPool() {
        return this._pool;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this._defaultCatalog = defaultCatalog;
    }

    public void setCacheState(boolean cacheState) {
        this._cacheState = cacheState;
    }

    public void setPoolStatements(boolean poolStatements) {
        this.poolStatements = poolStatements;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    public boolean isEnableAutoCommitOnReturn() {
        return this.enableAutoCommitOnReturn;
    }

    public void setEnableAutoCommitOnReturn(boolean enableAutoCommitOnReturn) {
        this.enableAutoCommitOnReturn = enableAutoCommitOnReturn;
    }

    public boolean isRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(Integer defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    public Integer getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public void setDefaultFetchSize(Integer defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
    }

    public int getValidateAtmostPeriodInMilliSeconds() {
        return this.validateAtmostPeriodInMilliSeconds;
    }

    public void setValidateAtmostPeriodInMilliSeconds(int validateAtmostPeriodInMilliSeconds) {
        this.validateAtmostPeriodInMilliSeconds = validateAtmostPeriodInMilliSeconds;
    }

    public Collection<String> getDisconnectionSqlCodes() {
        return this._disconnectionSqlCodes;
    }

    public void setDisconnectionSqlCodes(Collection<String> disconnectionSqlCodes) {
        this._disconnectionSqlCodes = disconnectionSqlCodes;
    }

    public boolean isFastFailValidation() {
        return this._fastFailValidation;
    }

    public void setFastFailValidation(boolean fastFailValidation) {
        this._fastFailValidation = fastFailValidation;
    }

    @Override
    public PooledObject<PoolableConnection> makeObject() throws Exception {
        Connection conn = null;
        ConnectionResult connectionResult = null;
        if (this.matchConnections) {
            String username = SecurityInfo.username.get();
            if (username != null) {
                String password = SecurityInfo.password.get();
                connectionResult = this._connFactory.getConnectionResult(username, password);
                conn = connectionResult.getConnection();
                if (conn == null) {
                    throw new IllegalStateException("Connection factory returned null from getConnectionResult");
                }
                conn.getClientInfo().put("internal_user", username);
            } else {
                connectionResult = this._connFactory.getConnectionResult();
                conn = connectionResult.getConnection();
                if (conn == null) {
                    throw new IllegalStateException("Connection factory returned null from getConnectionResult");
                }
            }
        } else {
            connectionResult = this._connFactory.getConnectionResult();
            conn = connectionResult.getConnection();
            if (conn == null) {
                throw new IllegalStateException("Connection factory returned null from getConnectionResult");
            }
        }
        try {
            this.initializeConnection(conn);
        }
        catch (SQLException sqle) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw sqle;
        }
        long connIndex = this.connectionIndex.getAndIncrement();
        Cache statementCache = null;
        if ((this.poolPreparedStatements || this.poolStatements) && this.maxOpenPreparedStatements > 0) {
            statementCache = CacheFactory.getDataStructure(null, this.maxOpenPreparedStatements);
        }
        if (statementCache != null) {
            conn = new PoolingConnection(conn);
            StatementCacheManager manager = new StatementCacheManager((PoolingConnection)conn, statementCache, this.poolPreparedStatements, this.poolStatements);
            ((PoolingConnection)conn).setStatementCacheManager(manager);
        }
        StringBuilder connName = new StringBuilder();
        connName.append("connection_").append(connIndex);
        ObjectName connJmxName = null;
        connJmxName = this.dataSourceJmxName == null ? null : new ObjectName(this.dataSourceJmxName.toString() + ",connectionpool=connections,connection=" + connIndex);
        PoolableConnection pc = !this.getUsingTrace() ? new PoolableConnection(connName.toString(), conn, this._pool, connJmxName, this._disconnectionSqlCodes, this._fastFailValidation, this.queryReport) : new TracedPoolableConnection(connName.toString(), conn, this._pool, connJmxName, this._disconnectionSqlCodes, this._fastFailValidation, this.queryReport);
        if (conn instanceof PoolingConnection) {
            ((PoolingConnection)conn).setPoolableConnection(pc);
        }
        pc.setCacheState(this._cacheState);
        pc.setFailAllConnection(this._failAllConnection);
        pc.setWrapStatement(this.wrapStatement);
        return new DefaultPooledObject<PoolableConnection>(pc);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        Collection<String> sqls = this._connectionInitSqls;
        if (conn.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (null != sqls) {
            try (Statement stmt = conn.createStatement();){
                for (String sql : sqls) {
                    if (sql == null) {
                        throw new NullPointerException("null connectionInitSqls element");
                    }
                    stmt.execute(sql);
                }
            }
        }
    }

    @Override
    public void destroyObject(PooledObject<PoolableConnection> p) throws Exception {
        this.setIsNetworkTimeoutSupported(p.getObject().getInnermostDelegate());
        p.getObject().reallyClose(this.netTimeoutExecutor, this.isNetworkTimeoutSupported);
    }

    @Override
    public boolean validateObject(PooledObject<PoolableConnection> p) {
        try {
            this.validateLifetime(p);
            this.validateConnection(p.getObject());
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Utils.getMessage("poolableConnectionFactory.validateObject.fail "), (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public boolean matchObject(PooledObject<PoolableConnection> p) {
        PoolableConnection conn = p.getObject();
        try {
            String username = SecurityInfo.username.get();
            if (username != null) {
                String connUser = (String)conn.getClientInfo().get("internal_user");
                return username.equals(connUser);
            }
        }
        catch (SQLException e) {
            log.warn((Object)"Match failed");
            return true;
        }
        return true;
    }

    public void setNetworkTimeoutExecutor(Executor netTimeoutExecutor) {
        this.netTimeoutExecutor = netTimeoutExecutor;
    }

    private void setIsNetworkTimeoutSupported(Connection connection) {
        if (this.isNetworkTimeoutSupported == null) {
            try {
                connection.getNetworkTimeout();
                this.isNetworkTimeoutSupported = this.netTimeoutExecutor != null;
            }
            catch (AbstractMethodError | Exception ex) {
                this.isNetworkTimeoutSupported = false;
            }
        }
    }

    public void validateConnection(PoolableConnection conn) throws SQLException {
        long timeSinceValidation;
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        boolean validationRequired = true;
        long currentTime = clockSource.currentTime();
        if (this.validateAtmostPeriodInMilliSeconds > 0 && (timeSinceValidation = clockSource.elapsedMillis(conn.getLastValidated(), currentTime)) < (long)this.validateAtmostPeriodInMilliSeconds) {
            validationRequired = false;
        }
        if (validationRequired) {
            conn.setLastValidated(currentTime);
            this.setIsNetworkTimeoutSupported(conn.getInnermostDelegate());
            conn.validate(this._validationQuery, this._validationQueryTimeout, this.netTimeoutExecutor, this.isNetworkTimeoutSupported);
        }
    }

    @Override
    public void passivateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        Boolean connAutoCommit = null;
        if (this.rollbackOnReturn && !(connAutoCommit = Boolean.valueOf(conn.getAutoCommit())).booleanValue() && !conn.isReadOnly()) {
            conn.rollback();
        }
        conn.clearWarnings();
        if (this.enableAutoCommitOnReturn) {
            if (connAutoCommit == null) {
                connAutoCommit = conn.getAutoCommit();
            }
            if (!connAutoCommit.booleanValue()) {
                conn.setAutoCommit(true);
            }
        }
        conn.passivate();
    }

    @Override
    public void activateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        conn.activate();
        if (this._defaultAutoCommit != null && conn.getAutoCommit() != this._defaultAutoCommit.booleanValue()) {
            conn.setAutoCommit(this._defaultAutoCommit);
        }
        if (this._defaultTransactionIsolation != -1 && conn.getTransactionIsolation() != this._defaultTransactionIsolation) {
            conn.setTransactionIsolation(this._defaultTransactionIsolation);
        }
        if (this._defaultReadOnly != null && conn.isReadOnly() != this._defaultReadOnly.booleanValue()) {
            conn.setReadOnly(this._defaultReadOnly);
        }
        if (this._defaultCatalog != null && !this._defaultCatalog.equals(conn.getCatalog())) {
            conn.setCatalog(this._defaultCatalog);
        }
        conn.setDefaultQueryTimeout(this.defaultQueryTimeout);
        conn.setDefaultFetchSize(this.defaultFetchSize);
    }

    private void validateLifetime(PooledObject<PoolableConnection> p) throws Exception {
        long lifetime;
        if (this.maxConnLifetimeMillis > 0L && (lifetime = clockSource.elapsedMillis(p.getCreateTime())) > this.maxConnLifetimeMillis) {
            throw new LifetimeExceededException(Utils.getMessage("connectionFactory.lifetimeExceeded", lifetime, this.maxConnLifetimeMillis));
        }
    }

    protected ConnectionFactory getConnectionFactory() {
        return this._connFactory;
    }

    protected boolean getPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    protected boolean getPoolStatements() {
        return this.poolStatements;
    }

    protected int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    protected boolean getCacheState() {
        return this._cacheState;
    }

    protected ObjectName getDataSourceJmxName() {
        return this.dataSourceJmxName;
    }

    protected AtomicLong getConnectionIndex() {
        return this.connectionIndex;
    }

    public void setQueryReporter(QueryReport queryReport) {
        this.queryReport = queryReport;
    }

    public void setUsingTrace(boolean usingTrace) {
        this.usingTrace = usingTrace;
    }

    public boolean getUsingTrace() {
        return this.usingTrace;
    }

    public boolean isMatchConnections() {
        return this.matchConnections;
    }

    public void setMatchConnections(boolean matchConnections) {
        this.matchConnections = matchConnections;
    }

    public void setFailAllConnection(boolean failAllConnection) {
        this._failAllConnection = failAllConnection;
    }

    public boolean isFailAllConnection() {
        return this._failAllConnection;
    }

    public boolean isWrapStatement() {
        return this.wrapStatement;
    }

    public void setWrapStatement(boolean wrapStatement) {
        this.wrapStatement = wrapStatement;
    }
}

