/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.DelegatingCallableStatement;
import com.bes.enterprise.gjc.spi.DelegatingConnection;
import com.bes.enterprise.gjc.spi.DelegatingPreparedStatement;
import com.bes.enterprise.gjc.spi.DelegatingStatement;
import com.bes.enterprise.gjc.spi.PoolableConnection;
import com.bes.enterprise.gjc.spi.StatementCacheManager;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class PoolingConnection
extends DelegatingConnection<Connection> {
    private StatementCacheManager statementCacheManager;
    private PoolableConnection poolableConnection;

    public PoolableConnection getPoolableConnection() {
        return this.poolableConnection;
    }

    public void setPoolableConnection(PoolableConnection poolableConnection) {
        this.poolableConnection = poolableConnection;
    }

    public PoolingConnection(Connection c) {
        super(c);
    }

    public void setStatementCacheManager(StatementCacheManager statementCacheManager) {
        this.statementCacheManager = statementCacheManager;
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.statementCacheManager.close();
        }
        finally {
            this.getDelegateInternal().close();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.statementCacheManager.cachedStatement();
        }
        catch (Exception e) {
            throw new SQLException("Borrow Statement from pool failed", e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.statementCacheManager.cachedStatement(resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw new SQLException("Borrow Statement from pool failed", e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.statementCacheManager.cachedStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (Exception e) {
            throw new SQLException("Create statement failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedStatement(sql);
        }
        catch (Exception e) {
            throw new SQLException("Prepare statement failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedStatement(sql, autoGeneratedKeys);
        }
        catch (Exception e) {
            throw new SQLException("Prepare statement failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw new SQLException("Prepare statement failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (Exception e) {
            throw new SQLException("Prepare statement failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedStatement(sql, columnIndexes);
        }
        catch (Exception e) {
            throw new SQLException("Prepare statement failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedStatement(sql, columnNames);
        }
        catch (Exception e) {
            throw new SQLException("Prepare statement failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedCallableStatement(sql);
        }
        catch (Exception e) {
            throw new SQLException("Prepare callable statement failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedCallableStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw new SQLException("Prepare callable statement failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.statementCacheManager.prepareCachedCallableStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (Exception e) {
            throw new SQLException("Prepare callable statement failed", e);
        }
    }

    public DelegatingStatement cachedStatement(boolean enableCaching) throws SQLException {
        Statement statement = this.getDelegateInternal().createStatement();
        DelegatingStatement stmt = new DelegatingStatement(this.poolableConnection, statement, enableCaching);
        return stmt;
    }

    public DelegatingStatement cachedStatement(int resultSetType, int resultSetConcurrency, boolean enableCaching) throws SQLException {
        Statement statement = this.getDelegateInternal().createStatement(resultSetType, resultSetConcurrency);
        DelegatingStatement stmt = new DelegatingStatement(this.poolableConnection, statement, enableCaching);
        return stmt;
    }

    public DelegatingStatement cachedStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean enableCaching) throws SQLException {
        Statement statement = this.getDelegateInternal().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        DelegatingStatement stmt = new DelegatingStatement(this.poolableConnection, statement, enableCaching);
        return stmt;
    }

    public DelegatingPreparedStatement prepareCachedStatement(String sql, boolean enableCaching) throws SQLException {
        PreparedStatement preparedStatement = this.getDelegateInternal().prepareStatement(sql);
        return new DelegatingPreparedStatement(this.poolableConnection, preparedStatement, enableCaching);
    }

    public DelegatingPreparedStatement prepareCachedStatement(String sql, int resultSetType, int resultSetConcurrency, boolean enableCaching) throws SQLException {
        PreparedStatement preparedStatement = this.getDelegateInternal().prepareStatement(sql, resultSetType, resultSetConcurrency);
        return new DelegatingPreparedStatement(this.poolableConnection, preparedStatement, enableCaching);
    }

    public DelegatingPreparedStatement prepareCachedStatement(String sql, String[] columnNames, boolean enableCaching) throws SQLException {
        PreparedStatement preparedStatement = this.getDelegateInternal().prepareStatement(sql, columnNames);
        return new DelegatingPreparedStatement(this.poolableConnection, preparedStatement, enableCaching);
    }

    public DelegatingPreparedStatement prepareCachedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean enableCaching) throws SQLException {
        CallableStatement preparedStatement = this.getDelegateInternal().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new DelegatingPreparedStatement(this.poolableConnection, preparedStatement, enableCaching);
    }

    public DelegatingPreparedStatement prepareCachedStatement(String sql, int[] columnIndexes, boolean enableCaching) throws SQLException {
        PreparedStatement preparedStatement = this.getDelegateInternal().prepareStatement(sql, columnIndexes);
        return new DelegatingPreparedStatement(this.poolableConnection, preparedStatement, enableCaching);
    }

    public DelegatingPreparedStatement prepareCachedStatement(String sql, int autoGeneratedKeys, boolean enableCaching) throws SQLException {
        PreparedStatement preparedStatement = this.getDelegateInternal().prepareStatement(sql, autoGeneratedKeys);
        return new DelegatingPreparedStatement(this.poolableConnection, preparedStatement, enableCaching);
    }

    public DelegatingCallableStatement callableCachedStatement(String sql, boolean enableCaching) throws SQLException {
        CallableStatement callableStatement = this.getDelegateInternal().prepareCall(sql);
        return new DelegatingCallableStatement(this.poolableConnection, callableStatement, enableCaching);
    }

    public DelegatingCallableStatement callableCachedStatement(String sql, int resultSetType, int resultSetConcurrency, boolean enableCaching) throws SQLException {
        CallableStatement callableStatement = this.getDelegateInternal().prepareCall(sql, resultSetType, resultSetConcurrency);
        return new DelegatingCallableStatement(this.poolableConnection, callableStatement, enableCaching);
    }

    public DelegatingCallableStatement callableCachedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean enableCaching) throws SQLException {
        CallableStatement callableStatement = this.getDelegateInternal().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new DelegatingCallableStatement(this.poolableConnection, callableStatement, enableCaching);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    @Override
    public String toString() {
        return "PoolingConnection: " + this.getDelegateInternal();
    }

    protected static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

