/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.base;

import java.util.Arrays;

public class CacheObjectKey {
    public static final String CALLABLE_STATEMENT = "CS";
    public static final String PREPARED_STATEMENT = "PS";
    public static final String STATEMENT = "S";
    protected String sql = null;
    private final String catalog;
    protected String statementType = null;
    protected Integer resultSetType;
    protected Integer resultSetConcurrency;
    protected Integer resultSetHoldability;
    protected Integer autoGeneratedKeys;
    protected int[] columnIndexes;
    protected String[] columnNames;

    public CacheObjectKey(String sql, String catalog, String statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = statementType;
    }

    public CacheObjectKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, String statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = statementType;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public CacheObjectKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = statementType;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public CacheObjectKey(String sql, String catalog, int[] columnIndexes) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = PREPARED_STATEMENT;
        this.columnIndexes = columnIndexes;
    }

    public CacheObjectKey(String sql, String catalog, String[] columnNames) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = PREPARED_STATEMENT;
        this.columnNames = columnNames;
    }

    public CacheObjectKey(String sql, String catalog, int autoGeneratedKeys) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = PREPARED_STATEMENT;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheObjectKey other = (CacheObjectKey)obj;
        if (!(this.sql != null && other.sql != null && this.sql.equals(other.sql) || STATEMENT.equals(other.statementType))) {
            return false;
        }
        if (this.statementType == null || other.statementType == null || !this.statementType.equals(other.statementType)) {
            return false;
        }
        if (this.resultSetType == null ? other.resultSetType != null : !this.resultSetType.equals(other.resultSetType)) {
            return false;
        }
        if (this.resultSetConcurrency == null ? other.resultSetConcurrency != null : !this.resultSetConcurrency.equals(other.resultSetConcurrency)) {
            return false;
        }
        if (this.resultSetHoldability == null ? other.resultSetHoldability != null : !this.resultSetHoldability.equals(other.resultSetHoldability)) {
            return false;
        }
        if (this.catalog == null ? other.catalog != null : !this.catalog.equals(other.catalog)) {
            return false;
        }
        if (PREPARED_STATEMENT.equals(other.statementType)) {
            if (this.autoGeneratedKeys == null ? other.autoGeneratedKeys != null : !this.autoGeneratedKeys.equals(other.autoGeneratedKeys)) {
                return false;
            }
            if (this.columnIndexes != null && other.columnIndexes != null && !Arrays.equals(this.columnIndexes, other.columnIndexes)) {
                return false;
            }
            if (this.columnNames != null && other.columnNames != null && !Arrays.equals(this.columnNames, other.columnNames)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.sql != null ? this.sql.hashCode() : 0);
        hash = 41 * hash + (this.statementType != null ? this.statementType.hashCode() : 0);
        hash = 41 * hash + (this.resultSetType != null ? this.resultSetType.hashCode() : 0);
        hash = 41 * hash + (this.resultSetConcurrency != null ? this.resultSetConcurrency.hashCode() : 0);
        hash = 41 * hash + (this.resultSetHoldability != null ? this.resultSetHoldability.hashCode() : 0);
        if (PREPARED_STATEMENT.equals(this.statementType)) {
            hash = 41 * hash + (this.autoGeneratedKeys != null ? this.autoGeneratedKeys.hashCode() : 0);
            if (this.columnIndexes != null) {
                for (int i : this.columnIndexes) {
                    hash = 41 * hash + Integer.valueOf(i).hashCode();
                }
            }
            if (this.columnNames != null) {
                for (String str : this.columnNames) {
                    hash = 41 * hash + str.hashCode();
                }
            }
        }
        return hash;
    }

    public String getStatementType() {
        return this.statementType;
    }

    public String getSql() {
        return this.sql;
    }
}

