/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.base.datastructure;

import com.bes.enterprise.gjc.spi.base.datastructure.Cache;
import com.bes.enterprise.gjc.spi.base.datastructure.LRUCacheEnhanceImpl;
import com.bes.enterprise.gjc.spi.base.datastructure.LRUCacheImpl;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class CacheFactory {
    private static final Log _logger = LogFactory.getLog(CacheFactory.class);

    public static Cache getDataStructure(String className, int maxSize) throws RuntimeException {
        Cache stmtCacheStructure;
        if (className == null || className.trim().equals("")) {
            if (_logger.isDebugEnabled()) {
                CacheFactory.debug("Initializing LRU Cache Implementation");
            }
            stmtCacheStructure = new LRUCacheImpl(maxSize);
        } else if (className.trim().equals("com.bes.enterprise.gjc.spi.base.datastructure.LRUCacheEnhanceImpl")) {
            if (_logger.isDebugEnabled()) {
                CacheFactory.debug("Initializing LRU Cache Enhance Implementation");
            }
            stmtCacheStructure = new LRUCacheEnhanceImpl(maxSize);
        } else {
            stmtCacheStructure = CacheFactory.initCustomCacheStructurePrivileged(className, maxSize);
        }
        return stmtCacheStructure;
    }

    private static Cache initCustomCacheStructurePrivileged(final String className, final int cacheSize) throws RuntimeException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cache result = null;
                try {
                    result = CacheFactory.initializeCacheStructure(className, cacheSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        });
        if (result != null) {
            return (Cache)result;
        }
        throw new RuntimeException("Unable to initalize custom DataStructure for Statement Cahe : " + className);
    }

    private static Cache initializeCacheStructure(String className, int maxSize) throws Exception {
        Object[] constructorParameters = new Object[]{maxSize};
        Class<?> class1 = Class.forName(className);
        Constructor<?> constructor = class1.getConstructor(class1, Integer.class);
        Cache ds = (Cache)constructor.newInstance(constructorParameters);
        return ds;
    }

    private static void debug(String debugStatement) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)debugStatement);
        }
    }
}

