/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache;

import com.bes.enterprise.gjc.spi.cache.CacheKey;
import com.bes.enterprise.gjc.spi.cache.CacheSqlParse;
import com.bes.enterprise.gjc.spi.cache.CacheValidSqlParse;
import java.util.List;

public class CacheSqlKey
extends CacheKey {
    private static final long serialVersionUID = 3023313444664947667L;
    private String sql;
    private List<String> selectTables;
    private List<String> updateTables;
    private boolean hasCacheInvalidInit = false;
    private boolean cacheValid = true;

    public CacheSqlKey(String sql) {
        this.sql = sql;
    }

    public CacheSqlKey(Object[] objects) {
        super(objects);
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    private void initSelectTable() {
        if (this.selectTables == null) {
            CacheSqlParse parse = new CacheSqlParse(this.sql);
            this.selectTables = parse.getSelectTables();
        }
    }

    private void initUpdateTable() {
        if (this.updateTables == null) {
            CacheSqlParse parse = new CacheSqlParse(this.sql);
            this.updateTables = parse.getUpdateTables();
        }
    }

    public boolean containsTable(String table) {
        this.initSelectTable();
        return this.selectTables.contains(table);
    }

    public boolean hasSelectTables() {
        this.initSelectTable();
        return this.selectTables.size() > 0;
    }

    public boolean hasUpdateTables() {
        this.initUpdateTable();
        return this.updateTables.size() > 0;
    }

    public boolean isSqlCacheValid() {
        if (!this.hasCacheInvalidInit) {
            CacheValidSqlParse parse = new CacheValidSqlParse(this.sql);
            this.cacheValid = parse.cacheValid();
            this.hasCacheInvalidInit = true;
        }
        return this.cacheValid;
    }
}

