/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache;

import java.util.ArrayList;
import java.util.List;

public class CacheSqlParse {
    private String sql;

    public CacheSqlParse(String sql) {
        this.sql = sql;
    }

    public List<String> getSelectTables() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.sql != null) {
            String[] words = this.sql.split("[\\s]+|\\)");
            boolean recordFlag = false;
            for (int i = 0; i < words.length; ++i) {
                String word = words[i].toUpperCase();
                if (recordFlag) {
                    recordFlag = false;
                    boolean match = word.matches("[_.\\[\\]a-zA-Z0-9]+");
                    if (!match || list.contains(word)) continue;
                    list.add(word);
                    continue;
                }
                if (!"FROM".equals(word)) continue;
                recordFlag = true;
            }
        }
        return list;
    }

    public List<String> getUpdateTables() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.sql != null) {
            String updateSql = this.sql.toUpperCase();
            updateSql = updateSql.replaceAll("DELETE[\\s]+FROM", "DML_SQL_BEFOR_TABLE");
            updateSql = updateSql.replaceAll("DELETE", "DML_SQL_BEFOR_TABLE");
            updateSql = updateSql.replaceAll("UPDATE", "DML_SQL_BEFOR_TABLE");
            updateSql = updateSql.replaceAll("INSERT[\\s]+INTO", "DML_SQL_BEFOR_TABLE");
            String[] words = updateSql.split("[\\s]+|\\(");
            boolean recordFlag = false;
            for (int i = 0; i < words.length; ++i) {
                String word = words[i].toUpperCase();
                if (recordFlag) {
                    recordFlag = false;
                    boolean match = word.matches("[_.\\[\\]a-zA-Z0-9]+");
                    if (!match || list.contains(word)) continue;
                    list.add(word);
                    continue;
                }
                if (!"DML_SQL_BEFOR_TABLE".equals(word)) continue;
                recordFlag = true;
            }
        }
        return list;
    }
}

