/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.decorators;

import com.bes.enterprise.gjc.pool.ClockSource;
import com.bes.enterprise.gjc.spi.cache.Cache;
import java.util.concurrent.locks.ReadWriteLock;

public class ScheduledCache
implements Cache {
    private static final ClockSource clockSource = ClockSource.INSTANCE;
    private Cache delegate;
    protected long clearInterval;
    protected long lastClear;

    public ScheduledCache(Cache delegate) {
        this.delegate = delegate;
        this.clearInterval = 3600000L;
        this.lastClear = clockSource.currentTime();
    }

    public void setClearInterval(long clearInterval) {
        this.clearInterval = clearInterval;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        this.clearWhenStale();
        return this.delegate.getSize();
    }

    @Override
    public void putObject(Object key, Object object) {
        this.clearWhenStale();
        this.delegate.putObject(key, object);
    }

    @Override
    public Object getObject(Object key) {
        if (this.clearWhenStale()) {
            return null;
        }
        return this.delegate.getObject(key);
    }

    @Override
    public Object removeObject(Object key) {
        this.clearWhenStale();
        return this.delegate.removeObject(key);
    }

    @Override
    public void clear() {
        this.lastClear = clockSource.currentTime();
        this.delegate.clear();
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    private boolean clearWhenStale() {
        if (clockSource.elapsedMillis(this.lastClear) > this.clearInterval) {
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public void clearCatalog(String catalog) {
        this.delegate.clearCatalog(catalog);
    }
}

