/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.decorators;

import com.bes.enterprise.gjc.spi.cache.Cache;
import java.util.concurrent.locks.ReadWriteLock;

public class SynchronizedCache
implements Cache {
    private Cache delegate;

    public SynchronizedCache(Cache delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        this.acquireReadLock();
        try {
            int n = this.delegate.getSize();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void putObject(Object key, Object object) {
        this.acquireWriteLock();
        try {
            this.delegate.putObject(key, object);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public Object getObject(Object key) {
        this.acquireReadLock();
        try {
            Object object = this.delegate.getObject(key);
            return object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public Object removeObject(Object key) {
        this.acquireWriteLock();
        try {
            Object object = this.delegate.removeObject(key);
            return object;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void clear() {
        this.acquireWriteLock();
        try {
            this.delegate.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    private void acquireReadLock() {
        this.getReadWriteLock().readLock().lock();
    }

    private void releaseReadLock() {
        this.getReadWriteLock().readLock().unlock();
    }

    private void acquireWriteLock() {
        this.getReadWriteLock().writeLock().lock();
    }

    private void releaseWriteLock() {
        this.getReadWriteLock().writeLock().unlock();
    }

    @Override
    public void clearCatalog(String catalog) {
        this.acquireWriteLock();
        try {
            this.delegate.clearCatalog(catalog);
        }
        finally {
            this.releaseWriteLock();
        }
    }
}

