/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.impl;

import com.bes.enterprise.gjc.pool.ClockSource;
import com.bes.enterprise.gjc.spi.Constants;
import com.bes.enterprise.gjc.spi.cache.Cache;
import com.bes.enterprise.gjc.spi.cache.CacheException;
import com.bes.enterprise.gjc.spi.cache.CacheSqlParse;
import com.bes.enterprise.gjc.spi.cache.decorators.FifoCache;
import com.bes.enterprise.gjc.spi.cache.decorators.ScheduledCache;
import com.bes.enterprise.gjc.spi.cache.decorators.SoftCache;
import com.bes.enterprise.gjc.spi.cache.decorators.SynchronizedCache;
import com.bes.enterprise.gjc.spi.cache.impl.PerpetualCache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BesJdbcCache
implements Cache {
    private static final ClockSource clockSource = ClockSource.INSTANCE;
    private static ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static Map<String, BesJdbcCache> dict = new HashMap<String, BesJdbcCache>();
    private static long lastCheckTime = clockSource.currentTime();
    private static long cacheClearInterval = Constants.GLOBAL_CACHE_CLEAR_INTERVAL;
    private static ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private static List<WeakEntry> referenceList = new ArrayList<WeakEntry>();
    private static Map<Object, Integer> counts = new HashMap<Object, Integer>();
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private ArrayBlockingQueue<String> queue;
    private String id;
    private Cache cache = this.getCache();

    private BesJdbcCache(String id) {
        this.queue = new ArrayBlockingQueue(1024);
        this.id = id;
        this.cache = this.getCache();
    }

    public static void clearBindingCache() {
        if (clockSource.elapsedMillis(lastCheckTime) > cacheClearInterval) {
            readWriteLock.writeLock().lock();
            try {
                WeakEntry sv;
                while ((sv = (WeakEntry)referenceQueue.poll()) != null) {
                    referenceList.remove(sv);
                    dict.remove(sv.key);
                }
            }
            finally {
                readWriteLock.writeLock().unlock();
            }
            lastCheckTime = clockSource.currentTime();
        }
    }

    public static BesJdbcCache createInstance(String id) {
        BesJdbcCache.clearBindingCache();
        readWriteLock.readLock().lock();
        try {
            if (dict.containsKey(id)) {
                BesJdbcCache besJdbcCache = dict.get(id);
                return besJdbcCache;
            }
        }
        finally {
            readWriteLock.readLock().unlock();
        }
        BesJdbcCache e = new BesJdbcCache(id);
        readWriteLock.writeLock().lock();
        try {
            dict.put(id, e);
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BesJdbcCache getObjRefBindingCache(Object obj) {
        if (obj == null) {
            BesJdbcCache e = new BesJdbcCache("null");
            return e;
        }
        BesJdbcCache.clearBindingCache();
        String id = obj.getClass().getName() + "@" + System.identityHashCode(obj);
        readWriteLock.readLock().lock();
        try {
            if (dict.containsKey(id)) {
                BesJdbcCache besJdbcCache = dict.get(id);
                return besJdbcCache;
            }
        }
        finally {
            readWriteLock.readLock().unlock();
        }
        WeakEntry weakReference = new WeakEntry(id, obj, referenceQueue);
        BesJdbcCache e = new BesJdbcCache(id);
        readWriteLock.writeLock().lock();
        try {
            referenceList.add(weakReference);
            dict.put(id, e);
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
        return e;
    }

    public static BesJdbcCache createAloneCache(String id) {
        BesJdbcCache e = new BesJdbcCache(id);
        return e;
    }

    @Override
    public void putObject(Object key, Object value) {
        this.cache.putObject(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Object key) {
        readWriteLock.writeLock().lock();
        try {
            Integer count = counts.get(key);
            if (count == null) {
                counts.put(key, 1);
                Object var3_3 = null;
                return var3_3;
            }
            count = count + 1;
            counts.put(key, count);
            Object resultObject = this.cache.getObject(key);
            if (resultObject == null) {
                Object var4_5 = null;
                return var4_5;
            }
            if (count >= Constants.RESULT_SET_AYNCRADIO) {
                counts.put(key, 0);
                Object object = resultObject;
                return object;
            }
            Object object = new Object();
            return object;
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public Object removeObject(Object key) {
        return this.cache.removeObject(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    private Cache getCache() {
        try {
            Cache cache = new PerpetualCache(this.id);
            cache = new FifoCache(cache);
            ((FifoCache)cache).setSize(Constants.RESULT_SET_CACHE_SIZE);
            cache = new SoftCache(cache);
            cache = new SynchronizedCache(cache);
            cache = new ScheduledCache(cache);
            ((ScheduledCache)cache).setClearInterval(Constants.RESULT_SET_CACHE_CLEAR_INTERVAL);
            return cache;
        }
        catch (Exception e) {
            throw new CacheException("Error building standard cache decorators.  Cause: " + e, e);
        }
    }

    public void recordUpdateSql(String sql) {
        if (Constants.RESULT_SET_CACHE_UPDATE_ASYNCHRONOUSLY) {
            this.queue.offer(sql);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("updateResultSetCacheThread");
                    String updateSql = (String)BesJdbcCache.this.queue.poll();
                    BesJdbcCache.this.clearCacheByUpdateSql(updateSql);
                }
            });
        } else {
            this.clearCacheByUpdateSql(sql);
        }
    }

    public void clearCacheByUpdateSql(String updateSql) {
        CacheSqlParse parse = new CacheSqlParse(updateSql);
        List<String> upateTables = parse.getUpdateTables();
        for (int i = 0; i < upateTables.size(); ++i) {
            String table = upateTables.get(i);
            this.clearCatalog(table);
        }
    }

    @Override
    public String getId() {
        return this.cache.getId();
    }

    @Override
    public int getSize() {
        return this.cache.getSize();
    }

    @Override
    public void clearCatalog(String catalog) {
        this.cache.clearCatalog(catalog);
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.cache.getReadWriteLock();
    }

    private static class WeakEntry
    extends WeakReference<Object> {
        private final Object key;

        private WeakEntry(Object key, Object value, ReferenceQueue<Object> garbageCollectionQueue) {
            super(value, garbageCollectionQueue);
            this.key = key;
        }
    }
}

