/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.impl;

import com.bes.enterprise.gjc.spi.cache.Cache;
import com.bes.enterprise.gjc.spi.cache.CacheException;
import com.bes.enterprise.gjc.spi.cache.CacheSqlKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PerpetualCache
implements Cache {
    private String id;
    private Map<Object, Object> cache = new HashMap<Object, Object>();
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public PerpetualCache(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getSize() {
        return this.cache.size();
    }

    @Override
    public void putObject(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public Object getObject(Object key) {
        return this.cache.get(key);
    }

    @Override
    public Object removeObject(Object key) {
        return this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public boolean equals(Object o) {
        if (this.getId() == null) {
            throw new CacheException("Cache instances require an ID.");
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cache)) {
            return false;
        }
        Cache otherCache = (Cache)o;
        return this.getId().equals(otherCache.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            throw new CacheException("Cache instances require an ID.");
        }
        return this.getId().hashCode();
    }

    @Override
    public void clearCatalog(String catalog) {
        Iterator<Map.Entry<Object, Object>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            CacheSqlKey cacheSqlKey;
            Map.Entry<Object, Object> entry = iterator.next();
            if (!(entry.getKey() instanceof CacheSqlKey) || !(cacheSqlKey = (CacheSqlKey)entry.getKey()).containsTable(catalog)) continue;
            iterator.remove();
        }
    }
}

