/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.resultset;

import com.bes.enterprise.gjc.spi.cache.resultset.IndependentResultData;
import com.bes.enterprise.gjc.spi.cache.resultset.UnImplementResultSet;
import com.bes.enterprise.gjc.spi.cache.resultset.conversion.ConverterUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class CacheResultSet
extends UnImplementResultSet {
    private IndependentResultData resultData;
    private int currIndex = -1;
    private int currCol = 1;

    private CacheResultSet() {
    }

    public static CacheResultSet wrapper(IndependentResultData resultData) {
        CacheResultSet obj = new CacheResultSet();
        obj.resultData = resultData;
        return obj;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.currIndex;
        return this.currIndex < this.resultData.getData().size();
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.resultData.getNullData().get(this.currIndex).get(this.currCol);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (String)this.getObject(columnIndex, String.class);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Boolean)this.getObject(columnIndex, Boolean.class);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Byte)this.getObject(columnIndex, Byte.class);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Short)this.getObject(columnIndex, Short.class);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Integer)this.getObject(columnIndex, Integer.class);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Long)this.getObject(columnIndex, Long.class);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return ((Float)this.getObject(columnIndex, Float.class)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Double)this.getObject(columnIndex, Double.class);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Date)this.getObject(columnIndex, Date.class);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Time)this.getObject(columnIndex, Time.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.currCol = columnIndex;
        return (Timestamp)this.getObject(columnIndex, Timestamp.class);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultData.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.resultData.getData().get(this.currIndex).get(columnIndex);
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        Object val = this.resultData.getData().get(this.currIndex).get(columnIndex);
        val = ConverterUtil.convert(val, type);
        return val;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.resultData.getMetaData().getColumnIndex(columnName);
    }

    @Override
    public int getType() throws SQLException {
        return this.resultData.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.resultData.getResultSetConcurrency();
    }
}

