/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.resultset;

import com.bes.enterprise.gjc.spi.Constants;
import com.bes.enterprise.gjc.spi.cache.CacheSqlKey;
import com.bes.enterprise.gjc.spi.cache.impl.BesJdbcCache;
import com.bes.enterprise.gjc.spi.cache.resultset.CacheResultSet;
import com.bes.enterprise.gjc.spi.cache.resultset.Cacheable;
import com.bes.enterprise.gjc.spi.cache.resultset.IndependentResultData;
import com.bes.enterprise.gjc.spi.cache.resultset.ParameterPreparedStatement;
import com.bes.enterprise.gjc.spi.cache.resultset.PhysicalResultSetHolder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CacheableResultSetStatement
extends ParameterPreparedStatement
implements Cacheable {
    private BesJdbcCache resultSetCache;
    private PhysicalResultSetHolder resultHolder = null;
    private CacheResultSet cacheResultSet = null;
    private boolean cacheExists = false;
    private boolean cacheEnable = false;

    public CacheableResultSetStatement(Statement statement, BesJdbcCache resultSetCache) {
        super(statement);
        this.resultSetCache = resultSetCache;
    }

    public CacheableResultSetStatement(PreparedStatement pStatement, String sql, BesJdbcCache resultSetCache) {
        super(pStatement, sql);
        this.resultSetCache = resultSetCache;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.initExecuteEnv();
        if (this.isCacheable()) {
            CacheSqlKey cacheKey = this.getCacheKey(this.sql, null);
            if (this.getSqlCacheable(cacheKey)) {
                PhysicalResultSetHolder pcrs;
                Object object = this.resultSetCache.getObject(cacheKey);
                if (object != null) {
                    if (object instanceof IndependentResultData) {
                        IndependentResultData rsd = (IndependentResultData)object;
                        this.cacheExists = true;
                        this.cacheResultSet = CacheResultSet.wrapper(rsd);
                        return this.cacheResultSet;
                    }
                    return super.executeQuery();
                }
                this.cacheEnable = true;
                ResultSet rs = super.executeQuery();
                this.resultHolder = pcrs = new PhysicalResultSetHolder(rs, cacheKey, this.resultSetCache, true);
                return pcrs;
            }
            return super.executeQuery();
        }
        return super.executeQuery();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.initExecuteEnv();
        if (this.isCacheable()) {
            CacheSqlKey cacheKey = this.getCacheKey(sql, null);
            if (this.getSqlCacheable(cacheKey)) {
                PhysicalResultSetHolder pcrs;
                Object object = this.resultSetCache.getObject(cacheKey);
                if (object != null) {
                    if (object instanceof IndependentResultData) {
                        IndependentResultData rsd = (IndependentResultData)object;
                        this.cacheExists = true;
                        this.cacheResultSet = CacheResultSet.wrapper(rsd);
                        return this.cacheResultSet;
                    }
                    return super.executeQuery(sql);
                }
                this.cacheEnable = true;
                ResultSet rs = super.executeQuery(sql);
                this.resultHolder = pcrs = new PhysicalResultSetHolder(rs, cacheKey, this.resultSetCache, true);
                return pcrs;
            }
            return super.executeQuery(sql);
        }
        return super.executeQuery(sql);
    }

    public CacheSqlKey getCacheKey(String sql, String prefix) {
        CacheSqlKey key = new CacheSqlKey(sql);
        if (prefix != null) {
            key.update(prefix);
        }
        key.update(this.sql);
        for (int i = 1; i <= this.parameters.size(); ++i) {
            Object val = this.parameters.get(i);
            key.update(val);
        }
        return key;
    }

    @Override
    public boolean isCacheable() throws SQLException {
        boolean cache = false;
        if (this.getResultSetType() == 1003 && this.getResultSetConcurrency() == 1007) {
            cache = true;
            for (int i = 1; i <= this.parameters.size(); ++i) {
                Object val = this.parameters.get(i);
                if (Cacheable.cacheParameterTypes.contains(val.getClass().getName())) continue;
                cache = false;
                break;
            }
        }
        return cache;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.resultSetCache.recordUpdateSql(this.sql);
        return super.executeUpdate();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        return super.executeUpdate(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        return super.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        return super.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        return super.executeUpdate(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.resultSetCache.recordUpdateSql(this.sql);
        return super.executeBatch();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        return super.execute(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        return super.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        return super.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute() throws SQLException {
        this.resultSetCache.recordUpdateSql(this.sql);
        this.initExecuteEnv();
        if (this.isCacheable()) {
            CacheSqlKey cacheKey = this.getCacheKey(this.sql, null);
            if (this.getSqlCacheable(cacheKey)) {
                PhysicalResultSetHolder pcrs;
                Object object = this.resultSetCache.getObject(cacheKey);
                if (object != null) {
                    if (object instanceof IndependentResultData) {
                        IndependentResultData rsd = (IndependentResultData)object;
                        this.cacheExists = true;
                        this.cacheResultSet = CacheResultSet.wrapper(rsd);
                        return true;
                    }
                    return super.execute();
                }
                this.cacheEnable = true;
                boolean rst = super.execute();
                ResultSet rs = super.getResultSet();
                this.resultHolder = pcrs = new PhysicalResultSetHolder(rs, cacheKey, this.resultSetCache, false);
                return rst;
            }
            return super.execute();
        }
        return super.execute();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        this.initExecuteEnv();
        if (this.isCacheable()) {
            CacheSqlKey cacheKey = this.getCacheKey(sql, null);
            if (this.getSqlCacheable(cacheKey)) {
                PhysicalResultSetHolder pcrs;
                Object object = this.resultSetCache.getObject(cacheKey);
                if (object != null) {
                    if (object instanceof IndependentResultData) {
                        IndependentResultData rsd = (IndependentResultData)object;
                        this.cacheExists = true;
                        this.cacheResultSet = CacheResultSet.wrapper(rsd);
                        return true;
                    }
                    return super.execute(sql);
                }
                this.cacheEnable = true;
                boolean rst = super.execute(sql);
                ResultSet rs = super.getResultSet();
                this.resultHolder = pcrs = new PhysicalResultSetHolder(rs, cacheKey, this.resultSetCache, false);
                return rst;
            }
            return super.execute(sql);
        }
        return super.execute(sql);
    }

    private void initExecuteEnv() {
        this.resultHolder = null;
        this.cacheExists = false;
        this.cacheEnable = false;
        this.cacheResultSet = null;
    }

    private boolean getSqlCacheable(CacheSqlKey cacheKey) {
        if (Constants.RESULT_SET_CACHE_CHECK_SQL) {
            return cacheKey.isSqlCacheValid() && cacheKey.hasSelectTables() && !cacheKey.hasUpdateTables();
        }
        return true;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.resultSetCache.recordUpdateSql(sql);
        super.addBatch(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.cacheEnable && this.resultHolder != null && !this.resultHolder.isAutoCache()) {
            this.resultHolder.saveCache();
        }
        super.close();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.cacheExists) {
            return -1;
        }
        int count = super.getUpdateCount();
        if (count != -1) {
            this.cacheEnable = false;
        }
        return count;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.cacheExists) {
            return this.cacheResultSet;
        }
        if (this.cacheEnable) {
            return this.resultHolder;
        }
        return super.getResultSet();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.cacheExists) {
            return false;
        }
        boolean result = super.getMoreResults(current);
        if (result) {
            this.cacheEnable = false;
        }
        return result;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.cacheExists) {
            return false;
        }
        boolean result = super.getMoreResults();
        if (result) {
            this.cacheEnable = false;
        }
        return result;
    }
}

