/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.resultset;

import com.bes.enterprise.gjc.spi.cache.CacheKey;
import com.bes.enterprise.gjc.spi.cache.impl.BesJdbcCache;
import com.bes.enterprise.gjc.spi.cache.resultset.CacheableResultSetMetaData;
import com.bes.enterprise.gjc.spi.cache.resultset.IndependentResultData;
import com.bes.enterprise.gjc.spi.cache.wrapper.ResultSetWrapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PhysicalResultSetHolder
extends ResultSetWrapper
implements ResultSet {
    private CacheKey cacheKey;
    private boolean initMetaData = false;
    private CacheableResultSetMetaData cacheableMetaData;
    protected List<List<Object>> data;
    protected List<List<Boolean>> nullData;
    private IndependentResultData cacheResultData;
    private BesJdbcCache resultSetCache;
    private boolean autoCache;

    public IndependentResultData getCacheResultData() {
        return this.cacheResultData;
    }

    public PhysicalResultSetHolder(ResultSet resultSet, CacheKey cacheKey, BesJdbcCache resultSetCache, boolean autoCache) {
        super(resultSet);
        this.cacheKey = cacheKey;
        this.data = new ArrayList<List<Object>>();
        this.nullData = new ArrayList<List<Boolean>>();
        this.resultSetCache = resultSetCache;
        this.autoCache = autoCache;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.initMetaData) {
            this.getMetaData();
        }
        boolean hasNext = super.next();
        if (this.cacheableMetaData.isCacheable()) {
            if (hasNext) {
                int colNum = this.cacheableMetaData.getColumnCount();
                ArrayList<Object> vals = new ArrayList<Object>();
                vals.add(null);
                ArrayList<Boolean> nullVals = new ArrayList<Boolean>();
                nullVals.add(null);
                for (int i = 1; i <= colNum; ++i) {
                    Object val = this.getObject(i);
                    vals.add(val);
                    Boolean nullVal = true;
                    if (val != null) {
                        nullVal = this.wasNull();
                    }
                    nullVals.add(nullVal);
                }
                this.data.add(vals);
                this.nullData.add(nullVals);
            } else {
                this.cacheResultData = new IndependentResultData(this.cacheableMetaData, this.data, this.nullData, this.getType(), this.getConcurrency());
                if (this.isAutoCache()) {
                    this.saveCache();
                }
            }
        }
        return hasNext;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (!this.initMetaData) {
            this.initMetaData = true;
            ResultSetMetaData metaData = super.getMetaData();
            this.cacheableMetaData = new CacheableResultSetMetaData(metaData);
        }
        return this.cacheableMetaData;
    }

    public void saveCache() {
        this.resultSetCache.putObject(this.cacheKey, this.cacheResultData);
    }

    public boolean isAutoCache() {
        return this.autoCache;
    }

    public void setAutoCache(boolean autoCache) {
        this.autoCache = autoCache;
    }
}

