/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.datasources;

import com.bes.enterprise.gjc.spi.datasources.InstanceKeyDataSourceFactory;
import com.bes.enterprise.gjc.spi.datasources.PooledConnectionAndInfo;
import com.bes.enterprise.gjc.spi.datasources.PooledConnectionManager;
import com.bes.enterprise.gjc.spi.datasources.UserPassKey;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class InstanceKeyDataSource
implements DataSource,
Referenceable,
Serializable,
AutoCloseable {
    private static final long serialVersionUID = -6819270431752240878L;
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static final String BAD_TRANSACTION_ISOLATION = "The requested TransactionIsolation level is invalid.";
    protected static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    private volatile boolean getConnectionCalled = false;
    private ConnectionPoolDataSource dataSource = null;
    private String dataSourceName = null;
    private String description = null;
    private Properties jndiEnvironment = null;
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    private String instanceKey = null;
    private boolean defaultBlockWhenExhausted = true;
    private String defaultEvictionPolicyClassName = "com.bes.enterprise.gjc.pool.impl.DefaultEvictionPolicy";
    private boolean defaultLifo = true;
    private int defaultMaxIdle = 8;
    private int defaultMaxTotal = -1;
    private long defaultMaxWaitMillis = -1L;
    private long defaultMaxEvictableIdleTimeMillis = 1800000L;
    private int defaultMinIdle = 0;
    private int defaultNumTestsPerEvictionRun = 3;
    private long defaultMinEvictableIdleTimeMillis = -1L;
    private boolean defaultTestOnCreate = false;
    private boolean defaultTestOnBorrow = false;
    private boolean defaultTestOnReturn = false;
    private boolean defaultTestWhileIdle = false;
    private long defaultTimeBetweenEvictionRunsMillis = -1L;
    private String validationQuery = null;
    private int validationQueryTimeout = -1;
    private boolean rollbackAfterValidation = false;
    private long maxConnLifetimeMillis = -1L;
    private Boolean defaultAutoCommit = null;
    private int defaultTransactionIsolation = -1;
    private Boolean defaultReadOnly = null;

    protected void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    @Override
    public abstract void close() throws Exception;

    protected abstract PooledConnectionManager getConnectionManager(UserPassKey var1);

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("InstanceKeyDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean getDefaultBlockWhenExhausted() {
        return this.defaultBlockWhenExhausted;
    }

    public void setDefaultBlockWhenExhausted(boolean blockWhenExhausted) {
        this.assertInitializationAllowed();
        this.defaultBlockWhenExhausted = blockWhenExhausted;
    }

    public String getDefaultEvictionPolicyClassName() {
        return this.defaultEvictionPolicyClassName;
    }

    public void setDefaultEvictionPolicyClassName(String evictionPolicyClassName) {
        this.assertInitializationAllowed();
        this.defaultEvictionPolicyClassName = evictionPolicyClassName;
    }

    public boolean getDefaultLifo() {
        return this.defaultLifo;
    }

    public void setDefaultLifo(boolean lifo) {
        this.assertInitializationAllowed();
        this.defaultLifo = lifo;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int maxIdle) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = maxIdle;
    }

    public int getDefaultMaxTotal() {
        return this.defaultMaxTotal;
    }

    public void setDefaultMaxTotal(int maxTotal) {
        this.assertInitializationAllowed();
        this.defaultMaxTotal = maxTotal;
    }

    public long getDefaultMaxWaitMillis() {
        return this.defaultMaxWaitMillis;
    }

    public void setDefaultMaxWaitMillis(long maxWaitMillis) {
        this.assertInitializationAllowed();
        this.defaultMaxWaitMillis = maxWaitMillis;
    }

    public long getDefaultMaxEvictableIdleTimeMillis() {
        return this.defaultMaxEvictableIdleTimeMillis;
    }

    public void setDefaultMaxEvictableIdleTimeMillis(long maxEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this.defaultMaxEvictableIdleTimeMillis = maxEvictableIdleTimeMillis;
    }

    public int getDefaultMinIdle() {
        return this.defaultMinIdle;
    }

    public void setDefaultMinIdle(int minIdle) {
        this.assertInitializationAllowed();
        this.defaultMinIdle = minIdle;
    }

    public int getDefaultNumTestsPerEvictionRun() {
        return this.defaultNumTestsPerEvictionRun;
    }

    public void setDefaultNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        this.defaultNumTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public long getDefaultMinEvictableIdleTimeMillis() {
        return this.defaultMinEvictableIdleTimeMillis;
    }

    public void setDefaultMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this.defaultMinEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public boolean getDefaultTestOnCreate() {
        return this.defaultTestOnCreate;
    }

    public void setDefaultTestOnCreate(boolean testOnCreate) {
        this.assertInitializationAllowed();
        this.defaultTestOnCreate = testOnCreate;
    }

    public boolean getDefaultTestOnBorrow() {
        return this.defaultTestOnBorrow;
    }

    public void setDefaultTestOnBorrow(boolean testOnBorrow) {
        this.assertInitializationAllowed();
        this.defaultTestOnBorrow = testOnBorrow;
    }

    public boolean getDefaultTestOnReturn() {
        return this.defaultTestOnReturn;
    }

    public void setDefaultTestOnReturn(boolean testOnReturn) {
        this.assertInitializationAllowed();
        this.defaultTestOnReturn = testOnReturn;
    }

    public boolean getDefaultTestWhileIdle() {
        return this.defaultTestWhileIdle;
    }

    public void setDefaultTestWhileIdle(boolean testWhileIdle) {
        this.assertInitializationAllowed();
        this.defaultTestWhileIdle = testWhileIdle;
    }

    public long getDefaultTimeBetweenEvictionRunsMillis() {
        return this.defaultTimeBetweenEvictionRunsMillis;
    }

    public void setDefaultTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        this.defaultTimeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.dataSource;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource v) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        if (this.dataSource != null) {
            throw new IllegalStateException("The CPDS has already been set. It cannot be altered.");
        }
        this.dataSource = v;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String v) {
        this.assertInitializationAllowed();
        if (this.dataSource != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.dataSourceName != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.dataSourceName = v;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean v) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = v;
    }

    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean v) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = v;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int v) {
        this.assertInitializationAllowed();
        switch (v) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_TRANSACTION_ISOLATION);
            }
        }
        this.defaultTransactionIsolation = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    protected String getInstanceKey() {
        return this.instanceKey;
    }

    public String getJndiEnvironment(String key) {
        String value = null;
        if (this.jndiEnvironment != null) {
            value = this.jndiEnvironment.getProperty(key);
        }
        return value;
    }

    public void setJndiEnvironment(String key, String value) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(key, value);
    }

    void setJndiEnvironment(Properties properties) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        } else {
            this.jndiEnvironment.clear();
        }
        this.jndiEnvironment.putAll((Map<?, ?>)properties);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int v) {
        this.loginTimeout = v;
    }

    @Override
    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        }
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter v) {
        this.logWriter = v;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.assertInitializationAllowed();
        this.validationQuery = validationQuery;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    public boolean isRollbackAfterValidation() {
        return this.rollbackAfterValidation;
    }

    public void setRollbackAfterValidation(boolean rollbackAfterValidation) {
        this.assertInitializationAllowed();
        this.rollbackAfterValidation = rollbackAfterValidation;
    }

    public long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.instanceKey == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        PooledConnectionAndInfo info = null;
        try {
            info = this.getPooledConnectionAndInfo(username, password);
        }
        catch (NoSuchElementException e) {
            this.closeDueToException(info);
            throw new SQLException("Cannot borrow connection from pool", e);
        }
        catch (RuntimeException e) {
            this.closeDueToException(info);
            throw e;
        }
        catch (SQLException e) {
            this.closeDueToException(info);
            throw e;
        }
        catch (Exception e) {
            this.closeDueToException(info);
            throw new SQLException("Cannot borrow connection from pool", e);
        }
        if (!(null != password ? password.equals(info.getPassword()) : null == info.getPassword())) {
            try {
                this.testCPDS(username, password);
            }
            catch (SQLException ex) {
                this.closeDueToException(info);
                throw new SQLException("Given password did not match password used to create the PooledConnection.", ex);
            }
            catch (NamingException ne) {
                throw new SQLException("NamingException encountered connecting to database", ne);
            }
            UserPassKey upkey = info.getUserPassKey();
            PooledConnectionManager manager = this.getConnectionManager(upkey);
            manager.invalidate(info.getPooledConnection());
            manager.setPassword(upkey.getPassword());
            info = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    info = this.getPooledConnectionAndInfo(username, password);
                }
                catch (NoSuchElementException e) {
                    this.closeDueToException(info);
                    throw new SQLException("Cannot borrow connection from pool", e);
                }
                catch (RuntimeException e) {
                    this.closeDueToException(info);
                    throw e;
                }
                catch (SQLException e) {
                    this.closeDueToException(info);
                    throw e;
                }
                catch (Exception e) {
                    this.closeDueToException(info);
                    throw new SQLException("Cannot borrow connection from pool", e);
                }
                if (info != null && password != null && password.equals(info.getPassword())) break;
                if (info != null) {
                    manager.invalidate(info.getPooledConnection());
                }
                info = null;
            }
            if (info == null) {
                throw new SQLException("Cannot borrow connection from pool - password change failure.");
            }
        }
        Connection con = info.getPooledConnection().getConnection();
        try {
            this.setupDefaults(con, username);
            con.clearWarnings();
            return con;
        }
        catch (SQLException ex) {
            try {
                con.close();
            }
            catch (Exception exc) {
                this.getLogWriter().println("ignoring exception during close: " + exc);
            }
            throw ex;
        }
    }

    protected abstract PooledConnectionAndInfo getPooledConnectionAndInfo(String var1, String var2) throws SQLException;

    protected abstract void setupDefaults(Connection var1, String var2) throws SQLException;

    private void closeDueToException(PooledConnectionAndInfo info) {
        if (info != null) {
            try {
                info.getPooledConnection().getConnection().close();
            }
            catch (Exception e) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionPoolDataSource testCPDS(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.dataSource;
        if (cpds == null) {
            InitialContext ctx = null;
            ctx = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
            Object ds = ctx.lookup(this.dataSourceName);
            if (ds instanceof ConnectionPoolDataSource) {
                cpds = (ConnectionPoolDataSource)ds;
            } else {
                throw new SQLException("Illegal configuration: DataSource " + this.dataSourceName + " (" + ds.getClass().getName() + ") doesn't implement javax.sql.ConnectionPoolDataSource");
            }
        }
        PooledConnection conn = null;
        try {
            conn = username != null ? cpds.getPooledConnection(username, password) : cpds.getPooledConnection();
            if (conn == null) {
                throw new SQLException("Cannot connect using the supplied username/password");
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return cpds;
    }
}

