/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.managed;

import com.bes.enterprise.gjc.spi.BasicDataSource;
import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.PoolableConnection;
import com.bes.enterprise.gjc.spi.PoolableConnectionFactory;
import com.bes.enterprise.gjc.spi.PoolingDataSource;
import com.bes.enterprise.gjc.spi.managed.DataSourceXAConnectionFactory;
import com.bes.enterprise.gjc.spi.managed.LocalXAConnectionFactory;
import com.bes.enterprise.gjc.spi.managed.ManagedDataSource;
import com.bes.enterprise.gjc.spi.managed.NamedDataSourceXAResourceFactory;
import com.bes.enterprise.gjc.spi.managed.PoolableManagedConnectionFactory;
import com.bes.enterprise.gjc.spi.managed.TransactionContext;
import com.bes.enterprise.gjc.spi.managed.TransactionRegistry;
import com.bes.enterprise.gjc.spi.managed.XAConnectionFactory;
import com.bes.enterprise.transaction.manager.NamedXAResourceFactory;
import com.bes.enterprise.transaction.manager.TransactionManagerImpl;
import java.sql.SQLException;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;

public class BasicManagedDataSource
extends BasicDataSource {
    private TransactionRegistry transactionRegistry;
    private transient TransactionManager transactionManager;
    private String xaDataSource;
    private XADataSource xaDataSourceInstance;

    public XADataSource getXaDataSourceInstance() {
        return this.xaDataSourceInstance;
    }

    public void setXaDataSourceInstance(XADataSource xaDataSourceInstance) {
        this.xaDataSourceInstance = xaDataSourceInstance;
        this.xaDataSource = xaDataSourceInstance == null ? null : xaDataSourceInstance.getClass().getName();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getXADataSource() {
        return this.xaDataSource;
    }

    public void setXADataSource(String xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.transactionManager == null) {
            throw new SQLException("Transaction manager must be set before a connection can be created");
        }
        if (this.xaDataSource == null) {
            ConnectionFactory connectionFactory = super.createConnectionFactory();
            LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), connectionFactory);
            this.transactionRegistry = xaConnectionFactory.getTransactionRegistry();
            return xaConnectionFactory;
        }
        if (this.xaDataSourceInstance == null) {
            Class xaDataSourceClass = null;
            try {
                xaDataSourceClass = this.loadDriverClass();
            }
            catch (Exception t) {
                String message = "Cannot load XA data source class '" + this.xaDataSource + "'";
                throw new SQLException(message, t);
            }
            try {
                this.xaDataSourceInstance = (XADataSource)xaDataSourceClass.newInstance();
            }
            catch (Exception t) {
                String message = "Cannot create XA data source of class '" + this.xaDataSource + "'";
                throw new SQLException(message, t);
            }
        }
        DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.getTransactionManager(), this.xaDataSourceInstance, this.getUsername(), this.getPassword());
        this.transactionRegistry = xaConnectionFactory.getTransactionRegistry();
        return xaConnectionFactory;
    }

    @Override
    protected PoolingDataSource createDataSourceInstance() throws SQLException {
        ManagedDataSource<PoolableConnection> pds = new ManagedDataSource<PoolableConnection>(this.getConnectionPool(), this.transactionRegistry);
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return pds;
    }

    @Override
    protected boolean hasActiveTransactionContext() throws SQLException {
        TransactionContext localTransactionContext;
        return this.transactionRegistry != null && (localTransactionContext = this.transactionRegistry.getActiveTransactionContext()) != null;
    }

    @Override
    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory) throws SQLException {
        PoolableManagedConnectionFactory connectionFactory = null;
        try {
            int fetchSize;
            connectionFactory = new PoolableManagedConnectionFactory((XAConnectionFactory)driverConnectionFactory, this.getRegisteredJmxName());
            connectionFactory.setValidationQuery(this.getValidationQuery());
            connectionFactory.setValidationQueryTimeout(this.getValidationQueryTimeout());
            connectionFactory.setConnectionInitSql(this.getConnectionInitSqls());
            connectionFactory.setDefaultReadOnly(this.getDefaultReadOnly());
            connectionFactory.setDefaultAutoCommit(this.getDefaultAutoCommit());
            connectionFactory.setDefaultTransactionIsolation(this.getDefaultTransactionIsolation());
            connectionFactory.setDefaultCatalog(this.getDefaultCatalog());
            connectionFactory.setCacheState(this.getCacheState());
            connectionFactory.setPoolStatements(this.isPoolPreparedStatements());
            connectionFactory.setMaxOpenPreparedStatements(this.getStatementCacheSize());
            connectionFactory.setMaxConnLifetimeMillis(this.getMaxConnectionAge() * 1000L);
            connectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            connectionFactory.setEnableAutoCommitOnReturn(this.getEnableAutoCommitOnReturn());
            int statementTimeoutInSeconds = this.getStatementTimeoutInSeconds();
            if (statementTimeoutInSeconds > -1) {
                connectionFactory.setDefaultQueryTimeout(statementTimeoutInSeconds);
            }
            if ((fetchSize = this.getFetchSize().intValue()) != 0) {
                connectionFactory.setDefaultFetchSize(fetchSize);
            }
            connectionFactory.setUsingTrace(this.getUsingTrace());
            connectionFactory.setMatchConnections(this.isMatchConnections());
            connectionFactory.setFailAllConnection(this.isFailAllConnection());
            connectionFactory.setWrapStatement(this.isWrapStatement());
            connectionFactory.setNetworkTimeoutExecutor(this.getNetworkTimeoutExecutor(this.dataSource, this.getDriverClassName(), this.getUrl()));
            BasicManagedDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
        return connectionFactory;
    }

    public void registerRecoveryResource() {
        if (this.transactionManager instanceof TransactionManagerImpl) {
            NamedDataSourceXAResourceFactory namedDataSourceXAResourceFactory = new NamedDataSourceXAResourceFactory(this.name, this);
            ((TransactionManagerImpl)this.transactionManager).registerNamedXAResourceFactory((NamedXAResourceFactory)namedDataSourceXAResourceFactory);
        }
    }

    public void recoveryResource() {
        if (this.transactionManager instanceof TransactionManagerImpl) {
            ((TransactionManagerImpl)this.transactionManager).recoveryNamedXAResource(this.name);
        }
    }

    public void unregisterRecoveryResource() {
        if (this.transactionManager instanceof TransactionManagerImpl) {
            ((TransactionManagerImpl)this.transactionManager).unregisterNamedXAResourceFactory(this.name);
        }
    }

    @Override
    public void close() throws SQLException {
        this.unregisterRecoveryResource();
        super.close();
    }
}

