/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.managed;

import com.bes.enterprise.gjc.spi.ConnectionResult;
import com.bes.enterprise.gjc.spi.NamedXADataSource;
import com.bes.enterprise.gjc.spi.managed.TransactionRegistry;
import com.bes.enterprise.gjc.spi.managed.XAConnectionFactory;
import com.bes.enterprise.transaction.manager.WrapperNamedXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class DataSourceXAConnectionFactory
implements XAConnectionFactory {
    private final TransactionRegistry transactionRegistry;
    private final XADataSource xaDataSource;
    private String username;
    private String password;

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource) {
        this(transactionManager, xaDataSource, null, null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource, String username, String password) {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        if (xaDataSource == null) {
            throw new NullPointerException("xaDataSource is null");
        }
        this.transactionRegistry = new TransactionRegistry(transactionManager);
        this.xaDataSource = xaDataSource;
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public ConnectionResult getConnectionResult() throws SQLException {
        XAConnection xaConnection = this.username == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(this.username, this.password);
        return this.initXAConnection(xaConnection);
    }

    @Override
    public ConnectionResult getConnectionResult(String name, String password) throws SQLException {
        XAConnection xaConnection = this.xaDataSource.getXAConnection(name, password);
        return this.initXAConnection(xaConnection);
    }

    private ConnectionResult initXAConnection(XAConnection xaConnection) throws SQLException {
        Connection connection = xaConnection.getConnection();
        XAResource xaResource = xaConnection.getXAResource();
        if (this.xaDataSource instanceof NamedXADataSource) {
            xaResource = new WrapperNamedXAResource(xaResource, ((NamedXADataSource)this.xaDataSource).getName());
        }
        this.transactionRegistry.registerConnection(connection, xaResource);
        xaConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pc = (PooledConnection)event.getSource();
                pc.removeConnectionEventListener(this);
                try {
                    pc.close();
                }
                catch (SQLException e) {
                    System.err.println("Failed to close Cpds Connection.");
                    e.printStackTrace();
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
                this.connectionClosed(event);
            }
        });
        return new ConnectionResult(xaConnection, connection);
    }
}

