/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean;

import com.bes.a4mbean.A4MBeanException;
import com.bes.a4mbean.JEEMXMBeanInterface;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;

public class JEEMXClient
implements JEEMXMBeanInterface {
    public static final ObjectName NULL_OBJECTNAME = JEEMXClient.makeObjectName("null:type=Null,name=Null");
    private MBeanServerConnection server;
    private ObjectName oname;

    private static ObjectName makeObjectName(String str) {
        try {
            return new ObjectName(str);
        }
        catch (MalformedObjectNameException ex) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JEEMXClient)) {
            return false;
        }
        JEEMXClient other = (JEEMXClient)obj;
        return this.oname.equals(other.oname);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.oname != null ? this.oname.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "JEEMXClient[" + this.oname + "]";
    }

    private <T> T fetchAttribute(String name, Class<T> type) {
        try {
            Object obj = this.server.getAttribute(this.oname, name);
            if (NULL_OBJECTNAME.equals(obj)) {
                return null;
            }
            return type.cast(obj);
        }
        catch (JMException exc) {
            throw new A4MBeanException("Exception in fetchAttribute", exc);
        }
        catch (IOException exc) {
            throw new A4MBeanException("Exception in fetchAttribute", exc);
        }
    }

    public JEEMXClient(MBeanServerConnection server, ObjectName oname) {
        this.server = server;
        this.oname = oname;
    }

    private JEEMXClient makeJEEMX(ObjectName on) {
        if (on == null) {
            return null;
        }
        return new JEEMXClient(this.server, on);
    }

    @Override
    public String getName() {
        return this.fetchAttribute("Name", String.class);
    }

    @Override
    public Map<String, ?> getMeta() {
        try {
            ModelMBeanInfo mbi = (ModelMBeanInfo)((Object)this.server.getMBeanInfo(this.oname));
            Descriptor desc = mbi.getMBeanDescriptor();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String str : desc.getFieldNames()) {
                result.put(str, desc.getFieldValue(str));
            }
            return result;
        }
        catch (MBeanException ex) {
            throw new A4MBeanException("Exception in getMeta", ex);
        }
        catch (RuntimeOperationsException ex) {
            throw new A4MBeanException("Exception in getMeta", ex);
        }
        catch (InstanceNotFoundException ex) {
            throw new A4MBeanException("Exception in getMeta", ex);
        }
        catch (IntrospectionException ex) {
            throw new A4MBeanException("Exception in getMeta", ex);
        }
        catch (ReflectionException ex) {
            throw new A4MBeanException("Exception in getMeta", ex);
        }
        catch (IOException ex) {
            throw new A4MBeanException("Exception in getMeta", ex);
        }
    }

    @Override
    public JEEMXClient getParent() {
        ObjectName res = this.fetchAttribute("Parent", ObjectName.class);
        return this.makeJEEMX(res);
    }

    public JEEMXClient[] getChildren() {
        ObjectName[] onames = this.fetchAttribute("Children", ObjectName[].class);
        return this.makeJEEMXArray(onames);
    }

    private JEEMXClient[] makeJEEMXArray(ObjectName[] onames) {
        JEEMXClient[] result = new JEEMXClient[onames.length];
        int ctr = 0;
        for (ObjectName on : onames) {
            result[ctr++] = this.makeJEEMX(on);
        }
        return result;
    }

    public Object getAttribute(String attribute) {
        try {
            return this.server.getAttribute(this.oname, attribute);
        }
        catch (MBeanException ex) {
            throw new A4MBeanException("Exception in getAttribute", ex);
        }
        catch (AttributeNotFoundException ex) {
            throw new A4MBeanException("Exception in getAttribute", ex);
        }
        catch (ReflectionException ex) {
            throw new A4MBeanException("Exception in getAttribute", ex);
        }
        catch (InstanceNotFoundException ex) {
            throw new A4MBeanException("Exception in getAttribute", ex);
        }
        catch (IOException ex) {
            throw new A4MBeanException("Exception in getAttribute", ex);
        }
    }

    public void setAttribute(String name, Object value) {
        Attribute attr = new Attribute(name, value);
        this.setAttribute(attr);
    }

    public void setAttribute(Attribute attribute) {
        try {
            this.server.setAttribute(this.oname, attribute);
        }
        catch (InstanceNotFoundException ex) {
            throw new A4MBeanException("Exception in setAttribute", ex);
        }
        catch (AttributeNotFoundException ex) {
            throw new A4MBeanException("Exception in setAttribute", ex);
        }
        catch (InvalidAttributeValueException ex) {
            throw new A4MBeanException("Exception in setAttribute", ex);
        }
        catch (MBeanException ex) {
            throw new A4MBeanException("Exception in setAttribute", ex);
        }
        catch (ReflectionException ex) {
            throw new A4MBeanException("Exception in setAttribute", ex);
        }
        catch (IOException ex) {
            throw new A4MBeanException("Exception in setAttribute", ex);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.server.getAttributes(this.oname, attributes);
        }
        catch (InstanceNotFoundException ex) {
            throw new A4MBeanException("Exception in getAttributes", ex);
        }
        catch (ReflectionException ex) {
            throw new A4MBeanException("Exception in getAttributes", ex);
        }
        catch (IOException ex) {
            throw new A4MBeanException("Exception in getAttributes", ex);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.server.setAttributes(this.oname, attributes);
        }
        catch (InstanceNotFoundException ex) {
            throw new A4MBeanException("Exception in setAttributes", ex);
        }
        catch (ReflectionException ex) {
            throw new A4MBeanException("Exception in setAttributes", ex);
        }
        catch (IOException ex) {
            throw new A4MBeanException("Exception in setAttributes", ex);
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            return this.server.invoke(this.oname, actionName, params, signature);
        }
        catch (InstanceNotFoundException ex) {
            throw new A4MBeanException("Exception in invoke", ex);
        }
        catch (IOException ex) {
            throw new A4MBeanException("Exception in invoke", ex);
        }
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return this.server.getMBeanInfo(this.oname);
        }
        catch (InstanceNotFoundException ex) {
            throw new A4MBeanException("Exception in invoke", ex);
        }
        catch (IntrospectionException ex) {
            throw new A4MBeanException("Exception in invoke", ex);
        }
        catch (ReflectionException ex) {
            throw new A4MBeanException("Exception in invoke", ex);
        }
        catch (IOException ex) {
            throw new A4MBeanException("Exception in invoke", ex);
        }
    }

    public ObjectName objectName() {
        return this.oname;
    }
}

