/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.generic;

import com.bes.a4mbean.A4MBeanException;
import com.bes.a4mbean.generic.ClassAnalyzer;
import com.bes.a4mbean.generic.FacetAccessor;
import com.bes.a4mbean.generic.MethodMonitor;
import com.bes.a4mbean.generic.MethodMonitorFactory;
import com.bes.a4mbean.generic.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FacetAccessorImpl
implements FacetAccessor {
    private Object delegate;
    private Map<Class<?>, Object> facetMap = new HashMap();
    private MethodMonitor mm;

    public FacetAccessorImpl(Object delegate) {
        this.delegate = delegate;
        this.mm = MethodMonitorFactory.makeStandard(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T facet(Class<T> cls, boolean debug) {
        Object result = null;
        if (debug) {
            this.mm.enter(debug, "facet", cls);
        }
        try {
            if (cls.isInstance(this.delegate)) {
                result = this.delegate;
                if (debug) {
                    this.mm.info(debug, "result is delegate");
                }
            } else {
                result = this.facetMap.get(cls);
                if (debug) {
                    this.mm.info(debug, "result=", result);
                }
            }
            if (result == null) {
                T t = null;
                return t;
            }
            T t = cls.cast(result);
            return t;
        }
        finally {
            if (debug) {
                this.mm.exit(debug, result);
            }
        }
    }

    @Override
    public Collection<Object> facets() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.facetMap.values());
        result.add(this);
        return result;
    }

    @Override
    public <T> void addFacet(final T obj) {
        if (obj.getClass().isInstance(this.delegate)) {
            throw new IllegalArgumentException("Cannot add facet of supertype of this object");
        }
        ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(obj.getClass());
        ca.findClasses(new Predicate<Class>(){

            @Override
            public boolean evaluate(Class arg) {
                FacetAccessorImpl.this.facetMap.put(arg, obj);
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Method method, boolean debug, Object ... args) {
        if (debug) {
            this.mm.enter(debug, "invoke", method, args);
        }
        Object result = null;
        try {
            Object target = this.facet(method.getDeclaringClass(), debug);
            if (target == null) {
                throw new IllegalArgumentException("No facet available for method " + method);
            }
            try {
                result = method.invoke(target, args);
            }
            catch (IllegalAccessException ex) {
                throw new A4MBeanException("Exception on invocation", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new A4MBeanException("Exception on invocation", ex);
            }
            catch (InvocationTargetException ex) {
                throw new A4MBeanException("Exception on invocation", ex);
            }
            if (debug) {
                this.mm.exit(debug, result);
            }
        }
        catch (Throwable throwable) {
            if (debug) {
                this.mm.exit(debug, result);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Field field, boolean debug) {
        if (debug) {
            this.mm.enter(debug, "get", field);
        }
        Object result = null;
        try {
            Object target = this.facet(field.getDeclaringClass(), debug);
            try {
                result = field.get(target);
            }
            catch (IllegalArgumentException ex) {
                throw new A4MBeanException("Exception on field get", ex);
            }
            catch (IllegalAccessException ex) {
                throw new A4MBeanException("Exception on field get", ex);
            }
            if (debug) {
                this.mm.exit(debug, result);
            }
        }
        catch (Throwable throwable) {
            if (debug) {
                this.mm.exit(debug, result);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Field field, Object value, boolean debug) {
        if (debug) {
            this.mm.enter(debug, "set", field, value);
        }
        try {
            Object target = this.facet(field.getDeclaringClass(), debug);
            try {
                field.set(target, value);
            }
            catch (IllegalArgumentException ex) {
                throw new A4MBeanException("Exception on field get", ex);
            }
            catch (IllegalAccessException ex) {
                throw new A4MBeanException("Exception on field get", ex);
            }
        }
        finally {
            if (debug) {
                this.mm.exit(debug);
            }
        }
    }

    @Override
    public void removeFacet(Class<?> cls) {
        if (cls.isInstance(this.delegate)) {
            throw new IllegalArgumentException("Cannot add facet of supertype of this object");
        }
        ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(cls);
        ca.findClasses(new Predicate<Class>(){

            @Override
            public boolean evaluate(Class arg) {
                FacetAccessorImpl.this.facetMap.remove(arg);
                return false;
            }
        });
    }
}

