/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.generic;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.List;

public final class MarkStack<E> {
    private List<E> items = new ArrayList();
    private List<Integer> marks = new ArrayList<Integer>();

    public E push(E elem) {
        this.items.add(elem);
        return elem;
    }

    public E pop() {
        int topMark;
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        if (this.marks.size() > 0 && (topMark = this.marks.get(this.marks.size() - 1).intValue()) == this.items.size()) {
            throw new IllegalStateException("Cannot pop item past top mark");
        }
        E result = this.items.remove(this.items.size() - 1);
        return result;
    }

    public boolean isEmpty() {
        if (this.marks.size() > 0) {
            int topMark = this.marks.get(this.marks.size() - 1);
            return topMark == this.items.size();
        }
        return this.items.size() == 0;
    }

    public E peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.items.get(this.items.size() - 1);
    }

    public void mark() {
        this.marks.add(this.items.size());
    }

    public List<E> popMark() {
        LinkedList<E> result = new LinkedList<E>();
        int topMark = this.marks.remove(this.marks.size() - 1);
        while (this.items.size() > topMark) {
            result.addFirst(this.items.remove(this.items.size() - 1));
        }
        return result;
    }
}

