/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.generic;

import com.bes.a4mbean.generic.DumpIgnore;
import com.bes.a4mbean.generic.DumpToString;
import com.bes.a4mbean.generic.ObjectWriter;
import com.bes.a4mbean.generic.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public final class ObjectUtility {
    private ObjectPrinter generalObjectPrinter = new ObjectPrinter(){

        @Override
        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            ObjectUtility.this.handleObject(printed, buff, obj);
        }

        @Override
        public boolean alwaysPrint() {
            return false;
        }
    };
    private ObjectPrinter arrayPrinter = new ObjectPrinter(){

        @Override
        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            ObjectUtility.this.handleArray(printed, buff, obj);
        }

        @Override
        public boolean alwaysPrint() {
            return false;
        }
    };
    private static ObjectPrinter propertiesPrinter = new ObjectPrinter(){

        @Override
        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            if (!(obj instanceof Properties)) {
                throw new Error();
            }
            Properties props = (Properties)obj;
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                buff.startElement();
                buff.append(key);
                buff.append("=");
                buff.append(value);
                buff.endElement();
            }
        }

        @Override
        public boolean alwaysPrint() {
            return true;
        }
    };
    private ObjectPrinter collectionPrinter = new ObjectPrinter(){

        @Override
        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            if (!(obj instanceof Collection)) {
                throw new Error();
            }
            Collection coll = (Collection)obj;
            for (Object element : coll) {
                buff.startElement();
                ObjectUtility.this.objectToStringHelper(printed, buff, element);
                buff.endElement();
            }
        }

        @Override
        public boolean alwaysPrint() {
            return false;
        }
    };
    private ObjectPrinter mapPrinter = new ObjectPrinter(){

        @Override
        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            if (!(obj instanceof Map)) {
                throw new Error();
            }
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                buff.startElement();
                ObjectUtility.this.objectToStringHelper(printed, buff, entry.getKey());
                buff.append("=>");
                ObjectUtility.this.objectToStringHelper(printed, buff, entry.getValue());
                buff.endElement();
            }
        }

        @Override
        public boolean alwaysPrint() {
            return false;
        }
    };
    private static ObjectPrinter toStringPrinter = new ObjectPrinter(){

        @Override
        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            buff.append(obj.toString());
        }

        @Override
        public boolean alwaysPrint() {
            return true;
        }
    };
    private final Object[][] CLASS_MAP_DATA = new Object[][]{{Integer.class, toStringPrinter}, {BigInteger.class, toStringPrinter}, {BigDecimal.class, toStringPrinter}, {String.class, toStringPrinter}, {StringBuffer.class, toStringPrinter}, {StringBuilder.class, toStringPrinter}, {Long.class, toStringPrinter}, {Short.class, toStringPrinter}, {Byte.class, toStringPrinter}, {Character.class, toStringPrinter}, {Float.class, toStringPrinter}, {Double.class, toStringPrinter}, {Boolean.class, toStringPrinter}, {Date.class, toStringPrinter}, {ObjectName.class, toStringPrinter}, {CompositeData.class, toStringPrinter}, {CompositeType.class, toStringPrinter}, {TabularData.class, toStringPrinter}, {TabularType.class, toStringPrinter}, {ArrayType.class, toStringPrinter}, {Class.class, toStringPrinter}, {Method.class, toStringPrinter}, {Thread.class, toStringPrinter}, {AtomicInteger.class, toStringPrinter}, {AtomicLong.class, toStringPrinter}, {AtomicBoolean.class, toStringPrinter}, {Properties.class, propertiesPrinter}, {Collection.class, this.collectionPrinter}, {Map.class, this.mapPrinter}};
    private ClassMap classMap;
    private boolean isIndenting;
    private int initialLevel;
    private int increment;
    private static ObjectUtility standard = new ObjectUtility(true, 0, 4);
    private static ObjectUtility compact = new ObjectUtility(false, 0, 4);

    public ObjectUtility(boolean isIndenting, int initialLevel, int increment) {
        this.isIndenting = isIndenting;
        this.initialLevel = initialLevel;
        this.increment = increment;
        this.classMap = new ClassMap();
        for (Object[] pair : this.CLASS_MAP_DATA) {
            Class key = (Class)pair[0];
            ObjectPrinter value = (ObjectPrinter)pair[1];
            this.classMap.put(key, value);
        }
    }

    public ObjectUtility useToString(Class cls) {
        this.classMap.put(cls, toStringPrinter);
        return this;
    }

    public static String defaultObjectToString(Object object) {
        return standard.objectToString(object);
    }

    public static String compactObjectToString(Object object) {
        return compact.objectToString(object);
    }

    public String objectToString(Object obj) {
        IdentityHashMap printed = new IdentityHashMap();
        ObjectWriter result = ObjectWriter.make(this.isIndenting, this.initialLevel, this.increment);
        this.objectToStringHelper(printed, result, obj);
        return result.toString();
    }

    ObjectPrinter classify(Class cls) {
        if (cls.isEnum()) {
            return toStringPrinter;
        }
        if (cls.isArray()) {
            return this.arrayPrinter;
        }
        ObjectPrinter result = this.classMap.get(cls);
        if (result == null) {
            return this.generalObjectPrinter;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void objectToStringHelper(IdentityHashMap printed, ObjectWriter result, Object obj) {
        if (obj == null) {
            result.append("null");
            result.endElement();
        } else {
            Class<?> cls = obj.getClass();
            ObjectPrinter opr = this.classify(cls);
            result.startObject(obj);
            try {
                if (opr.alwaysPrint()) {
                    opr.print(printed, result, obj);
                } else if (printed.keySet().contains(obj)) {
                    result.append("*VISITED*");
                } else {
                    printed.put(obj, null);
                    opr.print(printed, result, obj);
                }
            }
            finally {
                result.endObject();
            }
        }
    }

    private void checkPackageAccess(Class cls) {
        String cname;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (cname = cls.getName().replace('/', '.')).startsWith("[")) {
            int lastDot;
            int lastBracket = cname.lastIndexOf("[") + 2;
            if (lastBracket > 1 && lastBracket < cname.length()) {
                cname = cname.substring(lastBracket);
            }
            if ((lastDot = cname.lastIndexOf(46)) != -1) {
                String pname = cname.substring(0, lastDot);
                sm.checkPackageAccess(pname);
            }
        }
    }

    private Field[] getDeclaredFields(Class cls) {
        this.checkPackageAccess(cls);
        return cls.getDeclaredFields();
    }

    private void handleObject(IdentityHashMap printed, ObjectWriter result, Object obj) {
        Class<?> cls = obj.getClass();
        try {
            SecurityManager security = System.getSecurityManager();
            ArrayList<Field> allFields = new ArrayList<Field>();
            Class<?> current = cls;
            while (!current.equals(Object.class)) {
                Field[] fields = security != null && !Modifier.isPublic(current.getModifiers()) ? new Field[]{} : this.getDeclaredFields(current);
                for (Field fld : fields) {
                    allFields.add(fld);
                }
                current = current.getSuperclass();
            }
            for (final Field fld : allFields) {
                int modifiers = fld.getModifiers();
                if (fld.isAnnotationPresent(DumpIgnore.class) || Modifier.isStatic(modifiers) || security != null && !Modifier.isPublic(modifiers)) continue;
                result.startElement();
                result.append(fld.getName());
                result.append("=");
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        fld.setAccessible(true);
                        return null;
                    }
                });
                Object value = fld.get(obj);
                if (fld.isAnnotationPresent(DumpToString.class)) {
                    toStringPrinter.print(printed, result, value);
                } else {
                    this.objectToStringHelper(printed, result, value);
                }
                result.endElement();
            }
        }
        catch (IllegalArgumentException ex) {
            result.append(obj.toString());
        }
        catch (IllegalAccessException ex) {
            result.append(obj.toString());
        }
    }

    private void handleArray(IdentityHashMap printed, ObjectWriter result, Object obj) {
        Class<?> compClass = obj.getClass().getComponentType();
        if (compClass == Boolean.TYPE) {
            boolean[] arr = (boolean[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Byte.TYPE) {
            byte[] arr = (byte[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Short.TYPE) {
            short[] arr = (short[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Integer.TYPE) {
            int[] arr = (int[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Long.TYPE) {
            long[] arr = (long[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Character.TYPE) {
            char[] arr = (char[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Float.TYPE) {
            float[] arr = (float[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Double.TYPE) {
            double[] arr = (double[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else {
            Object[] arr = (Object[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                this.objectToStringHelper(printed, result, arr[ctr]);
                result.endElement();
            }
        }
    }

    private static class ClassMap {
        List<Pair<Class<?>, ObjectPrinter>> data = new ArrayList();

        public ObjectPrinter get(Class cls) {
            for (Pair<Class<?>, ObjectPrinter> pair : this.data) {
                if (!pair.first().isAssignableFrom(cls)) continue;
                return pair.second();
            }
            return null;
        }

        public void put(Class cls, ObjectPrinter obj) {
            Pair<Class, ObjectPrinter> pair = new Pair<Class, ObjectPrinter>(cls, obj);
            this.data.add(pair);
        }
    }

    static interface ObjectPrinter {
        public void print(IdentityHashMap var1, ObjectWriter var2, Object var3);

        public boolean alwaysPrint();
    }
}

