/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.generic;

import com.bes.a4mbean.generic.Algorithms;
import com.bes.a4mbean.generic.Pair;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public class OperationTracer {
    private static boolean enabled = true;
    private static ThreadLocal<List<Pair<String, Object[]>>> state = new ThreadLocal(){

        public List<Pair<String, Object[]>> initialValue() {
            return new ArrayList<Pair<String, Object[]>>();
        }
    };

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    private OperationTracer() {
    }

    private static String format(Pair<String, Object[]> arg) {
        String name = arg.first();
        Object[] args = arg.second();
        StringBuilder sb = new StringBuilder();
        if (name == null) {
            sb.append("!NULL_NAME!");
        } else {
            sb.append(name);
        }
        sb.append('(');
        boolean first = true;
        for (Object obj : args) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(Algorithms.convertToString(obj));
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getAsString() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        List<Pair<String, Object[]>> elements = state.get();
        int ctr = 0;
        for (Pair<String, Object[]> elem : elements) {
            fmt.format("\n\t(%3d): %s", ctr++, OperationTracer.format(elem));
        }
        return sb.toString();
    }

    public static void clear() {
        if (enabled) {
            state.get().clear();
        }
    }

    public static void enter(String name, Object ... args) {
        if (enabled) {
            state.get().add(new Pair<String, Object[]>(name, args));
        }
    }

    public static void exit() {
        List<Pair<String, Object[]>> elements;
        int size;
        if (enabled && (size = (elements = state.get()).size()) > 0) {
            elements.remove(size - 1);
        }
    }
}

