/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.impl;

import com.bes.a4mbean.impl.Exceptions;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.modelmbean.DescriptorSupport;

public class DescriptorUtility {
    public static final Descriptor EMPTY_DESCRIPTOR = DescriptorUtility.makeDescriptor(new HashMap());

    private DescriptorUtility() {
    }

    public static Descriptor makeDescriptor(Map<String, ?> fields) {
        if (fields == null) {
            throw Exceptions.self.nullMap();
        }
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String name = entry.getKey();
            if (name == null || name.equals("")) {
                throw Exceptions.self.badFieldName();
            }
            if (map.containsKey(name)) {
                throw Exceptions.self.duplicateFieldName(name);
            }
            map.put(name, entry.getValue());
        }
        int size = map.size();
        String[] names = map.keySet().toArray(new String[size]);
        Object[] values = map.values().toArray(new Object[size]);
        return new DescriptorSupport(names, values);
    }

    public static Descriptor union(Descriptor ... descriptors) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Descriptor d : descriptors) {
            String[] names;
            if (d == null) continue;
            for (String n : names = d.getFieldNames()) {
                Object v = d.getFieldValue(n);
                map.put(n, v);
            }
        }
        return DescriptorUtility.makeDescriptor(map);
    }
}

