/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.impl;

import com.bes.a4mbean.JEEMXClient;
import com.bes.a4mbean.JEEMXMBeanInterface;
import com.bes.a4mbean.generic.Algorithms;
import com.bes.a4mbean.generic.UnaryFunction;
import com.bes.a4mbean.impl.Exceptions;
import com.bes.a4mbean.impl.MBeanImpl;
import com.bes.a4mbean.impl.ManagedObjectManagerInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfoSupport;

public class JEEMXImpl
implements JEEMXMBeanInterface {
    private MBeanImpl mbean;
    private static UnaryFunction<MBeanImpl, JEEMXMBeanInterface> extract = new UnaryFunction<MBeanImpl, JEEMXMBeanInterface>(){

        @Override
        public JEEMXMBeanInterface evaluate(MBeanImpl mb) {
            return mb.facet(JEEMXMBeanInterface.class, false);
        }
    };

    public JEEMXImpl(MBeanImpl mb) {
        this.mbean = mb;
    }

    @Override
    public String getName() {
        return this.mbean.name();
    }

    @Override
    public Map<String, ?> getMeta() {
        Descriptor desc;
        MBeanInfo mbi = this.mbean.getMBeanInfo();
        ModelMBeanInfoSupport mmbi = (ModelMBeanInfoSupport)mbi;
        try {
            desc = mmbi.getMBeanDescriptor();
        }
        catch (MBeanException ex) {
            throw Exceptions.self.excForGetMeta(ex);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : desc.getFieldNames()) {
            result.put(key, desc.getFieldValue(key));
        }
        return result;
    }

    @Override
    public JEEMXMBeanInterface getParent() {
        MBeanImpl parent = this.mbean.parent();
        if (parent != null) {
            return parent.facet(JEEMXMBeanInterface.class, false);
        }
        ManagedObjectManagerInternal mom = this.mbean.skeleton().mom();
        ObjectName rpn = mom.getRootParentName();
        if (rpn == null) {
            return null;
        }
        return new JEEMXClient(mom.getMBeanServer(), rpn);
    }

    @Override
    public JEEMXMBeanInterface[] getChildren() {
        List<JEEMXMBeanInterface> children = this.getContained(this.mbean.children().keySet());
        return children.toArray(new JEEMXMBeanInterface[children.size()]);
    }

    private List<JEEMXMBeanInterface> getContained(Set<String> types) {
        ArrayList<JEEMXMBeanInterface> result = new ArrayList<JEEMXMBeanInterface>();
        for (String str : types) {
            result.addAll(Arrays.asList(this.getContained(str)));
        }
        return result;
    }

    private JEEMXMBeanInterface[] getContained(String type) {
        Collection<JEEMXMBeanInterface> children = Algorithms.map(this.mbean.children().get(type), extract).values();
        return children.toArray(new JEEMXMBeanInterface[children.size()]);
    }
}

