/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.impl;

import com.bes.a4mbean.JEEMXMetadata;
import com.bes.a4mbean.ManagedOperation;
import com.bes.a4mbean.NameValue;
import com.bes.a4mbean.ParameterNames;
import com.bes.a4mbean.generic.BinaryFunction;
import com.bes.a4mbean.generic.DumpIgnore;
import com.bes.a4mbean.generic.DumpToString;
import com.bes.a4mbean.generic.FacetAccessor;
import com.bes.a4mbean.generic.MethodMonitor;
import com.bes.a4mbean.generic.MethodMonitorFactory;
import com.bes.a4mbean.generic.Pair;
import com.bes.a4mbean.impl.AttributeDescriptor;
import com.bes.a4mbean.impl.DescriptorIntrospector;
import com.bes.a4mbean.impl.DescriptorUtility;
import com.bes.a4mbean.impl.Exceptions;
import com.bes.a4mbean.impl.ManagedObjectManagerImpl;
import com.bes.a4mbean.impl.ManagedObjectManagerInternal;
import com.bes.a4mbean.impl.TypeConverter;
import com.bes.a4mbean.typelib.EvaluatedClassAnalyzer;
import com.bes.a4mbean.typelib.EvaluatedClassDeclaration;
import com.bes.a4mbean.typelib.EvaluatedFieldDeclaration;
import com.bes.a4mbean.typelib.EvaluatedMethodDeclaration;
import com.bes.a4mbean.typelib.EvaluatedType;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;

public class MBeanSkeleton {
    private static Descriptor DEFAULT_JEEMX_DESCRIPTOR = DescriptorIntrospector.descriptorForElement(null, ManagedObjectManagerImpl.DefaultJEEMXMetadataHolder.class);
    private JEEMXMetadata mbeanType;
    private final String type;
    private Descriptor descriptor;
    @DumpToString
    private final AtomicLong sequenceNumber;
    @DumpToString
    private final ManagedObjectManagerInternal mom;
    @DumpIgnore
    private final MethodMonitor mm;
    private final Map<String, AttributeDescriptor> setters;
    private final Map<String, AttributeDescriptor> getters;
    private AttributeDescriptor nameAttributeDescriptor;
    private final Map<String, Map<List<String>, Operation>> operations;
    private final List<ModelMBeanAttributeInfo> mbeanAttributeInfoList;
    private final List<ModelMBeanOperationInfo> mbeanOperationInfoList;
    private final ModelMBeanInfoSupport mbInfo;
    private static final Permission accessControlPermission = new ReflectPermission("suppressAccessChecks");

    private <K, L, V> void addToCompoundMap(Map<K, Map<L, V>> source, Map<K, Map<L, V>> dest) {
        for (Map.Entry<K, Map<L, V>> entry : source.entrySet()) {
            Map<L, V> dmap = dest.get(entry.getKey());
            if (dmap == null) {
                dmap = new HashMap<L, V>();
                dest.put(entry.getKey(), dmap);
            }
            dmap.putAll(entry.getValue());
        }
    }

    public MBeanSkeleton(EvaluatedClassDeclaration annotatedClass, EvaluatedClassAnalyzer ca, ManagedObjectManagerInternal mom) {
        boolean isDefaultJEEMXMetadata = false;
        this.mbeanType = mom.getFirstAnnotationOnClass(annotatedClass, JEEMXMetadata.class);
        if (this.mbeanType == null) {
            isDefaultJEEMXMetadata = true;
            this.mbeanType = mom.getDefaultJEEMXMetadata();
        }
        this.type = mom.getTypeName(annotatedClass.cls(), "JEEMX_TYPE", this.mbeanType.type());
        Descriptor ldesc = DescriptorIntrospector.descriptorForElement(mom, annotatedClass.cls());
        if (isDefaultJEEMXMetadata) {
            ldesc = DescriptorUtility.union(DEFAULT_JEEMX_DESCRIPTOR, ldesc);
        }
        this.descriptor = this.makeValidDescriptor(ldesc, DescriptorType.mbean, this.type);
        this.sequenceNumber = new AtomicLong();
        this.mom = mom;
        this.mm = MethodMonitorFactory.makeStandard(this.getClass());
        this.setters = new HashMap<String, AttributeDescriptor>();
        this.getters = new HashMap<String, AttributeDescriptor>();
        this.operations = new HashMap<String, Map<List<String>, Operation>>();
        this.mbeanAttributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
        this.mbeanOperationInfoList = new ArrayList<ModelMBeanOperationInfo>();
        this.analyzeAttributes(ca);
        this.analyzeOperations(ca);
        this.analyzeObjectNameKeys(ca);
        this.mbInfo = this.makeMbInfo(mom.getDescription(annotatedClass));
    }

    private MBeanSkeleton(MBeanSkeleton first, MBeanSkeleton second) {
        this.mbeanType = second.mbeanType;
        this.type = second.type;
        this.descriptor = DescriptorUtility.union(first.descriptor, second.descriptor);
        this.sequenceNumber = new AtomicLong();
        this.mom = second.mom;
        this.mm = MethodMonitorFactory.makeStandard(this.getClass());
        this.setters = new HashMap<String, AttributeDescriptor>();
        this.setters.putAll(first.setters);
        this.setters.putAll(second.setters);
        this.getters = new HashMap<String, AttributeDescriptor>();
        this.getters.putAll(first.getters);
        this.getters.putAll(second.getters);
        this.nameAttributeDescriptor = second.nameAttributeDescriptor;
        this.operations = new HashMap<String, Map<List<String>, Operation>>();
        this.addToCompoundMap(first.operations, this.operations);
        this.addToCompoundMap(second.operations, this.operations);
        this.mbeanAttributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
        this.mbeanAttributeInfoList.addAll(first.mbeanAttributeInfoList);
        this.mbeanAttributeInfoList.addAll(second.mbeanAttributeInfoList);
        this.mbeanOperationInfoList = new ArrayList<ModelMBeanOperationInfo>();
        this.mbeanOperationInfoList.addAll(first.mbeanOperationInfoList);
        this.mbeanOperationInfoList.addAll(second.mbeanOperationInfoList);
        this.mbInfo = this.makeMbInfo(second.mbInfo.getDescription());
    }

    private ModelMBeanInfoSupport makeMbInfo(String description) {
        ModelMBeanAttributeInfo[] attrInfos = this.mbeanAttributeInfoList.toArray(new ModelMBeanAttributeInfo[this.mbeanAttributeInfoList.size()]);
        ModelMBeanOperationInfo[] operInfos = this.mbeanOperationInfoList.toArray(new ModelMBeanOperationInfo[this.mbeanOperationInfoList.size()]);
        return new ModelMBeanInfoSupport(this.type, description, attrInfos, null, operInfos, null, this.descriptor);
    }

    public MBeanSkeleton compose(MBeanSkeleton skel) {
        return new MBeanSkeleton(this, skel);
    }

    Descriptor makeValidDescriptor(Descriptor desc, DescriptorType dtype, String dname) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] names = desc.getFieldNames();
        Object[] values = desc.getFieldValues(null);
        for (int ctr = 0; ctr < names.length; ++ctr) {
            map.put(names[ctr], values[ctr]);
        }
        map.put("descriptorType", dtype.toString());
        if (dtype == DescriptorType.operation) {
            map.put("role", "operation");
            map.put("targetType", "ObjectReference");
        } else if (dtype == DescriptorType.mbean) {
            map.put("persistPolicy", "never");
            map.put("log", "F");
            map.put("visibility", "1");
        }
        map.put("name", dname);
        map.put("displayName", dname);
        return DescriptorUtility.makeDescriptor(map);
    }

    public String toString() {
        return "DynamicMBeanSkeleton[type" + this.type + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttribute(AttributeDescriptor getter, AttributeDescriptor setter) {
        this.mm.enter(this.mom.registrationFineDebug(), "processAttribute", getter, setter);
        try {
            if (setter == null && getter == null) {
                throw Exceptions.self.notBothNull();
            }
            if (setter != null && getter != null && !setter.type().equals(getter.type())) {
                throw Exceptions.self.typesMustMatch();
            }
            AttributeDescriptor nonNullDescriptor = getter != null ? getter : setter;
            String name = nonNullDescriptor.id();
            String description = nonNullDescriptor.description();
            Descriptor desc = DescriptorUtility.EMPTY_DESCRIPTOR;
            if (getter != null) {
                desc = DescriptorUtility.union(desc, DescriptorIntrospector.descriptorForElement(this.mom, getter.accessible()));
            }
            if (setter != null) {
                desc = DescriptorUtility.union(desc, DescriptorIntrospector.descriptorForElement(this.mom, setter.accessible()));
            }
            desc = this.makeValidDescriptor(desc, DescriptorType.attribute, name);
            this.mm.info(this.mom.registrationFineDebug(), name, description, desc);
            TypeConverter tc = this.mom.getTypeConverter(nonNullDescriptor.type());
            ModelMBeanAttributeInfo ainfo = new ModelMBeanAttributeInfo(name, tc.getManagedType().getClassName(), description, getter != null, setter != null, false, desc);
            this.mm.info(this.mom.registrationFineDebug(), ainfo);
            this.mbeanAttributeInfoList.add(ainfo);
        }
        finally {
            this.mm.exit(this.mom.registrationFineDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeAttributes(EvaluatedClassAnalyzer ca) {
        this.mm.enter(this.mom.registrationFineDebug(), "analyzeAttributes", ca);
        try {
            Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> amap = this.mom.getAttributes(ca, ManagedObjectManagerInternal.AttributeDescriptorType.MBEAN_ATTR);
            this.getters.putAll(amap.first());
            this.setters.putAll(amap.second());
            this.mm.info(this.mom.registrationFineDebug(), "attributes", amap);
            HashSet<String> setterNames = new HashSet<String>(this.setters.keySet());
            this.mm.info(this.mom.registrationFineDebug(), "(Before removing getters):setterNames=", setterNames);
            for (String str : this.getters.keySet()) {
                this.processAttribute(this.getters.get(str), this.setters.get(str));
                setterNames.remove(str);
            }
            this.mm.info(this.mom.registrationFineDebug(), "(After removing getters):setterNames=", setterNames);
            for (String str : setterNames) {
                this.processAttribute(null, this.setters.get(str));
            }
        }
        finally {
            this.mm.exit(this.mom.registrationFineDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeObjectNameKeys(EvaluatedClassAnalyzer ca) {
        this.mm.enter(this.mom.registrationFineDebug(), "analyzeObjectNameKeys", ca);
        try {
            List<EvaluatedFieldDeclaration> annotatedFields = ca.findFields(this.mom.forAnnotation(NameValue.class, EvaluatedFieldDeclaration.class));
            List<EvaluatedMethodDeclaration> annotatedMethods = ca.findMethods(this.mom.forAnnotation(NameValue.class, EvaluatedMethodDeclaration.class));
            if (annotatedMethods.size() == 0 && annotatedFields.size() == 0) {
                return;
            }
            EvaluatedMethodDeclaration annotatedMethod = annotatedMethods.get(0);
            if (annotatedMethods.size() > 1) {
                EvaluatedMethodDeclaration second = annotatedMethods.get(1);
                if (annotatedMethod.containingClass().equals(second.containingClass())) {
                    throw Exceptions.self.duplicateObjectNameKeyAttributes(annotatedMethod, second, annotatedMethod.containingClass().name());
                }
            }
            this.mm.info(this.mom.registrationFineDebug(), "annotatedMethod", annotatedMethod);
            this.nameAttributeDescriptor = AttributeDescriptor.makeFromAnnotated(this.mom, annotatedMethod, "NameValue", Exceptions.self.nameOfManagedObject(), ManagedObjectManagerInternal.AttributeDescriptorType.MBEAN_ATTR);
        }
        finally {
            this.mm.exit(this.mom.registrationFineDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Operation, ModelMBeanOperationInfo> makeOperation(final EvaluatedMethodDeclaration m) {
        this.mm.enter(this.mom.registrationFineDebug(), "makeOperation", m);
        AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                m.method().setAccessible(true);
                return m.method();
            }
        });
        try {
            String desc = this.mom.getDescription(m);
            EvaluatedType rtype = m.returnType();
            final TypeConverter rtc = rtype == null ? null : this.mom.getTypeConverter(rtype);
            List<EvaluatedType> atypes = m.parameterTypes();
            final ArrayList<TypeConverter> atcs = new ArrayList<TypeConverter>();
            ManagedOperation mo = this.mom.getAnnotation(m.element(), ManagedOperation.class);
            Descriptor modelDescriptor = this.makeValidDescriptor(DescriptorIntrospector.descriptorForElement(this.mom, m.element()), DescriptorType.operation, m.name());
            for (EvaluatedType ltype : atypes) {
                atcs.add(this.mom.getTypeConverter(ltype));
            }
            if (this.mom.registrationFineDebug()) {
                this.mm.info(true, "desc", desc);
                this.mm.info(true, "rtype", rtype);
                this.mm.info(true, "rtc", rtc);
                this.mm.info(true, "atcs", atcs);
                this.mm.info(true, "atypes", atypes);
                this.mm.info(true, "descriptor", modelDescriptor);
            }
            Operation oper = new Operation(){

                @Override
                public Object evaluate(FacetAccessor target, List<Object> args) {
                    MBeanSkeleton.this.mm.enter(MBeanSkeleton.this.mom.runtimeDebug(), "Operation:evaluate", target, args);
                    Object[] margs = new Object[args.size()];
                    Iterator<Object> argsIterator = args.iterator();
                    Iterator tcIterator = atcs.iterator();
                    int ctr = 0;
                    while (argsIterator.hasNext() && tcIterator.hasNext()) {
                        Object arg = argsIterator.next();
                        TypeConverter tc = (TypeConverter)tcIterator.next();
                        margs[ctr++] = tc.fromManagedEntity(arg);
                    }
                    MBeanSkeleton.this.mm.info(MBeanSkeleton.this.mom.runtimeDebug(), "Before invoke: margs=", margs);
                    Object result = target.invoke(m.method(), MBeanSkeleton.this.mom.runtimeDebug(), margs);
                    MBeanSkeleton.this.mm.info(MBeanSkeleton.this.mom.runtimeDebug(), "After invoke: result=", result);
                    if (rtc == null) {
                        return null;
                    }
                    return rtc.toManagedEntity(result);
                }
            };
            ParameterNames pna = this.mom.getAnnotation(m.element(), ParameterNames.class);
            this.mm.info(this.mom.registrationFineDebug(), "pna", pna);
            if (pna != null && pna.value().length != atcs.size()) {
                throw Exceptions.self.parameterNamesLengthBad();
            }
            MBeanParameterInfo[] paramInfo = new OpenMBeanParameterInfoSupport[atcs.size()];
            int ctr = 0;
            for (TypeConverter tc : atcs) {
                String name = "";
                try {
                    name = pna == null ? "arg" + ctr : pna.value()[ctr];
                    paramInfo[ctr] = new OpenMBeanParameterInfoSupport(name, Exceptions.self.noDescriptionAvailable(), tc.getManagedType());
                    ++ctr;
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.self.excInOpenParameterInfo(ex, name, m);
                }
            }
            ModelMBeanOperationInfo operInfo = new ModelMBeanOperationInfo(m.name(), desc, paramInfo, rtc.getManagedType().getClassName(), mo.impact().ordinal(), modelDescriptor);
            this.mm.info(this.mom.registrationFineDebug(), "operInfo", operInfo);
            Pair<Operation, ModelMBeanOperationInfo> pair = new Pair<Operation, ModelMBeanOperationInfo>(oper, operInfo);
            return pair;
        }
        finally {
            this.mm.exit(this.mom.registrationFineDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeOperations(EvaluatedClassAnalyzer ca) {
        this.mm.enter(this.mom.registrationFineDebug(), "analyzeOperations", ca);
        try {
            List<EvaluatedMethodDeclaration> ops = ca.findMethods(this.mom.forAnnotation(ManagedOperation.class, EvaluatedMethodDeclaration.class));
            for (EvaluatedMethodDeclaration m : ops) {
                Pair<Operation, ModelMBeanOperationInfo> data = this.makeOperation(m);
                ModelMBeanOperationInfo info = data.second();
                ArrayList<String> dataTypes = new ArrayList<String>();
                for (MBeanParameterInfo pi : info.getSignature()) {
                    dataTypes.add(pi.getType());
                }
                Map<List<String>, Operation> map = this.operations.get(m.name());
                if (map == null) {
                    map = new HashMap<List<String>, Operation>();
                    this.operations.put(m.name(), map);
                }
                this.mom.putIfNotPresent(map, dataTypes, data.first());
                this.mbeanOperationInfoList.add(info);
            }
        }
        finally {
            this.mm.exit(this.mom.registrationFineDebug());
        }
    }

    public String getType() {
        return this.type;
    }

    public JEEMXMetadata getMBeanType() {
        return this.mbeanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(FacetAccessor fa, String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        this.mm.enter(this.mom.runtimeDebug(), "getAttribute", fa, name);
        Object result = null;
        try {
            AttributeDescriptor getter = this.getters.get(name);
            if (getter == null) {
                throw Exceptions.self.couldNotFindAttribute(name);
            }
            result = getter.get(fa, this.mom.runtimeDebug());
            this.mm.exit(this.mom.runtimeDebug(), result);
        }
        catch (Throwable throwable) {
            this.mm.exit(this.mom.runtimeDebug(), result);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(NotificationBroadcasterSupport emitter, FacetAccessor fa, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mm.enter(this.mom.runtimeDebug(), "setAttribute", emitter, fa, attribute);
        try {
            String name = attribute.getName();
            Object value = attribute.getValue();
            AttributeDescriptor getter = this.getters.get(name);
            Object oldValue = getter == null ? null : getter.get(fa, this.mom.runtimeDebug());
            this.mm.info(this.mom.runtimeDebug(), "oldValue", oldValue);
            AttributeDescriptor setter = this.setters.get(name);
            if (setter == null) {
                throw Exceptions.self.couldNotFindWritableAttribute(name);
            }
            setter.set(fa, value, this.mom.runtimeDebug());
            AttributeChangeNotification notification = new AttributeChangeNotification(emitter, this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), "Changed attribute " + name, name, setter.tc().getManagedType().getClassName(), oldValue, value);
            this.mm.info(this.mom.runtimeDebug(), "sending notification ", notification);
            emitter.sendNotification(notification);
        }
        finally {
            this.mm.exit(this.mom.runtimeDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(FacetAccessor fa, String[] attributes) {
        this.mm.enter(this.mom.runtimeDebug(), "getAttributes", new Object[]{attributes});
        try {
            AttributeList result = new AttributeList();
            for (String str : attributes) {
                Object value = null;
                try {
                    value = this.getAttribute(fa, str);
                }
                catch (JMException ex) {
                    Exceptions.self.attributeGettingError(ex, str);
                }
                if (value == null) continue;
                Attribute attr = new Attribute(str, value);
                result.add(attr);
            }
            AttributeList attributeList = result;
            return attributeList;
        }
        finally {
            this.mm.exit(this.mom.runtimeDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(NotificationBroadcasterSupport emitter, FacetAccessor fa, AttributeList attributes) {
        this.mm.enter(this.mom.runtimeDebug(), "setAttributes", emitter, fa, attributes);
        AttributeList result = new AttributeList();
        try {
            for (Object elem : attributes) {
                Attribute attr = (Attribute)elem;
                try {
                    this.setAttribute(emitter, fa, attr);
                    result.add(attr);
                }
                catch (JMException ex) {
                    Exceptions.self.attributeSettingError(ex, attr.getName());
                }
            }
            AttributeList attributeList = result;
            return attributeList;
        }
        finally {
            this.mm.exit(this.mom.runtimeDebug(), result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(FacetAccessor fa, String actionName, Object[] params, String[] sig) throws MBeanException, ReflectionException {
        List<String> signature = Arrays.asList(sig);
        List<Object> parameters = Arrays.asList(params);
        Object result = null;
        this.mm.enter(this.mom.runtimeDebug(), "invoke", fa, actionName, parameters, signature);
        try {
            Map<List<String>, Operation> opMap = this.operations.get(actionName);
            if (opMap == null) {
                throw Exceptions.self.couldNotFindOperation(actionName);
            }
            Operation op = opMap.get(signature);
            if (op == null) {
                throw Exceptions.self.couldNotFindOperationAndSignature(actionName, signature);
            }
            result = op.evaluate(fa, parameters);
        }
        finally {
            this.mm.exit(this.mom.runtimeDebug(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNameValue(FacetAccessor fa) throws MBeanException, ReflectionException {
        this.mm.enter(this.mom.runtimeDebug(), "getNameValue", fa);
        String value = null;
        try {
            if (this.nameAttributeDescriptor == null) {
                this.mm.info(this.mom.runtimeDebug(), "nameAttributeDescriptor is null");
            } else {
                value = this.nameAttributeDescriptor.get(fa, this.mom.runtimeDebug()).toString();
            }
            this.mm.exit(this.mom.runtimeDebug(), value);
        }
        catch (Throwable throwable) {
            this.mm.exit(this.mom.runtimeDebug(), value);
            throw throwable;
        }
        return value;
    }

    public ModelMBeanInfoSupport getMBeanInfo() {
        return this.mbInfo;
    }

    public ManagedObjectManagerInternal mom() {
        return this.mom;
    }

    private static enum DescriptorType {
        mbean,
        attribute,
        operation;

    }

    public static interface Operation
    extends BinaryFunction<FacetAccessor, List<Object>, Object> {
    }
}

