/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.impl;

import com.bes.a4mbean.A4MBean;
import com.bes.a4mbean.Description;
import com.bes.a4mbean.IncludeSubclass;
import com.bes.a4mbean.InheritedAttribute;
import com.bes.a4mbean.InheritedAttributes;
import com.bes.a4mbean.JEEMXClient;
import com.bes.a4mbean.JEEMXMBeanInterface;
import com.bes.a4mbean.JEEMXMetadata;
import com.bes.a4mbean.ManagedAttribute;
import com.bes.a4mbean.ManagedData;
import com.bes.a4mbean.ManagedObject;
import com.bes.a4mbean.ManagedObjectManager;
import com.bes.a4mbean.generic.Algorithms;
import com.bes.a4mbean.generic.ClassAnalyzer;
import com.bes.a4mbean.generic.DelayedObjectToString;
import com.bes.a4mbean.generic.DumpIgnore;
import com.bes.a4mbean.generic.FacetAccessor;
import com.bes.a4mbean.generic.FacetAccessorImpl;
import com.bes.a4mbean.generic.MethodMonitor;
import com.bes.a4mbean.generic.MethodMonitorFactory;
import com.bes.a4mbean.generic.ObjectUtility;
import com.bes.a4mbean.generic.Pair;
import com.bes.a4mbean.generic.Predicate;
import com.bes.a4mbean.generic.UnaryFunction;
import com.bes.a4mbean.impl.AttributeDescriptor;
import com.bes.a4mbean.impl.Exceptions;
import com.bes.a4mbean.impl.MBeanImpl;
import com.bes.a4mbean.impl.MBeanSkeleton;
import com.bes.a4mbean.impl.MBeanTree;
import com.bes.a4mbean.impl.ManagedObjectManagerInternal;
import com.bes.a4mbean.impl.TypeConverter;
import com.bes.a4mbean.impl.TypeConverterImpl;
import com.bes.a4mbean.typelib.EvaluatedClassAnalyzer;
import com.bes.a4mbean.typelib.EvaluatedClassDeclaration;
import com.bes.a4mbean.typelib.EvaluatedDeclaration;
import com.bes.a4mbean.typelib.EvaluatedFieldDeclaration;
import com.bes.a4mbean.typelib.EvaluatedMethodDeclaration;
import com.bes.a4mbean.typelib.EvaluatedType;
import com.bes.a4mbean.typelib.TypeEvaluator;
import com.bes.external.statistics.AverageRangeStatistic;
import com.bes.external.statistics.BoundaryStatistic;
import com.bes.external.statistics.BoundedRangeStatistic;
import com.bes.external.statistics.CountStatistic;
import com.bes.external.statistics.RangeStatistic;
import com.bes.external.statistics.Statistic;
import com.bes.external.statistics.StringStatistic;
import com.bes.external.statistics.TimeStatistic;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagedObjectManagerImpl
implements ManagedObjectManagerInternal {
    private static final JEEMXMetadata DEFAULT_JEEMX_METADATA = DefaultJEEMXMetadataHolder.class.getAnnotation(JEEMXMetadata.class);
    private static ObjectUtility myObjectUtil = new ObjectUtility(true, 0, 4).useToString(EvaluatedType.class).useToString(ManagedObjectManager.class);
    private static Comparator<String> REV_COMP = new StringComparator();
    @DumpIgnore
    private final MethodMonitor mm;
    private final String domain;
    private final MBeanTree tree;
    private final Map<EvaluatedClassDeclaration, MBeanSkeleton> skeletonMap;
    private final Map<EvaluatedType, TypeConverter> typeConverterMap;
    private final Map<AnnotatedElement, Map<Class, Annotation>> addedAnnotations;
    private final MBeanSkeleton jeemxSkeleton;
    private final Set<String> jeemxAttributeNames;
    private boolean rootCreated;
    private ResourceBundle resourceBundle;
    private MBeanServer server;
    private ManagedObjectManager.RegistrationDebugLevel regDebugLevel;
    private boolean runDebugFlag;
    private boolean jmxRegistrationDebugFlag;
    private final SortedSet<String> typePrefixes = new TreeSet<String>(REV_COMP);
    private boolean stripPackagePrefix = false;
    List<Pair<Class, Class>> statsData = Algorithms.list(Algorithms.pair(DummyStringStatistic.class, StringStatistic.class), Algorithms.pair(DummyTimeStatistic.class, TimeStatistic.class), Algorithms.pair(DummyStatistic.class, Statistic.class), Algorithms.pair(DummyBoundaryStatistic.class, BoundaryStatistic.class), Algorithms.pair(DummyBoundedRangeStatistic.class, BoundedRangeStatistic.class), Algorithms.pair(DummyCountStatistic.class, CountStatistic.class), Algorithms.pair(DummyRangeStatistic.class, RangeStatistic.class), Algorithms.pair(DummyAverageRangeStatistic.class, AverageRangeStatistic.class));
    private Map<AnnotatedElement, Map<Class, Annotation>> annotationCache = new WeakHashMap<AnnotatedElement, Map<Class, Annotation>>();

    private ManagedObjectManagerImpl(String domain, ObjectName rootParentName) {
        this.mm = MethodMonitorFactory.makeStandard(this.getClass());
        this.domain = domain;
        this.tree = new MBeanTree(this, domain, rootParentName, "type");
        this.skeletonMap = new WeakHashMap<EvaluatedClassDeclaration, MBeanSkeleton>();
        this.typeConverterMap = new WeakHashMap<EvaluatedType, TypeConverter>();
        this.addedAnnotations = new HashMap<AnnotatedElement, Map<Class, Annotation>>();
        EvaluatedClassDeclaration ecd = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(JEEMXMBeanInterface.class);
        this.jeemxAttributeNames = new HashSet<String>();
        this.jeemxSkeleton = this.getSkeleton(ecd);
        for (MBeanAttributeInfo mbi : this.jeemxSkeleton.getMBeanInfo().getAttributes()) {
            this.jeemxAttributeNames.add(mbi.getName());
        }
    }

    private void addAnnotationIfNotNull(AnnotatedElement elemement, Annotation annotation) {
        if (annotation != null) {
            this.addAnnotation(elemement, annotation);
        }
    }

    private void initializeStatisticsSupport() {
        for (Pair<Class, Class> pair : this.statsData) {
            Class dummy = pair.first();
            Class real = pair.second();
            this.addAnnotationIfNotNull(real, dummy.getAnnotation(ManagedData.class));
            this.addAnnotationIfNotNull(real, dummy.getAnnotation(Description.class));
            this.addAnnotationIfNotNull(real, dummy.getAnnotation(InheritedAttributes.class));
        }
    }

    private void init() {
        this.server = AccessController.doPrivileged(new PrivilegedAction<MBeanServer>(){

            @Override
            public MBeanServer run() {
                return ManagementFactory.getPlatformMBeanServer();
            }
        });
        this.rootCreated = false;
        this.resourceBundle = null;
        this.regDebugLevel = ManagedObjectManager.RegistrationDebugLevel.NONE;
        this.runDebugFlag = false;
        this.jmxRegistrationDebugFlag = false;
        this.tree.clear();
        this.skeletonMap.clear();
        this.typeConverterMap.clear();
        this.addedAnnotations.clear();
        this.mm.clear();
        this.initializeStatisticsSupport();
    }

    public ManagedObjectManagerImpl(String domain) {
        this(domain, null);
        this.init();
    }

    public ManagedObjectManagerImpl(ObjectName rootParentName) {
        this(rootParentName.getDomain(), rootParentName);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.mm.enter(this.registrationDebug(), "close", new Object[0]);
        try {
            this.init();
        }
        finally {
            this.mm.exit(this.registrationDebug());
        }
    }

    private synchronized void checkRootNotCreated(String methodName) {
        if (this.rootCreated) {
            throw Exceptions.self.createRootCalled(methodName);
        }
    }

    private synchronized void checkRootCreated(String methodName) {
        if (!this.rootCreated) {
            throw Exceptions.self.createRootNotCalled(methodName);
        }
    }

    @Override
    public synchronized void suspendJMXRegistration() {
        this.mm.clear();
        this.tree.suspendRegistration();
    }

    @Override
    public synchronized void resumeJMXRegistration() {
        this.mm.clear();
        this.tree.resumeRegistration();
    }

    @Override
    public synchronized void stripPackagePrefix() {
        this.mm.clear();
        this.checkRootNotCreated("stripPackagePrefix");
        this.stripPackagePrefix = true;
    }

    public String toString() {
        return "ManagedObjectManagerImpl[domain=" + this.domain + "]";
    }

    @Override
    public synchronized ObjectName getRootParentName() {
        this.checkRootCreated("getRootParentName");
        return this.tree.getRootParentName();
    }

    @Override
    public synchronized A4MBean createRoot() {
        return this.createRoot(new Root());
    }

    @Override
    public synchronized A4MBean createRoot(Object root) {
        return this.createRoot(root, null);
    }

    @Override
    public synchronized A4MBean createRoot(Object root, String name) {
        A4MBean result;
        this.mm.clear();
        this.checkRootNotCreated("createRoot");
        try {
            this.rootCreated = true;
            result = this.tree.setRoot(root, name);
            if (result == null) {
                this.rootCreated = false;
            }
        }
        catch (RuntimeException exc) {
            this.rootCreated = false;
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized Object getRoot() {
        this.mm.clear();
        return this.tree.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MBeanSkeleton getSkeleton(EvaluatedClassDeclaration cls) {
        this.mm.enter(this.registrationDebug(), "getSkeleton", cls);
        try {
            boolean newSkeleton;
            MBeanSkeleton result = this.skeletonMap.get(cls);
            boolean bl = newSkeleton = result == null;
            if (newSkeleton) {
                this.mm.info(this.registrationDebug(), "Skeleton not found");
                Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> pair = this.getClassAnalyzer(cls, ManagedObject.class);
                EvaluatedClassAnalyzer ca = pair.second();
                EvaluatedClassDeclaration annotatedClass = pair.first();
                this.mm.info(this.registrationFineDebug(), "Annotated class for skeleton is", annotatedClass);
                if (annotatedClass == null) {
                    throw Exceptions.self.managedObjectAnnotationNotFound(cls.name());
                }
                MBeanSkeleton skel = new MBeanSkeleton(cls, ca, this);
                result = this.jeemxSkeleton == null ? skel : this.jeemxSkeleton.compose(skel);
                this.skeletonMap.put(cls, result);
            }
            this.mm.info(this.registrationFineDebug() || this.registrationDebug() && newSkeleton, "Skeleton", new DelayedObjectToString(result, myObjectUtil));
            MBeanSkeleton mBeanSkeleton = result;
            return mBeanSkeleton;
        }
        finally {
            this.mm.exit(this.registrationDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TypeConverter getTypeConverter(EvaluatedType type) {
        this.mm.enter(this.registrationFineDebug(), "getTypeConverter", type);
        TypeConverter result = null;
        try {
            boolean newTypeConverter = false;
            result = this.typeConverterMap.get(type);
            if (result == null) {
                this.mm.info(this.registrationFineDebug(), "Creating new TypeConverter");
                this.typeConverterMap.put(type, new TypeConverterImpl.TypeConverterPlaceHolderImpl(type));
                result = TypeConverterImpl.makeTypeConverter(type, this);
                this.typeConverterMap.put(type, result);
                newTypeConverter = true;
            }
            this.mm.info(this.registrationFineDebug() || this.registrationDebug() && newTypeConverter, "result", myObjectUtil.objectToString(result));
        }
        finally {
            this.mm.exit(this.registrationFineDebug(), result);
        }
        return result;
    }

    private static Field getDeclaredField(final Class<?> cls, final String name) throws PrivilegedActionException, NoSuchFieldException {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return cls.getDeclaredField(name);
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

            @Override
            public Field run() throws Exception {
                return cls.getDeclaredField(name);
            }
        });
    }

    private String getJEEMXTypeFromField(Class<?> cls, String fieldName) {
        try {
            final Field fld = ManagedObjectManagerImpl.getDeclaredField(cls, fieldName);
            if (Modifier.isFinal(fld.getModifiers()) && Modifier.isStatic(fld.getModifiers()) && fld.getType().equals(String.class)) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        fld.setAccessible(true);
                        return null;
                    }
                });
                return (String)fld.get(null);
            }
            return "";
        }
        catch (PrivilegedActionException ex) {
            return "";
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
        catch (IllegalAccessException ex) {
            return "";
        }
        catch (NoSuchFieldException ex) {
            return "";
        }
        catch (SecurityException ex) {
            return "";
        }
    }

    private boolean goodResult(String str) {
        return str != null && str.length() > 0;
    }

    @Override
    public synchronized String getTypeName(Class<?> cls, String fieldName, String nameFromAnnotation) {
        String result = this.getJEEMXTypeFromField(cls, fieldName);
        if (this.goodResult(result)) {
            return result;
        }
        if (this.goodResult(nameFromAnnotation)) {
            return nameFromAnnotation;
        }
        String className = cls.getName();
        for (String str : this.typePrefixes) {
            if (!className.startsWith(str)) continue;
            return className.substring(str.length() + 1);
        }
        if (this.stripPackagePrefix) {
            int lastDot = className.lastIndexOf(46);
            if (lastDot == -1) {
                return className;
            }
            return className.substring(lastDot + 1);
        }
        return className;
    }

    @Override
    public synchronized boolean isManagedObject(Object obj) {
        EvaluatedClassDeclaration cdecl = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(obj.getClass());
        ManagedObject mo = this.getFirstAnnotationOnClass(cdecl, ManagedObject.class);
        return mo != null;
    }

    @Override
    public synchronized MBeanImpl constructMBean(MBeanImpl parentEntity, Object obj, String name) {
        MBeanImpl result = null;
        this.mm.enter(this.registrationDebug(), "constructMean", obj, name);
        String objName = name;
        try {
            Class<?> cls = obj.getClass();
            EvaluatedClassDeclaration cdecl = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(cls);
            MBeanSkeleton skel = this.getSkeleton(cdecl);
            JEEMXMetadata amd = this.getFirstAnnotationOnClass(cdecl, JEEMXMetadata.class);
            if (amd == null) {
                amd = this.getDefaultJEEMXMetadata();
            }
            String type = skel.getType();
            this.mm.info(this.registrationDebug(), "Stripped type", type);
            result = new MBeanImpl(skel, obj, this.server, type);
            if (objName == null && (objName = skel.getNameValue(result)) == null) {
                objName = "";
            }
            if (objName.length() == 0) {
                if (!amd.isSingleton()) {
                    throw Exceptions.self.nonSingletonRequiresName(parentEntity, type);
                }
            } else if (amd.isSingleton()) {
                throw Exceptions.self.singletonCannotSpecifyName(parentEntity, type, name);
            }
            this.mm.info(this.registrationDebug(), "Name value =", objName);
            result.name(objName);
            this.mm.exit(this.registrationDebug(), result);
        }
        catch (JMException exc) {
            try {
                throw Exceptions.self.errorInConstructingMBean(objName, exc);
            }
            catch (Throwable throwable) {
                this.mm.exit(this.registrationDebug(), result);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public synchronized A4MBean register(Object parent, Object obj, String name) {
        this.mm.clear();
        this.checkRootCreated("register");
        this.mm.enter(this.registrationDebug(), "register", parent, obj, name);
        if (obj instanceof String) {
            throw Exceptions.self.objStringWrongRegisterCall((String)obj);
        }
        try {
            MBeanImpl parentEntity = this.tree.getParentEntity(parent);
            MBeanImpl mb = this.constructMBean(parentEntity, obj, name);
            A4MBean a4MBean = this.tree.register(parentEntity, obj, mb);
            return a4MBean;
        }
        catch (JMException exc) {
            throw Exceptions.self.exceptionInRegister(exc);
        }
        finally {
            this.mm.exit(this.registrationDebug());
        }
    }

    @Override
    public synchronized A4MBean register(Object parent, Object obj) {
        return this.register(parent, obj, null);
    }

    @Override
    public synchronized A4MBean registerAtRoot(Object obj, String name) {
        return this.register(this.tree.getRoot(), obj, name);
    }

    @Override
    public synchronized A4MBean registerAtRoot(Object obj) {
        return this.register(this.tree.getRoot(), obj, null);
    }

    @Override
    public synchronized void unregister(Object obj) {
        this.mm.clear();
        this.checkRootCreated("unregister");
        this.mm.enter(this.registrationDebug(), "unregister", obj);
        try {
            this.tree.unregister(obj);
        }
        catch (JMException exc) {
            throw Exceptions.self.exceptionInUnregister(exc);
        }
        finally {
            this.mm.exit(this.registrationDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ObjectName getObjectName(Object obj) {
        this.mm.clear();
        this.checkRootCreated("getObjectName");
        this.mm.enter(this.registrationDebug(), "getObjectName", obj);
        if (obj instanceof ObjectName) {
            return (ObjectName)obj;
        }
        if (obj instanceof JEEMXClient) {
            return ((JEEMXClient)obj).objectName();
        }
        ObjectName result = null;
        try {
            result = this.tree.getObjectName(obj);
        }
        finally {
            this.mm.exit(this.registrationDebug(), result);
        }
        return result;
    }

    @Override
    public JEEMXClient getJEEMXClient(Object obj) {
        ObjectName oname = this.getObjectName(obj);
        if (oname == null) {
            return null;
        }
        return new JEEMXClient(this.server, oname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getObject(ObjectName oname) {
        this.checkRootCreated("getObject");
        this.mm.enter(this.registrationDebug(), "getObject", oname);
        Object result = null;
        try {
            result = this.tree.getObject(oname);
        }
        finally {
            this.mm.exit(this.registrationDebug(), result);
        }
        return result;
    }

    @Override
    public synchronized FacetAccessor getFacetAccessor(Object obj) {
        MBeanImpl mb = this.tree.getMBeanImpl(obj);
        if (mb != null) {
            return this.tree.getFacetAccessor(obj);
        }
        return new FacetAccessorImpl(obj);
    }

    @Override
    public synchronized String getDomain() {
        return this.domain;
    }

    @Override
    public synchronized void setMBeanServer(MBeanServer server) {
        this.mm.clear();
        this.checkRootNotCreated("setMBeanServer");
        this.server = server;
    }

    @Override
    public synchronized MBeanServer getMBeanServer() {
        return this.server;
    }

    @Override
    public synchronized void setResourceBundle(ResourceBundle rb) {
        this.mm.clear();
        this.checkRootNotCreated("setResourceBundle");
        this.resourceBundle = rb;
    }

    @Override
    public synchronized ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public synchronized String getDescription(EvaluatedDeclaration element) {
        Description desc;
        if (element instanceof EvaluatedClassDeclaration) {
            EvaluatedClassDeclaration ecd = (EvaluatedClassDeclaration)element;
            desc = this.getFirstAnnotationOnClass(ecd, Description.class);
        } else {
            desc = this.getAnnotation(element.element(), Description.class);
        }
        String result = "";
        if (desc != null) {
            result = desc.value();
        }
        if (result.length() == 0) {
            result = Exceptions.self.noDescriptionAvailable();
        } else if (this.resourceBundle != null) {
            result = this.resourceBundle.getString(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addAnnotation(AnnotatedElement element, Annotation annotation) {
        this.mm.clear();
        this.checkRootNotCreated("addAnnotation");
        this.mm.enter(this.registrationDebug(), "addAnnotation", element, annotation);
        if (annotation == null) {
            throw Exceptions.self.cannotAddNullAnnotation(element);
        }
        try {
            Class<? extends Annotation> annotationType;
            Annotation ann;
            Map<Class, Annotation> map = this.addedAnnotations.get(element);
            if (map == null) {
                this.mm.info(this.registrationDebug(), "Creating new Map<Class,Annotation>");
                map = new HashMap<Class, Annotation>();
                this.addedAnnotations.put(element, map);
            }
            if ((ann = map.get(annotationType = annotation.annotationType())) != null) {
                this.mm.info(this.registrationDebug(), "Duplicate annotation");
                throw Exceptions.self.duplicateAnnotation(element, annotation.getClass().getName());
            }
            map.put(annotationType, annotation);
        }
        finally {
            this.mm.exit(this.registrationDebug());
        }
    }

    @Override
    public <T extends Annotation> T getFirstAnnotationOnClass(EvaluatedClassDeclaration element, Class<T> type) {
        EvaluatedClassAnalyzer eca = new EvaluatedClassAnalyzer(element);
        List<EvaluatedClassDeclaration> ecds = eca.findClasses(this.forAnnotation(type, EvaluatedClassDeclaration.class));
        if (ecds.size() > 0) {
            return this.getAnnotation(ecds.get(0).element(), type);
        }
        return null;
    }

    private Map<Class, Annotation> getAllAnnotations(Class cls) {
        Map<Class, Annotation> result = this.annotationCache.get(cls);
        if (result == null) {
            final HashMap<Class, Annotation> res = new HashMap<Class, Annotation>();
            ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(cls);
            ca.findClasses(new Predicate<Class>(){

                @Override
                public boolean evaluate(Class arg) {
                    Annotation[] annots;
                    for (Annotation anno : annots = arg.getDeclaredAnnotations()) {
                        ManagedObjectManagerImpl.this.putIfNotPresent(res, anno.annotationType(), anno);
                    }
                    Map emap = (Map)ManagedObjectManagerImpl.this.addedAnnotations.get(arg);
                    if (emap != null) {
                        for (Map.Entry entry : emap.entrySet()) {
                            ManagedObjectManagerImpl.this.putIfNotPresent(res, entry.getKey(), entry.getValue());
                        }
                    }
                    return true;
                }
            });
            this.annotationCache.put(cls, res);
            result = res;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> type) {
        this.mm.enter(this.registrationFineDebug(), "getAnnotation", element, type.getName());
        try {
            if (element instanceof Class) {
                Class cls = (Class)element;
                Map<Class, Annotation> annos = this.getAllAnnotations(cls);
                Annotation annotation = annos.get(type);
                return (T)annotation;
            }
            Object result = element.getAnnotation(type);
            if (result == null) {
                this.mm.info(this.registrationFineDebug(), "No annotation on element: trying addedAnnotations map");
                Map<Class, Annotation> map = this.addedAnnotations.get(element);
                if (map != null) {
                    result = map.get(type);
                }
            }
            this.mm.info(this.registrationFineDebug(), "result" + result);
            T t = result;
            return t;
        }
        finally {
            this.mm.exit(this.registrationFineDebug());
        }
    }

    @Override
    public synchronized Collection<Annotation> getAnnotations(AnnotatedElement elem) {
        this.mm.enter(this.registrationFineDebug(), "getAnnotations", elem);
        try {
            if (elem instanceof Class) {
                Class cls = (Class)elem;
                Collection<Annotation> collection = this.getAllAnnotations(cls).values();
                return collection;
            }
            if (elem instanceof Method) {
                List<Annotation> list = Arrays.asList(elem.getAnnotations());
                return list;
            }
            if (elem instanceof Field) {
                List<Annotation> list = Arrays.asList(elem.getAnnotations());
                return list;
            }
            throw Exceptions.self.annotationsNotSupported(elem);
        }
        finally {
            this.mm.exit(this.registrationFineDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> getClassAnalyzer(final EvaluatedClassDeclaration cls, final Class<? extends Annotation> annotationClass) {
        this.mm.enter(this.registrationDebug(), "getClassAnalyzer", cls, annotationClass);
        try {
            EvaluatedClassAnalyzer clsca = new EvaluatedClassAnalyzer(cls);
            EvaluatedClassDeclaration annotatedClass = Algorithms.getFirst(clsca.findClasses(this.forAnnotation(annotationClass, EvaluatedClassDeclaration.class)), new Runnable(){

                @Override
                public void run() {
                    throw Exceptions.self.noAnnotationFound(annotationClass.getName(), cls.name());
                }
            });
            this.mm.info(this.registrationDebug(), "annotatedClass = " + annotatedClass);
            ArrayList<EvaluatedClassDeclaration> classes = new ArrayList<EvaluatedClassDeclaration>();
            classes.add(cls);
            IncludeSubclass incsub = this.getFirstAnnotationOnClass(cls, IncludeSubclass.class);
            if (incsub != null) {
                for (Class klass : incsub.value()) {
                    EvaluatedClassDeclaration ecd = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(klass);
                    classes.add(ecd);
                    this.mm.info(this.registrationDebug(), "included subclass", klass);
                }
            }
            EvaluatedClassAnalyzer ca = new EvaluatedClassAnalyzer(classes);
            Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> pair = new Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer>(annotatedClass, ca);
            return pair;
        }
        finally {
            this.mm.exit(this.registrationDebug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<InheritedAttribute> getInheritedAttributes(EvaluatedClassAnalyzer ca) {
        this.mm.enter(this.registrationDebug(), "getInheritedAttributes", ca);
        try {
            List<InheritedAttribute> isList;
            Predicate<EvaluatedClassDeclaration> pred = Algorithms.or(this.forAnnotation(InheritedAttribute.class, EvaluatedClassDeclaration.class), this.forAnnotation(InheritedAttributes.class, EvaluatedClassDeclaration.class));
            List<EvaluatedClassDeclaration> iaClasses = ca.findClasses(pred);
            List<InheritedAttribute> list = isList = Algorithms.flatten(iaClasses, new UnaryFunction<EvaluatedClassDeclaration, List<InheritedAttribute>>(){

                @Override
                public List<InheritedAttribute> evaluate(EvaluatedClassDeclaration cls) {
                    InheritedAttribute ia = ManagedObjectManagerImpl.this.getFirstAnnotationOnClass(cls, InheritedAttribute.class);
                    InheritedAttributes ias = ManagedObjectManagerImpl.this.getFirstAnnotationOnClass(cls, InheritedAttributes.class);
                    if (ia != null && ias != null) {
                        throw Exceptions.self.badInheritedAttributeAnnotation(cls);
                    }
                    ArrayList<InheritedAttribute> result = new ArrayList<InheritedAttribute>();
                    if (ia != null) {
                        result.add(ia);
                    } else if (ias != null) {
                        result.addAll(Arrays.asList(ias.value()));
                    }
                    return result;
                }
            });
            return list;
        }
        finally {
            this.mm.exit(this.registrationDebug());
        }
    }

    private AttributeDescriptor getAttributeDescriptorIfInherited(EvaluatedMethodDeclaration method, List<InheritedAttribute> ias, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        ADHolder adh = new ADHolder(method, adt);
        Algorithms.find(ias, adh);
        return adh.content();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <K, V> void putIfNotPresent(Map<K, V> map, K key, V value) {
        this.mm.enter(this.registrationFineDebug(), "putIfNotPresent", key, value);
        try {
            if (!map.containsKey(key)) {
                this.mm.info(this.registrationFineDebug(), "Adding key, value to map");
                map.put(key, value);
            } else {
                this.mm.info(this.registrationFineDebug(), "Key,value already in map");
            }
        }
        finally {
            this.mm.exit(this.registrationFineDebug());
        }
    }

    static void checkFieldType(EvaluatedFieldDeclaration field) {
        if (!Modifier.isFinal(field.modifiers()) || !field.fieldType().isImmutable()) {
            Exceptions.self.illegalAttributeField(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> getAttributes(EvaluatedClassAnalyzer ca, final ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        final HashMap getters = new HashMap();
        final HashMap setters = new HashMap();
        Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> result = new Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>>(getters, setters);
        final List<InheritedAttribute> ias = this.getInheritedAttributes(ca);
        ca.findFields(new Predicate<EvaluatedFieldDeclaration>(){

            @Override
            public boolean evaluate(EvaluatedFieldDeclaration field) {
                ManagedAttribute ma = ManagedObjectManagerImpl.this.getAnnotation(field.element(), ManagedAttribute.class);
                if (ma == null) {
                    return false;
                }
                ManagedObjectManagerImpl.checkFieldType(field);
                Description desc = ManagedObjectManagerImpl.this.getAnnotation(field.element(), Description.class);
                String description = desc == null ? "No description available for " + field.name() : desc.value();
                AttributeDescriptor ad = AttributeDescriptor.makeFromAnnotated(ManagedObjectManagerImpl.this, field, ma.id(), description, adt);
                ManagedObjectManagerImpl.this.putIfNotPresent(getters, ad.id(), ad);
                return true;
            }
        });
        ca.findMethods(new Predicate<EvaluatedMethodDeclaration>(){

            @Override
            public boolean evaluate(EvaluatedMethodDeclaration method) {
                AttributeDescriptor ad;
                ManagedAttribute ma = ManagedObjectManagerImpl.this.getAnnotation(method.element(), ManagedAttribute.class);
                if (ma == null) {
                    ad = ManagedObjectManagerImpl.this.getAttributeDescriptorIfInherited(method, ias, adt);
                } else {
                    Description desc = ManagedObjectManagerImpl.this.getAnnotation(method.element(), Description.class);
                    String description = desc == null ? "No description available for " + method.name() : desc.value();
                    ad = AttributeDescriptor.makeFromAnnotated(ManagedObjectManagerImpl.this, method, ma.id(), description, adt);
                }
                if (ad != null) {
                    if (ad.atype() == AttributeDescriptor.AttributeType.GETTER) {
                        ManagedObjectManagerImpl.this.putIfNotPresent(getters, ad.id(), ad);
                    } else {
                        ManagedObjectManagerImpl.this.putIfNotPresent(setters, ad.id(), ad);
                    }
                }
                return false;
            }
        });
        Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> pair = result;
        return pair;
    }

    @Override
    public synchronized void setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel level) {
        this.regDebugLevel = level;
    }

    @Override
    public synchronized void setJMXRegistrationDebug(boolean flag) {
        this.jmxRegistrationDebugFlag = flag;
    }

    @Override
    public synchronized void setRuntimeDebug(boolean flag) {
        this.runDebugFlag = flag;
    }

    @Override
    public synchronized void setTypelibDebug(int level) {
        TypeEvaluator.setDebugLevel(level);
    }

    @Override
    public synchronized String dumpSkeleton(Object obj) {
        MBeanImpl impl = this.tree.getMBeanImpl(obj);
        if (impl == null) {
            return obj + " is not currently registered with mom " + this;
        }
        MBeanSkeleton skel = impl.skeleton();
        String skelString = myObjectUtil.objectToString(skel);
        return "Skeleton for MBean for object " + obj + ":\n" + skelString;
    }

    @Override
    public synchronized boolean registrationDebug() {
        return this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.NORMAL || this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.FINE;
    }

    @Override
    public synchronized boolean registrationFineDebug() {
        return this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.FINE;
    }

    @Override
    public synchronized boolean runtimeDebug() {
        return this.runDebugFlag;
    }

    @Override
    public synchronized boolean jmxRegistrationDebug() {
        return this.jmxRegistrationDebugFlag;
    }

    @Override
    public synchronized void stripPrefix(String ... args) {
        this.checkRootNotCreated("stripPrefix");
        for (String str : args) {
            this.typePrefixes.add(str);
        }
    }

    @Override
    public synchronized <T extends EvaluatedDeclaration> Predicate<T> forAnnotation(final Class<? extends Annotation> annotation, Class<T> cls) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T elem) {
                return ManagedObjectManagerImpl.this.getAnnotation(elem.element(), annotation) != null;
            }
        };
    }

    @Override
    public JEEMXMetadata getDefaultJEEMXMetadata() {
        return DEFAULT_JEEMX_METADATA;
    }

    @Override
    public boolean isJEEMXAttributeName(String name) {
        return this.jeemxAttributeNames.contains(name);
    }

    @Override
    public void suppressDuplicateRootReport(boolean suppressReport) {
        this.checkRootNotCreated("suppressDuplicateRootReport");
        this.tree.setSuppressDuplicateSetRootReport(suppressReport);
    }

    private class ADHolder
    implements Predicate<InheritedAttribute> {
        private final EvaluatedMethodDeclaration method;
        private final ManagedObjectManagerInternal.AttributeDescriptorType adt;
        private AttributeDescriptor content;

        public ADHolder(EvaluatedMethodDeclaration method, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
            this.method = method;
            this.adt = adt;
        }

        @Override
        public boolean evaluate(InheritedAttribute ia) {
            boolean result;
            AttributeDescriptor ad = AttributeDescriptor.makeFromInherited(ManagedObjectManagerImpl.this, this.method, ia.id(), ia.methodName(), ia.description(), this.adt);
            boolean bl = result = ad != null;
            if (result) {
                this.content = ad;
            }
            return result;
        }

        public AttributeDescriptor content() {
            return this.content;
        }
    }

    @ManagedObject
    @JEEMXMetadata(type="a4mbean-root", isSingleton=true)
    @Description(value="Dummy class used when no root is specified")
    private static class Root {
        private Root() {
        }

        public String toString() {
            return "A4mbeanDefaultRoot";
        }
    }

    @ManagedData
    @Description(value="Custom statistic type whose value is a string")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getCurrent", description="Returns the String value of the statistic")})
    public static interface DummyStringStatistic
    extends DummyStatistic {
    }

    @ManagedData
    @Description(value="Provides standard measurements of a range that has fixed limits")
    public static interface DummyBoundedRangeStatistic
    extends DummyBoundaryStatistic,
    DummyRangeStatistic {
    }

    @ManagedData
    @Description(value="Adds an average to the range statistic")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getAverage", description="The average value of this attribute since its last reset")})
    public static interface DummyAverageRangeStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard measurements of the lowest and highest values an attribute has held as well as its current value")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getHighWaterMark", description="The highest value this attribute has held since the beginninYg of the measurement"), @InheritedAttribute(methodName="getLowWaterMark", description="The lowest value this attribute has held since the beginninYg of the measurement"), @InheritedAttribute(methodName="getCurrent", description="The current value of this attribute")})
    public static interface DummyRangeStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard count measurements")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getCount", description="The count since the last reset")})
    public static interface DummyCountStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard measurements of the upper and lower limits of the value of an attribute")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getUpperBound", description="The upper limit of the value of this attribute"), @InheritedAttribute(methodName="getLowerBound", description="The lower limit of the value of this attribute")})
    public static interface DummyBoundaryStatistic
    extends DummyStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard timing measurements")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getCount", description="Number of times the operation was invoked since the beginning of this measurement"), @InheritedAttribute(methodName="getMaxTime", description="The maximum amount of time taken to complete one invocation of this operation since the beginning of this measurement"), @InheritedAttribute(methodName="getMinTime", description="The minimum amount of time taken to complete one invocation of this operation since the beginning of this measurement"), @InheritedAttribute(methodName="getTotalTime", description="The total amount of time taken to complete every invocation of this operation since the beginning of this measurement")})
    public static interface DummyTimeStatistic
    extends DummyStatistic {
    }

    @ManagedData
    @Description(value="The Statistic model and its sub-models specify the data models which are requried to be used to provide the performance data described by the specific attributes in the Stats models")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getName", description="The name of this Statistic"), @InheritedAttribute(methodName="getUnit", description="The unit of measurement for this Statistic"), @InheritedAttribute(methodName="getDescription", description="A human-readable description of the Statistic"), @InheritedAttribute(methodName="getStartTime", description="The time of the first measurement represented as a long"), @InheritedAttribute(methodName="getLastSampleTime", description="The time of the first measurement represented as a long")})
    public static interface DummyStatistic {
    }

    private static final class StringComparator
    implements Serializable,
    Comparator<String> {
        private static final long serialVersionUID = 8274851916877850245L;

        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return -o1.compareTo(o2);
        }
    }

    @JEEMXMetadata
    static class DefaultJEEMXMetadataHolder {
        DefaultJEEMXMetadataHolder() {
        }
    }
}

