/*
 * Decompiled with CFR 0.152.
 */
package com.bes.a4mbean.logex;

import com.bes.a4mbean.generic.OperationTracer;
import com.bes.a4mbean.logex.Chain;
import com.bes.a4mbean.logex.ExceptionWrapper;
import com.bes.a4mbean.logex.Log;
import com.bes.a4mbean.logex.Message;
import com.bes.a4mbean.logex.StackTrace;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WrapperGenerator {
    private static final ShortFormatter formatter = new ShortFormatter();

    private WrapperGenerator() {
    }

    private static int findAnnotatedParameter(Annotation[][] pannos, Class<? extends Annotation> cls) {
        for (int ctr1 = 0; ctr1 < pannos.length; ++ctr1) {
            Annotation[] annos = pannos[ctr1];
            for (int ctr2 = 0; ctr2 < annos.length; ++ctr2) {
                Annotation anno = annos[ctr2];
                if (!cls.isInstance(anno)) continue;
                return ctr1;
            }
        }
        return -1;
    }

    private static Object[] getWithSkip(Object[] args, int skip) {
        if (skip >= 0) {
            Object[] result = new Object[args.length - 1];
            int rindex = 0;
            for (int ctr = 0; ctr < args.length; ++ctr) {
                if (ctr == skip) continue;
                result[rindex++] = args[ctr];
            }
            return result;
        }
        return args;
    }

    private static ResourceBundle getResourceBundle(String name) {
        ResourceBundle rb = null;
        if (name.length() > 0) {
            try {
                rb = ResourceBundle.getBundle(name);
            }
            catch (Exception exc) {
                Logger.getLogger("com.bes.a4mbean.logex").fine("Could not load resource bundle");
            }
        }
        return rb;
    }

    private static String getMessage(ResourceBundle rb, Logger logger, Method method, int numParams, String idPrefix, int logId) {
        String msg = WrapperGenerator.getTranslatedMessage(rb, logger, method);
        if (msg == null) {
            Message message = method.getAnnotation(Message.class);
            StringBuilder sb = new StringBuilder();
            sb.append(idPrefix);
            sb.append(logId);
            sb.append(": ");
            if (message == null) {
                sb.append(method.getName());
                sb.append(' ');
                for (int ctr = 0; ctr < numParams; ++ctr) {
                    if (ctr > 0) {
                        sb.append(", ");
                    }
                    sb.append("arg");
                    sb.append(ctr);
                    sb.append("={" + ctr + "}");
                }
            } else {
                sb.append(message.value());
            }
            msg = sb.toString();
        }
        return msg;
    }

    private static void inferCaller(LogRecord lrec) {
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement frame = null;
        String wcname = "$Proxy";
        String baseName = WrapperGenerator.class.getName();
        String nestedName = WrapperGenerator.class.getName() + "$1";
        for (ix = 0; ix < stack.length && ((cname = (frame = stack[ix]).getClassName()).contains(wcname) || cname.equals(baseName) || cname.equals(nestedName)); ++ix) {
        }
        if (ix < stack.length) {
            lrec.setSourceClassName(frame.getClassName());
            lrec.setSourceMethodName(frame.getMethodName());
        }
    }

    private static Exception makeException(ReturnType rtype, boolean forceStackTrace, Class<?> rclass, Throwable cause, String msg) {
        Exception exc = null;
        try {
            if (rtype == ReturnType.NULL) {
                if (forceStackTrace) {
                    exc = new RuntimeException("StackTrace");
                }
            } else if (rtype == ReturnType.EXCEPTION) {
                Constructor<?> cons = rclass.getConstructor(String.class);
                exc = (Exception)cons.newInstance(msg);
            }
        }
        catch (InstantiationException ex) {
            exc = new RuntimeException("No <init>(String) constructor available in " + rclass + ": " + ex);
        }
        catch (IllegalAccessException ex) {
            exc = new RuntimeException("No <init>(String) constructor available in " + rclass + ": " + ex);
        }
        catch (IllegalArgumentException ex) {
            exc = new RuntimeException("No <init>(String) constructor available in " + rclass + ": " + ex);
        }
        catch (InvocationTargetException ex) {
            exc = new RuntimeException("No <init>(String) constructor available in " + rclass + ": " + ex);
        }
        catch (NoSuchMethodException ex) {
            exc = new RuntimeException("No <init>(String) constructor available in " + rclass + ": " + ex);
        }
        catch (SecurityException ex) {
            exc = new RuntimeException("No <init>(String) constructor available in " + rclass + ": " + ex);
        }
        if (exc != null && cause != null) {
            exc.initCause(cause);
        }
        return exc;
    }

    private static String getTranslatedMessage(ResourceBundle rb, Logger logger, Method method) {
        String result = null;
        if (rb != null) {
            try {
                String key = logger.getName() + "." + method.getName();
                result = rb.getString(key);
            }
            catch (Exception exc) {
                Logger.getLogger("com.bes.a4mbean.logex").fine("Could not find translated message in bundle " + rb + " for logger " + logger + " and method " + method.getName());
            }
        }
        return result;
    }

    private static String handleMessageOnly(ResourceBundle rb, Method method, Logger logger, Object[] messageParams) {
        String msg = method.getAnnotation(Message.class).value();
        String transMsg = WrapperGenerator.getTranslatedMessage(rb, logger, method);
        if (transMsg == null) {
            transMsg = msg;
        }
        String result = transMsg.indexOf("{0") >= 0 ? MessageFormat.format(transMsg, messageParams) : transMsg;
        return result;
    }

    private static ReturnType classifyReturnType(Method method) {
        Class<?> rtype = method.getReturnType();
        if (Exception.class.isAssignableFrom(rtype)) {
            return ReturnType.EXCEPTION;
        }
        if (rtype.equals(String.class)) {
            return ReturnType.STRING;
        }
        if (rtype.equals(Void.TYPE)) {
            return ReturnType.NULL;
        }
        throw new RuntimeException("Method " + method + " has an illegal return type");
    }

    private static LogRecord makeLogRecord(Level level, String key, Object[] args, boolean forceStackTrace, Logger logger) {
        LogRecord result = new LogRecord(level, key);
        if (args != null && args.length > 0) {
            result.setParameters(args);
        }
        result.setLoggerName(logger.getName());
        result.setResourceBundle(logger.getResourceBundle());
        if (forceStackTrace || level != Level.INFO) {
            WrapperGenerator.inferCaller(result);
        }
        return result;
    }

    private static Object handleFullLogging(ResourceBundle rb, Log log, Method method, Logger logger, String idPrefix, Object[] messageParams, Throwable cause) {
        Level level = log.level().getLevel();
        ReturnType rtype = WrapperGenerator.classifyReturnType(method);
        boolean forceStackTrace = method.isAnnotationPresent(StackTrace.class);
        int len = messageParams == null ? 0 : messageParams.length;
        String msgString = WrapperGenerator.getMessage(rb, logger, method, len, idPrefix, log.id());
        LogRecord lrec = WrapperGenerator.makeLogRecord(level, msgString, messageParams, forceStackTrace, logger);
        String message = formatter.format(lrec);
        Exception exc = WrapperGenerator.makeException(rtype, forceStackTrace, method.getReturnType(), cause, message);
        if (exc != null && (forceStackTrace || level != Level.INFO)) {
            lrec.setThrown(exc);
        }
        if (logger.isLoggable(level)) {
            String context = OperationTracer.getAsString();
            String newMsg = msgString;
            if (context.length() > 0) {
                newMsg = newMsg + "\nCONTEXT:" + context;
                lrec.setMessage(newMsg);
            }
            logger.log(lrec);
        }
        switch (rtype) {
            case EXCEPTION: {
                return exc;
            }
            case STRING: {
                return message;
            }
        }
        return null;
    }

    private static String getLoggerName(Class<?> cls) {
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        String str = ew.loggerName();
        if (str.length() == 0) {
            str = cls.getPackage().getName();
        }
        return str;
    }

    public static <T> T makeWrapper(final Class<T> cls) {
        if (!cls.isInterface()) {
            throw new IllegalArgumentException("Class " + cls + "is not an interface");
        }
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        final String idPrefix = ew.idPrefix();
        final String name = WrapperGenerator.getLoggerName(cls);
        final ResourceBundle rb = WrapperGenerator.getResourceBundle(ew.resourceBundle());
        InvocationHandler inh = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Annotation[][] pannos = method.getParameterAnnotations();
                int chainIndex = WrapperGenerator.findAnnotatedParameter(pannos, Chain.class);
                Throwable cause = null;
                Object[] messageParams = WrapperGenerator.getWithSkip(args, chainIndex);
                if (chainIndex >= 0) {
                    cause = (Throwable)args[chainIndex];
                }
                Logger logger = Logger.getLogger(name);
                Class<?> rtype = method.getReturnType();
                Log log = method.getAnnotation(Log.class);
                if (log == null) {
                    if (!rtype.equals(String.class)) {
                        throw new IllegalArgumentException("No @Log annotation present on " + cls.getName() + "." + method.getName());
                    }
                    return WrapperGenerator.handleMessageOnly(rb, method, logger, messageParams);
                }
                return WrapperGenerator.handleFullLogging(rb, log, method, logger, idPrefix, messageParams, cause);
            }
        };
        ClassLoader loader = cls.getClassLoader();
        Class[] classes = new Class[]{cls};
        return (T)Proxy.newProxyInstance(loader, classes, inh);
    }

    static class ShortFormatter
    extends Formatter {
        ShortFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            return sb.toString();
        }
    }

    private static enum ReturnType {
        EXCEPTION,
        STRING,
        NULL;

    }
}

