/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.base;

import com.bes.admin.jeemx.base.MBeanTrackerMBean;
import com.bes.admin.jeemx.core.JEEMXMBeanMetadata;
import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
@JEEMXMBeanMetadata(singleton=true, globalSingleton=true, leaf=true)
public final class MBeanTracker
implements NotificationListener,
MBeanRegistration,
MBeanTrackerMBean {
    final ConcurrentMap<ObjectName, Set<ObjectName>> mParentChildren = new ConcurrentHashMap<ObjectName, Set<ObjectName>>();
    final ConcurrentMap<ObjectName, ObjectName> mChildParent = new ConcurrentHashMap<ObjectName, ObjectName>();
    private volatile MBeanServer mServer;
    private volatile ObjectName mObjectName;
    private final String mDomain;
    private volatile boolean mEmitMBeanStatus;

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    public MBeanTracker(String jmxDomain) {
        this.mDomain = jmxDomain;
        this.mEmitMBeanStatus = false;
    }

    @Override
    public boolean getEmitMBeanStatus() {
        return this.mEmitMBeanStatus;
    }

    @Override
    public void setEmitMBeanStatus(boolean emit) {
        this.mEmitMBeanStatus = emit;
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        if (notifIn instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            String type = notif.getType();
            ObjectName objectName = notif.getMBeanName();
            if (this.isRelevantMBean(objectName)) {
                if (type.equals("JMX.mbean.registered")) {
                    if (this.mEmitMBeanStatus) {
                        System.out.println("JEEMX MBean registered: " + objectName);
                    }
                    this.addChild(objectName);
                } else if (type.equals("JMX.mbean.unregistered")) {
                    if (this.mEmitMBeanStatus) {
                        System.out.println("JEEMX MBean UNregistered: " + objectName);
                    }
                    this.removeChild(objectName);
                }
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        this.mServer = server;
        this.mObjectName = nameIn;
        return nameIn;
    }

    @Override
    public final void postRegister(Boolean registrationSucceeded) {
        if (registrationSucceeded.booleanValue()) {
            try {
                this.mServer.addNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not register with MBeanServerDelegate", e);
            }
        }
        ObjectName pattern = Util.newObjectNamePattern(this.mDomain, "");
        Set<ObjectName> names = JMXUtil.queryNames(this.mServer, pattern, null);
        for (ObjectName o : names) {
            this.addChild(o);
        }
    }

    @Override
    public final void preDeregister() throws Exception {
        this.mServer.removeNotificationListener(this.mObjectName, this);
    }

    @Override
    public final void postDeregister() {
    }

    private boolean isRelevantMBean(ObjectName child) {
        return child != null && this.mDomain.equals(child.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChild(ObjectName child) {
        ObjectName parent = null;
        try {
            parent = (ObjectName)this.mServer.getAttribute(child, "Parent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parent != null) {
            MBeanTracker mBeanTracker = this;
            synchronized (mBeanTracker) {
                this.mChildParent.put(child, parent);
                HashSet<ObjectName> children = (HashSet<ObjectName>)this.mParentChildren.get(parent);
                if (children == null) {
                    children = new HashSet<ObjectName>();
                    this.mParentChildren.put(parent, children);
                }
                children.add(child);
            }
        }
    }

    private synchronized ObjectName removeChild(ObjectName child) {
        Set children;
        ObjectName parent = (ObjectName)this.mChildParent.remove(child);
        if (parent != null && (children = (Set)this.mParentChildren.get(parent)) != null) {
            children.remove(child);
            if (children.size() == 0) {
                this.mParentChildren.remove(parent);
            }
        }
        return parent;
    }

    @Override
    public ObjectName getParentOf(ObjectName child) {
        return (ObjectName)this.mChildParent.get(child);
    }

    @Override
    public synchronized Set<ObjectName> getChildrenOf(ObjectName parent) {
        Set children = (Set)this.mParentChildren.get(parent);
        if (children == null) {
            return Collections.emptySet();
        }
        return new HashSet<ObjectName>(children);
    }
}

