/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.core;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.base.MBeanTrackerMBean;
import com.bes.admin.jeemx.base.Pathnames;
import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.admin.jeemx.core.Extra;
import com.bes.admin.jeemx.core.JEEMXException;
import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import com.bes.admin.jeemx.util.CollectionUtil;
import com.bes.admin.jeemx.util.ExceptionUtil;
import com.bes.admin.jeemx.util.SetUtil;
import com.bes.admin.jeemx.util.StringUtil;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public final class JEEMXValidator {
    private static final Logger sLogger = Logger.getLogger(JEEMXValidator.class.getName());
    private static final Level LEVEL_DEBUG = Level.FINE;
    private static final String NL = StringUtil.NEWLINE();
    private final MBeanServerConnection mMBeanServer;
    private final ProxyFactory mProxyFactory;
    private final DomainRoot mDomainRoot;
    private MBeanTrackerMBean mMBeanTracker;
    private volatile boolean mUnregisterNonCompliant;
    private volatile boolean mLogInaccessibleAttributes;
    private volatile String mValidationLevel;
    private static Set<Class> EXTRA_ALLOWED_TYPES = SetUtil.newTypedSet(new Object[0]);
    private static final Pattern TYPE_PATTERN = Pattern.compile("([**$a-zA-Z0-9._-][**$a-zA-Z0-9._-]*)");
    private static final Pattern NAME_PATTERN = Pattern.compile("[^]]*");

    private static void log(Level level, String msg, Throwable t) {
        sLogger.log(level, msg, t);
    }

    private static void logWarning(String msg, Throwable t) {
        JEEMXValidator.log(Level.WARNING, msg, t);
    }

    private static void logInfo(String msg, Throwable t) {
        JEEMXValidator.log(Level.INFO, msg, t);
    }

    private static void progress(Object ... args) {
        if (sLogger.isLoggable(Level.FINE)) {
            JEEMXValidator.log(Level.FINE, JEEMXValidator.toString(args), null);
        }
    }

    private static String toString(Object ... args) {
        StringBuilder buf = new StringBuilder();
        for (Object o : args) {
            buf.append("" + o);
        }
        return buf.toString();
    }

    private static void debug(Object ... args) {
        if (sLogger.isLoggable(LEVEL_DEBUG)) {
            JEEMXValidator.log(LEVEL_DEBUG, JEEMXValidator.toString(args), null);
        }
    }

    public JEEMXValidator(MBeanServerConnection conn, String validationLevel, boolean unregisterNonCompliant, boolean logInaccessibleAttributes) {
        this.mMBeanServer = conn;
        this.mProxyFactory = ProxyFactory.getInstance(conn);
        this.mDomainRoot = this.mProxyFactory.getDomainRootProxy(false);
        this.mValidationLevel = validationLevel;
        this.mUnregisterNonCompliant = unregisterNonCompliant;
        this.mLogInaccessibleAttributes = logInaccessibleAttributes;
    }

    public Set<ObjectName> filterJEEMX(Set<ObjectName> candidates) {
        HashSet<ObjectName> jeemxSet = new HashSet<ObjectName>();
        for (ObjectName cand : candidates) {
            if (cand.getKeyProperty("type") == null || !cand.getDomain().equals("jeemx")) continue;
            jeemxSet.add(cand);
        }
        return jeemxSet;
    }

    public Set<ObjectName> findAllJEEMXCompliant() {
        ObjectName pattern = Util.newObjectNamePattern("*", "*");
        Set<ObjectName> theWorld = null;
        try {
            theWorld = this.mMBeanServer.queryNames(pattern, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.filterJEEMX(theWorld);
    }

    private boolean bypassTesting(ObjectName objectName) {
        return this.checkByType(objectName) || this.checkByJ2EEType(objectName);
    }

    private boolean checkByType(ObjectName objectName) {
        return objectName.getKeyProperty("type") != null && (objectName.getKeyProperty("type").equals("Mapper") || objectName.getKeyProperty("type").equals("Connector") || objectName.getKeyProperty("type").equals("Manager") || objectName.getKeyProperty("type").equals("Engine") || objectName.getKeyProperty("type").equals("ProtocolHandler") || objectName.getKeyProperty("type").equals("Service") || objectName.getKeyProperty("type").equals("Host") || objectName.getKeyProperty("type").equals("Loader") || objectName.getKeyProperty("type").equals("JspMonitor") || objectName.getKeyProperty("type").equals("Valve"));
    }

    private boolean checkByJ2EEType(ObjectName objectName) {
        return objectName.getKeyProperty("j2eeType") != null && objectName.getKeyProperty("j2eeType").equals("WebModule") || objectName.getKeyProperty("j2eeType").equals("Servlet");
    }

    private String toString(Throwable t) {
        return ExceptionUtil.toString(ExceptionUtil.getRootCause(t));
    }

    private static boolean isAcceptableRemoteType(Class<?> c) {
        if (c.isPrimitive() || EXTRA_ALLOWED_TYPES.contains(c) || OpenType.ALLOWED_CLASSNAMES_LIST.contains(c.getName()) || c.getName().startsWith("javax.management.")) {
            return true;
        }
        return c.isArray() && JEEMXValidator.isAcceptableRemoteType(c.getComponentType());
    }

    private static void checkLegalForRemote(Object value) throws IllegalClassException {
        if (value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (JEEMXValidator.isAcceptableRemoteType(clazz)) {
            return;
        }
        if (clazz.isSynthetic() || clazz.isLocalClass() || clazz.isAnonymousClass() || clazz.isMemberClass()) {
            throw new IllegalClassException(clazz);
        }
        if (clazz.isArray()) {
            if (!JEEMXValidator.isAcceptableRemoteType(clazz.getComponentType())) {
                Object[] a;
                for (Object o : a = (Object[])value) {
                    JEEMXValidator.checkLegalForRemote(o);
                }
            }
        } else if (Collection.class.isAssignableFrom(clazz)) {
            Collection items = (Collection)value;
            for (Object o : items) {
                JEEMXValidator.checkLegalForRemote(o);
            }
        } else if (Map.class.isAssignableFrom(clazz)) {
            Map items = (Map)value;
            for (Object key : items.keySet()) {
                JEEMXValidator.checkLegalForRemote(key);
                JEEMXValidator.checkLegalForRemote(items.get(key));
            }
        } else {
            throw new IllegalClassException(clazz);
        }
    }

    static boolean instanceNotFound(Throwable t) {
        return ExceptionUtil.getRootCause(t) instanceof InstanceNotFoundException;
    }

    private void _validate(JEEMXProxy proxy, ProblemList problems) throws InstanceNotFoundException {
        block35: {
            JEEMXValidator.progress("Validate: ", proxy.objectName());
            ObjectName objectName = proxy.objectName();
            try {
                this.validateObjectName(proxy);
            }
            catch (Exception t) {
                problems.add(t);
            }
            try {
                this.validateMetadata(proxy, problems);
            }
            catch (Exception t) {
                problems.add(t);
            }
            try {
                this.validateRequiredAttributes(proxy);
            }
            catch (Exception t) {
                problems.add(t);
            }
            try {
                String name = proxy.getName();
            }
            catch (Exception t) {
                problems.add("Proxy access to 'Name' failed: ", t);
            }
            try {
                ObjectName parent = proxy.getParent();
            }
            catch (Exception t) {
                problems.add("Proxy access to 'Parent' failed: ", t);
            }
            try {
                ObjectName[] children = proxy.getChildren();
            }
            catch (Exception t) {
                problems.add("Proxy access to 'Children' failed: ", t);
            }
            Pathnames paths = this.mDomainRoot.getPathnames();
            if (paths == null) {
                throw new IllegalStateException("Pathnames MBean does not exist");
            }
            try {
                String path = proxy.path();
                ObjectName actualObjectName = proxy.objectName();
                ObjectName o = paths.resolvePath(path);
                if (o == null) {
                    if (proxy.valid()) {
                        problems.add("Path " + path + " does not resolve to any ObjectName, should resolve to: " + actualObjectName);
                    }
                } else if (!actualObjectName.equals(o)) {
                    problems.add("Path " + path + " does not resolve to ObjectName: " + actualObjectName);
                }
            }
            catch (Exception t) {
                problems.add(t);
            }
            Set<String> attributeNames = proxy.extra().attributeNames();
            for (String attrName : attributeNames) {
                try {
                    Object result = proxy.extra().getAttribute(attrName);
                    JEEMXValidator.checkLegalForRemote(result);
                }
                catch (Exception t) {
                    if (attrName.equals("Name") || attrName.equals("Parent") || attrName.equals("Children")) {
                        problems.add("Attribute failed: '" + attrName + "': ", t);
                        continue;
                    }
                    JEEMXValidator.logWarning("Attribute '" + attrName + "' failed for " + proxy.objectName(), ExceptionUtil.getRootCause(t));
                }
            }
            Object tempProblems = null;
            try {
                this.validateChildren(proxy);
            }
            catch (Exception t) {
                problems.add(t);
            }
            try {
                JEEMXProxy parent = proxy.parent();
                if (parent == null && !proxy.type().equals(Util.deduceType(DomainRoot.class))) {
                    ObjectName parentObjectName = proxy.getParent();
                    boolean exists = this.mMBeanServer.isRegistered(proxy.objectName());
                    problems.add("Null parent for " + proxy.objectName() + ", isRegistered(self) = " + exists + ", parent = " + parentObjectName);
                }
                String nameProp = proxy.nameProp();
                boolean valid = proxy.valid();
                String path = proxy.path();
                Extra extra = proxy.extra();
                String interfaceName = extra.interfaceName();
                MBeanInfo mbeanInfo = extra.mbeanInfo();
                String group = extra.group();
                Class<? extends JEEMXProxy> genericInterface = extra.genericInterface();
                boolean invariantMBeanInfo = extra.isInvariantMBeanInfo();
                boolean supportsAdoption = extra.supportsAdoption();
                String[] subTypes = extra.subTypes();
                Set<JEEMXProxy> childrenSet = proxy.childrenSet();
                Map<String, Map<String, JEEMXProxy>> childrenMaps = proxy.childrenMaps();
                Map<String, Object> attributesMap = proxy.attributesMap();
                Set<String> attrNames = proxy.attributeNames();
                if (!((Object)attrNames).equals(attributesMap.keySet())) {
                    HashSet<String> keys = new HashSet<String>(attributesMap.keySet());
                    keys.removeAll(attrNames);
                    if (keys.size() != 0) {
                        throw new Exception("Attributes Map contains attributes not found in the MBeanInfo: " + keys);
                    }
                    if (this.mLogInaccessibleAttributes) {
                        HashSet<String> missing = new HashSet<String>(attrNames);
                        missing.removeAll(attributesMap.keySet());
                        JEEMXValidator.logInfo("Inaccessible attributes: " + missing + " in " + proxy.objectName(), null);
                    }
                }
                for (JEEMXProxy child : childrenSet) {
                    if (!child.extra().singleton()) continue;
                    String childType = child.type();
                    if (child.objectName().equals(proxy.child(childType).objectName())) continue;
                    throw new Exception("Child type " + childType + " cannot be found via child(type)");
                }
                for (String type : childrenMaps.keySet()) {
                    Map<String, JEEMXProxy> m = proxy.childrenMap(type);
                    if (m.keySet().size() != 0) continue;
                    throw new Exception("Child type " + type + " has nothing in Map");
                }
            }
            catch (Exception t) {
                problems.add("General test failure: ", t);
            }
            try {
                this.validateJEEMXConfig(proxy, problems);
            }
            catch (Exception t) {
                if (!proxy.valid()) break block35;
                problems.add("General test failure in validateJEEMXConfig: ", t);
            }
        }
    }

    private void fail(ObjectName objectName, String msg) throws ValidationFailureException {
        throw new ValidationFailureException(objectName, msg);
    }

    private void fail(JEEMXProxy jeemx, String msg) throws ValidationFailureException {
        throw new ValidationFailureException(jeemx, msg);
    }

    private void validateJEEMXConfig(JEEMXProxy proxy, ProblemList problems) throws InstanceNotFoundException {
        if (!JEEMXConfigProxy.class.isAssignableFrom(proxy.extra().genericInterface())) {
            return;
        }
        JEEMXConfigProxy config = proxy.as(JEEMXConfigProxy.class);
        if (!config.type().equals("domain") && !JEEMXConfigProxy.class.isAssignableFrom(config.parent().extra().genericInterface())) {
            problems.add("JEEMXConfig MBean is not a descendant of Domain: " + config.objectName() + ", it has parent " + config.getParent());
        }
        Map<String, String> defaultValues = config.getDefaultValues(false);
        Map<String, String> defaultValuesJEEMX = config.getDefaultValues(true);
        if (defaultValues.keySet().size() != defaultValuesJEEMX.keySet().size()) {
            problems.add("Default values for JEEMX names differ in number from XML names: " + defaultValues.keySet().size() + " != " + defaultValuesJEEMX.keySet().size());
        }
        for (String key : defaultValues.keySet()) {
            String value = defaultValues.get(key);
            if (value == null) {
                problems.add("Default value of null for: " + key);
                continue;
            }
            if (value instanceof String) continue;
            problems.add("Default value is not a String for: " + key);
        }
        String[] subTypes = config.extra().subTypes();
        if (subTypes != null) {
            for (String subType : subTypes) {
                Map<String, String> subTypeDefaults = config.getDefaultValues(subType, false);
            }
        }
    }

    private void validateObjectName(JEEMXProxy proxy) throws ValidationFailureException {
        String nameProp;
        ObjectName objectName = proxy.objectName();
        String type = objectName.getKeyProperty("type");
        if (type == null || type.length() == 0) {
            this.fail(objectName, "type property required in ObjectName");
        }
        if (!TYPE_PATTERN.matcher(type).matches()) {
            this.fail(objectName, "Illegal type \"" + type + "\", does not match " + TYPE_PATTERN.pattern());
        }
        if ((nameProp = objectName.getKeyProperty("name")) != null) {
            if (nameProp.length() == 0) {
                this.fail(objectName, "name property of ObjectName may not be empty");
            }
            if (!NAME_PATTERN.matcher(nameProp).matches()) {
                this.fail(objectName, "Illegal name \"" + nameProp + "\", does not match " + NAME_PATTERN.pattern());
            }
        } else {
            String name = proxy.getName();
            if (!proxy.extra().singleton()) {
                this.fail(objectName, "Metadata claims named (non-singleton), but no name property present in ObjectName");
            }
        }
        if (proxy.parent() != null && !proxy.parentPath().equals(proxy.parent().path())) {
            this.fail(objectName, "Parent path of " + proxy.parentPath() + " does not match parent's path for  parent " + proxy.parent().objectName());
        }
    }

    private void validateChildren(JEEMXProxy proxy) throws ValidationFailureException {
        block19: {
            Set<String> attrNames = proxy.attributeNames();
            if (!attrNames.contains("Children")) {
                try {
                    ObjectName[] children = proxy.getChildren();
                    this.fail(proxy, "MBean has no Children attribute in its MBeanInfo, but supplies the attribute");
                }
                catch (Exception e) {}
            } else {
                block18: {
                    try {
                        Set<ObjectName> childrenSetNow;
                        Set<ObjectName> childrenSet;
                        ObjectName[] children = proxy.getChildren();
                        if (children == null) {
                            this.fail(proxy, "Children attribute must be non-null");
                        }
                        if ((childrenSet = SetUtil.newSet(children)).size() != children.length) {
                            this.fail(proxy, "Children contains duplicates");
                        }
                        if (childrenSet.contains(null)) {
                            this.fail(proxy, "Children contains null");
                        }
                        for (ObjectName childObjectName : children) {
                            if (childObjectName == null) {
                                this.fail(proxy, "Child in Children array is null");
                            }
                            JEEMXProxy child = this.mProxyFactory.getProxy(childObjectName);
                            if (proxy.objectName().equals(child.parent().objectName())) continue;
                            this.fail(proxy, "Child\u2019s Parent of " + child.parent().objectName() + " does not match the actual parent of " + proxy.objectName());
                        }
                        HashSet<String> caseSensitiveTypes = new HashSet<String>();
                        HashSet<String> caseInsensitiveTypes = new HashSet<String>();
                        for (ObjectName o : children) {
                            caseSensitiveTypes.add(Util.getTypeProp(o));
                            caseInsensitiveTypes.add(Util.getTypeProp(o).toLowerCase());
                        }
                        if (caseSensitiveTypes.size() != caseInsensitiveTypes.size()) {
                            this.fail(proxy, "Children types must be case-insensitive");
                        }
                        Set<ObjectName> tracked = this.getMBeanTracker().getChildrenOf(proxy.objectName());
                        if (childrenSet.size() != children.length && !((Object)tracked).equals(childrenSetNow = SetUtil.newSet(proxy.getChildren()))) {
                            this.fail(proxy, "MBeanTracker has different MBeans than the MBean: {" + CollectionUtil.toString(tracked, ", ") + "} vs MBean having {" + CollectionUtil.toString(childrenSetNow, ", ") + "}");
                        }
                    }
                    catch (Exception e) {
                        if (JEEMXValidator.instanceNotFound(e)) break block18;
                        this.fail(proxy, "MBean failed to supply Children attribute");
                    }
                }
                try {
                    Map<String, Map<String, JEEMXProxy>> maps = proxy.childrenMaps();
                    for (String type : maps.keySet()) {
                        Map<String, JEEMXProxy> siblings = maps.get(type);
                        if (siblings.keySet().size() <= 1) continue;
                        Iterator<JEEMXProxy> iter = siblings.values().iterator();
                        MBeanInfo mbeanInfo = iter.next().extra().mbeanInfo();
                        while (iter.hasNext()) {
                            JEEMXProxy next = iter.next();
                            if (mbeanInfo.equals(next.extra().mbeanInfo())) continue;
                            this.fail(proxy, "Children of type=" + type + " must  have the same MBeanInfo: " + siblings.values());
                        }
                    }
                }
                catch (Exception e) {
                    if (JEEMXValidator.instanceNotFound(e)) break block19;
                    JEEMXValidator.logWarning("MBean failed validating the MBeanInfo of children", e);
                    this.fail(proxy, "MBean failed validating the MBeanInfo of children with Exception: " + e.getMessage());
                }
            }
        }
    }

    private MBeanTrackerMBean getMBeanTracker() {
        if (this.mMBeanTracker == null) {
            this.mMBeanTracker = MBeanServerInvocationHandler.newProxyInstance(this.mMBeanServer, MBeanTrackerMBean.MBEAN_TRACKER_OBJECT_NAME, MBeanTrackerMBean.class, false);
        }
        return this.mMBeanTracker;
    }

    private static boolean isLegalClassname(String s) {
        return s.length() != 0 && s.indexOf(" ") < 0;
    }

    private void checkLegalAttributeType(String clazz, String attrName, ProblemList problems) throws InstanceNotFoundException {
        if (!JEEMXValidator.isLegalClassname(clazz)) {
            problems.add("Illegal classname for attribute " + StringUtil.quote(attrName) + ": " + StringUtil.quote(clazz));
        }
    }

    private void checkLegalReturnType(String clazz, String operation, ProblemList problems) throws InstanceNotFoundException {
        if (!JEEMXValidator.isLegalClassname(clazz)) {
            problems.add("Illegal return type for " + operation + "(): " + StringUtil.quote(clazz));
        }
    }

    private void validateMetadata(JEEMXProxy proxy, ProblemList problems) throws InstanceNotFoundException {
        MBeanInfo mbeanInfo = proxy.extra().mbeanInfo();
        Descriptor d = mbeanInfo.getDescriptor();
        Set<String> LEGAL_JEEMX_DESCRIPTORS = SetUtil.newStringSet("jeemx.genericInterfaceName", "jeemx.isSingleton", "jeemx.isGlobalSingleton", "jeemx.group", "jeemx.supportsAdoption", "jeemx.subTypes");
        for (String fieldName : d.getFieldNames()) {
            if (!fieldName.startsWith("jeemx.") || LEGAL_JEEMX_DESCRIPTORS.contains(fieldName)) continue;
            problems.add("Illegal/unknown JEEMX metadata field: " + fieldName + " = " + d.getFieldValue(fieldName));
        }
        MetadataValidator val = new MetadataValidator(d, problems);
        val.validateMetadataBoolean("jeemx.isSingleton");
        val.validateMetadataBoolean("jeemx.supportsAdoption");
        val.validateMetadataBoolean("immutableInfo");
        val.validateMetadataString("interfaceName");
        val.validateMetadataString("jeemx.genericInterfaceName");
        val.validateMetadataString("jeemx.group");
        val.validate("jeemx.subTypes", String[].class);
        for (MBeanAttributeInfo mBeanAttributeInfo : mbeanInfo.getAttributes()) {
            this.checkLegalAttributeType(mBeanAttributeInfo.getType(), mBeanAttributeInfo.getName(), problems);
            new MetadataValidator(mBeanAttributeInfo.getDescriptor(), problems);
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getOperations()) {
            this.checkLegalReturnType(((MBeanOperationInfo)mBeanFeatureInfo).getReturnType(), mBeanFeatureInfo.getName(), problems);
            new MetadataValidator(mBeanFeatureInfo.getDescriptor(), problems);
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getConstructors()) {
            new MetadataValidator(mBeanFeatureInfo.getDescriptor(), problems);
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getNotifications()) {
            new MetadataValidator(mBeanFeatureInfo.getDescriptor(), problems);
        }
        if (proxy.extra().globalSingleton()) {
            ObjectName objectName = proxy.objectName();
            ObjectName pattern = Util.newObjectNamePattern(objectName.getDomain(), Util.makeTypeProp(Util.getTypeProp(objectName)));
            try {
                long start = System.currentTimeMillis();
                Set<ObjectName> instances = this.mMBeanServer.queryNames(pattern, null);
                long elapsed = System.currentTimeMillis() - start;
                if (instances.size() > 1) {
                    problems.add("Global singleton " + objectName + " conflicts with other MBeans of the same type: " + CollectionUtil.toString(instances, ", "));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateRequiredAttributes(JEEMXProxy proxy) throws ValidationFailureException {
        ObjectName objectName = proxy.objectName();
        Map<String, MBeanAttributeInfo> infos = JMXUtil.attributeInfosToMap(proxy.extra().mbeanInfo().getAttributes());
        Set<String> attrNames = infos.keySet();
        if (!attrNames.contains("Name")) {
            this.fail(objectName, "MBeanInfo does not contain Name attribute");
        }
        if (!attrNames.contains("Parent")) {
            this.fail(objectName, "MBeanInfo does not contain Parent attribute");
        }
        if (attrNames.contains("Children")) {
            try {
                if (proxy.getChildren() != null) return;
                this.fail(objectName, "value of Children attribute must not be null");
                return;
            }
            catch (JEEMXException e) {
                throw e;
            }
            catch (Exception e) {
                if (JEEMXValidator.instanceNotFound(e)) return;
                this.fail(objectName, "does not supply children correctly");
                return;
            }
        }
        try {
            proxy.getChildren();
            this.fail(objectName, "Children attribute is present, but not listed in MBeanInfo");
            return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void unregisterNonCompliantMBean(ObjectName objectName) {
        if (this.mUnregisterNonCompliant) {
            try {
                this.mMBeanServer.unregisterMBean(objectName);
                JEEMXValidator.logWarning("Unregistered non-compliant MBean " + objectName, null);
            }
            catch (Exception ignore) {
                JEEMXValidator.logWarning("Unable to unregister non-compliant MBean " + objectName, null);
            }
        }
    }

    public ValidationResult validate(Collection<ObjectName> c) {
        ObjectName[] targets = CollectionUtil.toArray(c, ObjectName.class);
        return this.validate(targets);
    }

    public ValidationResult validate(ObjectName[] targets) {
        long startMillis = System.currentTimeMillis();
        Failures failures = new Failures();
        DomainRoot dr = this.mDomainRoot;
        for (ObjectName objectName : targets) {
            JEEMXValidator.progress("JEEMXValidator.validate(), begin: " + objectName);
            ProblemList problems = new ProblemList(objectName);
            JEEMXProxy jeemx = null;
            try {
                jeemx = this.mProxyFactory.getProxy(objectName);
                if (jeemx == null) {
                    continue;
                }
            }
            catch (Exception e) {
                if (JEEMXValidator.instanceNotFound(e)) {
                    JEEMXValidator.progress("JEEMXValidator.validate(), InstanceNotFound: " + objectName);
                    continue;
                }
                String msg = "Cannot create JEEMXProxy for MBean \"" + objectName;
                JEEMXValidator.progress(msg);
                problems.add(msg);
            }
            if (jeemx != null) {
                try {
                    this._validate(jeemx, problems);
                }
                catch (InstanceNotFoundException e) {
                    continue;
                }
                catch (Exception e) {
                    JEEMXValidator.logWarning("JEEMXValidator.validate(): got exception from _validate for " + objectName, e);
                    problems.add("Validation failure for MBean " + objectName + e);
                }
            }
            if (problems.hasProblems() && !problems.instanceNotFound()) {
                JEEMXValidator.debug("JEEMXValidator.validate(): got problems from _validate for " + objectName + " : " + problems);
                this.unregisterNonCompliantMBean(objectName);
                failures.result(problems);
            }
            JEEMXValidator.progress("JEEMXValidator.validate(): validated: " + objectName);
        }
        long elapsedMillis = System.currentTimeMillis() - startMillis;
        ValidationResult result = new ValidationResult(failures);
        return result;
    }

    public ValidationResult validate(ObjectName objectName) {
        return this.validate(new ObjectName[]{objectName});
    }

    public ValidationResult validate() {
        List<ObjectName> all = Util.toObjectNameList(this.mDomainRoot.getQueryMgr().queryAll());
        return this.validate(CollectionUtil.toArray(all, ObjectName.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ValidationResult {
        private final String mDetails;
        private final int mNumTested;
        private final int mNumFailures;
        private final Map<ObjectName, ProblemList> mProblems;

        public ValidationResult(Failures failures) {
            this.mNumTested = failures.getNumTested();
            this.mNumFailures = failures.getNumFailures();
            this.mDetails = failures.toString();
            this.mProblems = failures.getFailures();
        }

        public String details() {
            return this.mDetails;
        }

        public Map<ObjectName, ProblemList> failures() {
            return this.mProblems;
        }

        public int numTested() {
            return this.mNumTested;
        }

        public int numFailures() {
            return this.mNumFailures;
        }

        public String toString() {
            return this.details();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetadataValidator {
        private final Descriptor mDescriptor;
        private final Set<String> mFieldNames;
        private final ProblemList mProblems;

        public MetadataValidator(Descriptor d, ProblemList problems) throws InstanceNotFoundException {
            this.mDescriptor = d;
            this.mFieldNames = SetUtil.newSet(d.getFieldNames());
            this.mProblems = problems;
            this.validateRemote();
        }

        void validateRemote() throws InstanceNotFoundException {
            for (String fieldName : this.mFieldNames) {
                try {
                    JEEMXValidator.checkLegalForRemote(this.mDescriptor.getFieldValue(fieldName));
                }
                catch (IllegalClassException e) {
                    this.mProblems.add("Descriptor field " + fieldName + " uses a remote-unfriendly class: " + e.clazz().getName());
                }
            }
        }

        void validateMetadataBoolean(String fieldName) throws InstanceNotFoundException {
            if (this.mFieldNames.contains(fieldName)) {
                Object value = this.mDescriptor.getFieldValue(fieldName);
                if (value == null) {
                    this.mProblems.add("Descriptor field " + fieldName + " must not be null");
                } else if (!(value instanceof Boolean || value.equals("true") || value.equals("false"))) {
                    this.mProblems.add("Descriptor field " + fieldName + " must be set to 'true' or 'false', value is " + value);
                }
            }
        }

        void validateMetadataString(String fieldName) throws InstanceNotFoundException {
            Object value;
            if (this.mFieldNames.contains(fieldName) && (value = this.mDescriptor.getFieldValue(fieldName)) != null && !(value instanceof String)) {
                this.mProblems.add("Descriptor field " + fieldName + " must be a String!");
            }
        }

        void validate(String fieldName, Class<?> clazz) throws InstanceNotFoundException {
            Object value;
            if (this.mFieldNames.contains(fieldName) && ((value = this.mDescriptor.getFieldValue(fieldName)) == null || !clazz.isAssignableFrom(value.getClass()))) {
                this.mProblems.add("Descriptor field " + fieldName + " must be of class " + clazz.getSimpleName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProblemList {
        final ObjectName mObjectName;
        final List<String> mProblems;
        boolean mInstanceNotFound;

        public ProblemList(ObjectName objectName) {
            this.mObjectName = objectName;
            this.mProblems = new ArrayList<String>();
            this.mInstanceNotFound = false;
        }

        public List<String> getProblems() {
            return this.mProblems;
        }

        public ObjectName getObjectName() {
            return this.mObjectName;
        }

        public boolean hasProblems() {
            return this.mProblems.size() != 0;
        }

        public boolean instanceNotFound() {
            return this.mInstanceNotFound;
        }

        private void add(String msg) {
            try {
                this.add(msg, null);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
        }

        private void add(Throwable t) throws InstanceNotFoundException {
            this.add("", t);
        }

        private void add(String msg, Throwable t) throws InstanceNotFoundException {
            if (t == null) {
                this.mProblems.add(msg);
            } else {
                Throwable rootCause = ExceptionUtil.getRootCause(t);
                if (JEEMXValidator.instanceNotFound(rootCause)) {
                    this.mInstanceNotFound = true;
                    throw new InstanceNotFoundException("" + this.mObjectName);
                }
                this.mProblems.add(msg + "\n" + ExceptionUtil.toString(rootCause));
            }
        }

        public String toString() {
            if (this.mInstanceNotFound) {
                return "MBean " + this.mObjectName + " unregistered while being validated";
            }
            return "MBean " + this.mObjectName + " problems: " + NL + CollectionUtil.toString(this.mProblems, NL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Failures {
        private final ConcurrentMap<ObjectName, ProblemList> mFailures = new ConcurrentHashMap<ObjectName, ProblemList>();
        private AtomicInteger mNumTested = new AtomicInteger();

        public int getNumTested() {
            return this.mNumTested.get();
        }

        public int getNumFailures() {
            return this.mFailures.keySet().size();
        }

        public Map<ObjectName, ProblemList> getFailures() {
            return this.mFailures;
        }

        void result(ProblemList problems) {
            this.mNumTested.incrementAndGet();
            if (problems.hasProblems()) {
                if (problems.instanceNotFound()) {
                    return;
                }
                this.mFailures.put(problems.getObjectName(), problems);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (ObjectName badBoy : this.mFailures.keySet()) {
                ProblemList problems = (ProblemList)this.mFailures.get(badBoy);
                builder.append(badBoy + NL);
                builder.append(CollectionUtil.toString(problems.getProblems(), NL));
                builder.append(NL);
                builder.append(NL);
            }
            builder.append(this.mFailures.size() + " failures.");
            return builder.toString() + NL + this.mNumTested + " MBeans tested.";
        }
    }

    private static final class ValidationFailureException
    extends Exception {
        private final ObjectName mObjectName;

        public ValidationFailureException(ObjectName objectName, String msg) {
            super(msg);
            this.mObjectName = objectName;
        }

        public ValidationFailureException(JEEMXProxy jeemx, String msg) {
            this(jeemx.objectName(), msg);
        }

        public ObjectName objectName() {
            return this.mObjectName;
        }

        public String toString() {
            return this.getMessage() + ", " + this.mObjectName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IllegalClassException
    extends Exception {
        private final Class<?> mClass;

        public IllegalClassException(Class<?> clazz) {
            super("Class " + clazz.getName() + " not allowed for JEEMX MBeans");
            this.mClass = clazz;
        }

        public Class<?> clazz() {
            return this.mClass;
        }

        @Override
        public String toString() {
            return super.getMessage();
        }
    }
}

