/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.core;

import com.bes.admin.jeemx.core.JEEMXMBeanMetadata;
import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.util.ClassUtil;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public final class Util {
    private static final String QUOTE_CHAR = "\"";
    public static final String TYPE_FIELD = "JEEMX_TYPE";
    static final String[] PROPERTY_PREFIX = new String[]{"get", "set", "is", "has"};
    static final Pattern TOKENIZER;

    private static void debug(String s) {
        System.out.println(s);
    }

    public static String quoteIfNeeded(String name) {
        if (name.indexOf(":") > 1 || name.indexOf("=") > 1) {
            return ObjectName.quote(name);
        }
        return name;
    }

    public static String unquoteIfNeeded(String name) {
        if (name != null && name.startsWith(QUOTE_CHAR) && name.endsWith(QUOTE_CHAR)) {
            return ObjectName.unquote(name);
        }
        return name;
    }

    private Util() {
    }

    public static ObjectName newObjectName(String name) {
        return JMXUtil.newObjectName(name);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return Util.newObjectName(domain + ":" + props);
    }

    public static ObjectName newObjectNamePattern(String domain, String props) {
        return JMXUtil.newObjectNamePattern(domain, props);
    }

    public static ObjectName newObjectNamePattern(ObjectName objectName) {
        String props = objectName.getKeyPropertyListString();
        return Util.newObjectNamePattern(objectName.getDomain(), props);
    }

    public static String makeProp(String name, String value) {
        return JMXUtil.makeProp(name, value);
    }

    public static String makeTypeProp(String value) {
        return Util.makeProp("type", value);
    }

    public static String makeNameProp(String name) {
        return Util.makeProp("name", "" + Util.quoteIfNeeded(name));
    }

    public static String makeRequiredProps(String type, String name) {
        String props = Util.makeTypeProp(type);
        if (name != null && name.length() != 0 && !name.equals("")) {
            String nameProp = Util.makeNameProp(name);
            props = Util.concatenateProps(props, nameProp);
        }
        return props;
    }

    public static String getSelfProp(ObjectName objectName) {
        String type = objectName.getKeyProperty("type");
        String name = objectName.getKeyProperty("name");
        return Util.makeProp(type, name);
    }

    public static String getAdditionalProps(ObjectName objectName) {
        Hashtable<String, String> allProps = objectName.getKeyPropertyList();
        allProps.remove("type");
        allProps.remove("name");
        String props = "";
        for (String key : allProps.keySet()) {
            String prop = Util.makeProp(key, allProps.get(key));
            props = Util.concatenateProps(props, prop);
        }
        return props;
    }

    public static String concatenateProps(String props1, String props2) {
        return JMXUtil.concatenateProps(props1, props2);
    }

    public static String concatenateProps(String props1, String props2, String props3) {
        return Util.concatenateProps(Util.concatenateProps(props1, props2), props3);
    }

    public static List<ObjectName> toObjectNameList(Collection<? extends JEEMXProxy> jeemxs) {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        for (JEEMXProxy jEEMXProxy : jeemxs) {
            objectNames.add(jEEMXProxy.objectName());
        }
        return Collections.checkedList(objectNames, ObjectName.class);
    }

    public static Map<String, ObjectName> toObjectNameMap(Map<String, ? extends JEEMXProxy> jeemxMap) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (String key : jeemxMap.keySet()) {
            JEEMXProxy value = jeemxMap.get(key);
            m.put(key, value.objectName());
        }
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static ObjectName[] toObjectNamesArray(JEEMXProxy[] jeemx) {
        ObjectName[] objectNames = new ObjectName[jeemx.length];
        for (int i = 0; i < objectNames.length; ++i) {
            objectNames[i] = jeemx[i] == null ? null : jeemx[i].objectName();
        }
        return objectNames;
    }

    public static ObjectName[] toObjectNamesArray(Collection<? extends JEEMXProxy> jeemxs) {
        ObjectName[] objectNames = new ObjectName[jeemxs.size()];
        int i = 0;
        for (JEEMXProxy jEEMXProxy : jeemxs) {
            objectNames[i] = jEEMXProxy.objectName();
            ++i;
        }
        return objectNames;
    }

    public static <T extends JEEMXProxy> Map<String, T> createNameMap(Set<T> jeemxs) {
        HashMap<String, JEEMXProxy> m = new HashMap<String, JEEMXProxy>();
        for (JEEMXProxy jeemx : jeemxs) {
            String name = jeemx.getName();
            m.put(name, jeemx);
        }
        return m;
    }

    public static final Map<String, ObjectName> createObjectNameMap(Set<ObjectName> objectNames) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (ObjectName objectName : objectNames) {
            String name = Util.getNameProp(objectName);
            assert (!m.containsKey(name)) : "createObjectNameMap: key already present: " + name + " in " + objectName;
            m.put(name, objectName);
        }
        assert (m.keySet().size() == objectNames.size());
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static <T extends JEEMXProxy> List<T> asProxyList(Collection<? extends JEEMXProxy> c, Class<T> intf) {
        ArrayList<T> list = new ArrayList<T>();
        for (JEEMXProxy jEEMXProxy : c) {
            list.add(jEEMXProxy.as(intf));
        }
        return list;
    }

    public static Map<String, Serializable> getJEEMXNotificationData(Notification notif) {
        return Collections.unmodifiableMap(JMXUtil.getUserDataMapString_Serializable(notif));
    }

    public static Serializable getJEEMXNotificationValue(Notification notif, String key) {
        Map<String, Serializable> data = Util.getJEEMXNotificationData(notif);
        if (data == null) {
            throw new IllegalArgumentException(notif.toString());
        }
        if (!data.containsKey(key)) {
            throw new IllegalArgumentException("Value not found for " + key + " in " + notif);
        }
        return data.get(key);
    }

    public static <T extends Serializable> T getJEEMXNotificationValue(Notification notif, String key, Class<T> theClass) {
        Serializable value = Util.getJEEMXNotificationValue(notif, key);
        return (T)((Serializable)theClass.cast(value));
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static JEEMXProxy asJEEMX(Object o) {
        return (JEEMXProxy)JEEMXProxy.class.cast(o);
    }

    public static <T extends JEEMXProxy> Set<T> filterJEEMX(Set<T> candidates, Class<?> desired) {
        HashSet<JEEMXProxy> result = new HashSet<JEEMXProxy>();
        for (JEEMXProxy jeemx : candidates) {
            if (!desired.isAssignableFrom(jeemx.getClass())) continue;
            result.add(jeemx);
        }
        return result;
    }

    public static Map<String, ObjectName> filterByType(ObjectName[] objectNames, String type) {
        HashMap<String, ObjectName> m = null;
        if (objectNames != null) {
            m = new HashMap<String, ObjectName>();
            for (ObjectName o : objectNames) {
                if (!type.equals(o.getKeyProperty("type"))) continue;
                m.put(o.getKeyProperty("name"), o);
            }
        }
        return m;
    }

    public static <T extends JEEMXProxy> Map<String, T> filterJEEMX(Map<String, T> candidates, Class<?> desired) {
        HashMap<String, JEEMXProxy> result = new HashMap<String, JEEMXProxy>();
        for (String key : candidates.keySet()) {
            JEEMXProxy jeemx = (JEEMXProxy)candidates.get(key);
            if (!desired.isAssignableFrom(jeemx.getClass())) continue;
            result.put(key, jeemx);
        }
        return result;
    }

    public static String getTypeProp(ObjectName objectName) {
        return objectName.getKeyProperty("type");
    }

    public static String getNameProp(ObjectName objectName) {
        return objectName.getKeyProperty("name");
    }

    public static String getParentPathProp(ObjectName objectName) {
        return objectName.getKeyProperty("pp");
    }

    public static String getParentPathProp(JEEMXProxy jeemx) {
        return Util.getParentPathProp(jeemx.extra().objectName());
    }

    public static ObjectName getParent(MBeanServer server, ObjectName objectName) {
        return (ObjectName)JMXUtil.getAttribute(server, objectName, "Parent");
    }

    public static String typeFromName(String s) {
        if (s.indexOf("-") >= 0) {
            return s;
        }
        String simpleName = s;
        int idx = s.lastIndexOf(".");
        if (idx >= 0) {
            simpleName = s.substring(idx + 1);
        }
        return Util.domConvertName(simpleName);
    }

    public static String deduceType(Class<?> intf) {
        String typeValue;
        if (intf == null) {
            throw new IllegalArgumentException("Null interface");
        }
        String type = null;
        JEEMXMBeanMetadata meta = null;
        Object typeField = ClassUtil.getFieldValue(intf, TYPE_FIELD);
        type = typeField instanceof String ? (String)typeField : ((meta = intf.getAnnotation(JEEMXMBeanMetadata.class)) != null ? ((typeValue = meta.type()).equals("\u0000") || typeValue.length() == 0 ? Util.typeFromName(intf.getName()) : typeValue) : Util.typeFromName(intf.getName()));
        return type;
    }

    public static ObjectName getAncestorByType(MBeanServer mbeanServer, ObjectName child, String type) {
        ObjectName cur = child;
        while ((cur = (ObjectName)JMXUtil.getAttribute(mbeanServer, cur, "Parent")) != null && !Util.getTypeProp(cur).equals(type)) {
        }
        return cur;
    }

    private static String domConvertName(String nameIn) {
        String name = nameIn;
        for (String p : PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    static {
        String pattern = Util.or(Util.split("x", "X"), Util.split("X", "Xx"), Util.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
    }
}

